/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.debugadapter.variable.types;

import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.LinkedHashMap;
import java.util.Map;
import org.ballerinalang.debugadapter.SuspendedContext;
import org.ballerinalang.debugadapter.variable.BVariableType;
import org.ballerinalang.debugadapter.variable.NamedCompoundVariable;
import org.ballerinalang.debugadapter.variable.VariableUtils;

public class BObject
extends NamedCompoundVariable {
    private static final String OBJECT_FIELD_PATTERN_IDENTIFIER = "values.$";

    public BObject(SuspendedContext context, String name, Value value) {
        this(context, name, BVariableType.OBJECT, value);
    }

    public BObject(SuspendedContext context, String name, BVariableType bVarType, Value value) {
        super(context, name, bVarType, value);
    }

    @Override
    public String computeValue() {
        return VariableUtils.getBType(this.jvmValue);
    }

    @Override
    public Map<String, Value> computeChildVariables() {
        try {
            Value value2 = this.jvmValue;
            if (!(value2 instanceof ObjectReference)) {
                return new LinkedHashMap<String, Value>();
            }
            ObjectReference jvmValueRef = (ObjectReference)value2;
            Map<Field, Value> fieldValueMap = jvmValueRef.getValues(jvmValueRef.referenceType().allFields());
            LinkedHashMap<String, Value> values = new LinkedHashMap<String, Value>();
            fieldValueMap.forEach((field, value) -> {
                if (field.toString().contains(OBJECT_FIELD_PATTERN_IDENTIFIER)) {
                    values.put(field.name(), (Value)value);
                }
            });
            return values;
        }
        catch (Exception ignored) {
            return new LinkedHashMap<String, Value>();
        }
    }

    @Override
    public int getChildrenCount() {
        try {
            Value value = this.jvmValue;
            if (!(value instanceof ObjectReference)) {
                return 0;
            }
            ObjectReference jvmValueRef = (ObjectReference)value;
            Map<Field, Value> fieldValueMap = jvmValueRef.getValues(jvmValueRef.referenceType().allFields());
            long objectFieldCount = fieldValueMap.keySet().stream().filter(field -> field.toString().contains(OBJECT_FIELD_PATTERN_IDENTIFIER)).count();
            return Long.valueOf(objectFieldCount).intValue();
        }
        catch (Exception ignored) {
            return 0;
        }
    }
}

