/*
 * Decompiled with CFR 0.152.
 */
package com.github.mustachejava.codes;

import com.github.mustachejava.Binding;
import com.github.mustachejava.Code;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.ObjectHandler;
import com.github.mustachejava.TemplateContext;
import java.io.IOException;
import java.io.Writer;
import java.util.HashSet;
import java.util.Set;

public class DefaultCode
implements Code,
Cloneable {
    protected String appended;
    protected Mustache mustache;
    protected final ObjectHandler oh;
    protected final String name;
    protected final TemplateContext tc;
    protected final String type;
    protected final boolean returnThis;
    protected final Binding binding;

    @Override
    public Object clone() {
        HashSet<Code> seen = new HashSet<Code>();
        seen.add(this);
        return this.clone(seen);
    }

    @Override
    public Object clone(Set<Code> seen) {
        try {
            DefaultCode code = (DefaultCode)super.clone();
            Code[] codes = code.getCodes();
            if (codes != null) {
                codes = (Code[])codes.clone();
                for (int i = 0; codes != null && i < codes.length; ++i) {
                    if (!seen.add(codes[i])) continue;
                    codes[i] = (Code)codes[i].clone(seen);
                    seen.remove(codes[i]);
                }
                code.setCodes(codes);
            }
            if (this.mustache != null && seen.add(this.mustache)) {
                code.mustache = (Mustache)this.mustache.clone(seen);
                seen.remove(this.mustache);
            }
            return code;
        }
        catch (CloneNotSupportedException e) {
            throw new MustacheException("Clone not supported");
        }
    }

    public DefaultCode() {
        this(null, null, null, null, null);
    }

    public DefaultCode(TemplateContext tc, ObjectHandler oh, Mustache mustache, String name, String type) {
        this.oh = oh;
        this.mustache = mustache;
        this.type = type;
        this.name = name;
        this.tc = tc;
        this.binding = oh == null ? null : oh.createBinding(name, tc, this);
        this.returnThis = ".".equals(name);
    }

    @Override
    public Code[] getCodes() {
        return this.mustache == null ? null : this.mustache.getCodes();
    }

    @Override
    public synchronized void init() {
        Code[] codes = this.getCodes();
        if (codes != null) {
            for (Code code : codes) {
                code.init();
            }
        }
    }

    @Override
    public void setCodes(Code[] newcodes) {
        this.mustache.setCodes(newcodes);
    }

    public Object get(Object[] scopes) {
        if (this.returnThis) {
            return scopes[scopes.length - 1];
        }
        return this.binding.get(scopes);
    }

    @Override
    public Writer execute(Writer writer, Object scope) {
        return this.execute(writer, new Object[]{scope});
    }

    @Override
    public Writer execute(Writer writer, Object[] scopes) {
        return this.appendText(this.run(writer, scopes));
    }

    @Override
    public void identity(Writer writer) {
        try {
            if (this.name != null) {
                this.tag(writer, this.type);
                if (this.getCodes() != null) {
                    this.runIdentity(writer);
                    this.tag(writer, "/");
                }
            }
            this.appendText(writer);
        }
        catch (IOException e) {
            throw new MustacheException(e);
        }
    }

    protected void runIdentity(Writer writer) {
        int length = this.getCodes().length;
        for (int i = 0; i < length; ++i) {
            this.getCodes()[i].identity(writer);
        }
    }

    protected void tag(Writer writer, String tag) throws IOException {
        writer.write(this.tc.startChars());
        writer.write(tag);
        writer.write(this.name);
        writer.write(this.tc.endChars());
    }

    protected Writer appendText(Writer writer) {
        if (this.appended != null) {
            try {
                writer.write(this.appended);
            }
            catch (IOException e) {
                throw new MustacheException(e);
            }
        }
        return writer;
    }

    protected Writer run(Writer writer, Object[] scopes) {
        return this.mustache == null ? writer : this.mustache.run(writer, scopes);
    }

    @Override
    public void append(String text) {
        this.appended = this.appended == null ? text : this.appended + text;
    }

    protected Object[] addScope(Object[] scopes, Object scope) {
        if (scope == null) {
            return scopes;
        }
        int length = scopes.length;
        Object[] newScopes = new Object[length + 1];
        System.arraycopy(scopes, 0, newScopes, 0, length);
        newScopes[length] = scope;
        return newScopes;
    }
}

