/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.bal.tool;

import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.openapi.bal.tool.Constants;
import io.ballerina.openapi.core.generators.client.BallerinaClientGenerator;
import io.ballerina.openapi.core.generators.client.BallerinaClientGeneratorWithStatusCodeBinding;
import io.ballerina.openapi.core.generators.client.exception.ClientException;
import io.ballerina.openapi.core.generators.client.mock.AdvanceMockClientGenerator;
import io.ballerina.openapi.core.generators.client.mock.BallerinaMockClientGenerator;
import io.ballerina.openapi.core.generators.client.model.OASClientConfig;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.SingleFileGenerator;
import io.ballerina.openapi.core.generators.common.TypeHandler;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.openapi.core.generators.common.model.Filter;
import io.ballerina.openapi.core.generators.common.model.GenSrcFile;
import io.ballerina.openapi.core.generators.service.model.OASServiceMetadata;
import io.ballerina.projects.BallerinaToml;
import io.ballerina.projects.Package;
import io.ballerina.projects.PackageManifest;
import io.ballerina.projects.Project;
import io.ballerina.projects.buildtools.CodeGeneratorTool;
import io.ballerina.projects.buildtools.ToolConfig;
import io.ballerina.projects.buildtools.ToolContext;
import io.ballerina.projects.directory.BuildProject;
import io.ballerina.toml.semantic.diagnostics.TomlNodeLocation;
import io.ballerina.toml.syntax.tree.AbstractNodeFactory;
import io.ballerina.toml.syntax.tree.DocumentMemberDeclarationNode;
import io.ballerina.toml.syntax.tree.DocumentNode;
import io.ballerina.toml.syntax.tree.IdentifierToken;
import io.ballerina.toml.syntax.tree.Node;
import io.ballerina.toml.syntax.tree.NodeFactory;
import io.ballerina.toml.syntax.tree.NodeList;
import io.ballerina.toml.syntax.tree.Token;
import io.ballerina.toml.validator.SampleNodeGenerator;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;

@ToolConfig(name="openapi")
public class OpenAPICodeGeneratorTool
implements CodeGeneratorTool {
    String hashOpenAPI;

    public void execute(ToolContext toolContext) {
        TomlNodeLocation location = ((BallerinaToml)toolContext.currentPackage().ballerinaToml().get()).tomlAstNode().location();
        try {
            Constants.DiagnosticMessages error;
            String oasPath = toolContext.filePath();
            if (Objects.isNull(oasPath)) {
                Constants.DiagnosticMessages error2 = Constants.DiagnosticMessages.CONTRACT_PATH_NOT_PROVIDED;
                this.createDiagnostics(toolContext, error2, (Location)location, new String[0]);
                return;
            }
            if (oasPath.isBlank()) {
                error = Constants.DiagnosticMessages.EMPTY_CONTRACT_PATH;
                this.createDiagnostics(toolContext, error, (Location)location, new String[0]);
            }
            if (!this.canHandle(oasPath)) {
                error = Constants.DiagnosticMessages.WARNING_FOR_UNSUPPORTED_CONTRACT;
                this.createDiagnostics(toolContext, error, (Location)location, new String[0]);
                return;
            }
            String oasFilePath = toolContext.filePath();
            Path packagePath = toolContext.currentPackage().project().sourceRoot();
            Map options = toolContext.options();
            Optional<OpenAPI> openAPI = this.getOpenAPIContract(packagePath, Path.of(oasFilePath, new String[0]), (Location)location, toolContext);
            if (openAPI.isEmpty()) {
                return;
            }
            if (options == null) {
                Filter filter = new Filter();
                OASClientConfig clientConfig = new OASClientConfig.Builder().withFilters(filter).withOpenAPI(openAPI.get()).build();
                OASServiceMetadata serviceMetaData = new OASServiceMetadata.Builder().withFilters(filter).withOpenAPI(openAPI.get()).build();
                ImmutablePair codeGeneratorConfig = new ImmutablePair((Object)clientConfig, (Object)serviceMetaData);
                if (this.validateCache(toolContext, clientConfig)) {
                    return;
                }
                this.generateClient(toolContext, (ImmutablePair<OASClientConfig, OASServiceMetadata>)codeGeneratorConfig, (Location)location);
            } else {
                ImmutablePair<OASClientConfig, OASServiceMetadata> codeGeneratorConfig = this.extractOptionDetails(toolContext, openAPI.get());
                if (this.validateCache(toolContext, (OASClientConfig)codeGeneratorConfig.getLeft())) {
                    return;
                }
                if (options.containsKey("mode")) {
                    String value = ((ToolContext.Option)options.get("mode")).value().toString().trim();
                    this.handleCodeGenerationMode(toolContext, codeGeneratorConfig, location, value);
                } else {
                    this.generateClient(toolContext, codeGeneratorConfig, (Location)location);
                }
            }
        }
        catch (BallerinaOpenApiException e) {
            Constants.DiagnosticMessages error = Constants.DiagnosticMessages.PARSER_ERROR;
            this.createDiagnostics(toolContext, error, (Location)location, new String[0]);
        }
        catch (ClientException | IOException | FormatterException e) {
            Constants.DiagnosticMessages error = Constants.DiagnosticMessages.ERROR_WHILE_GENERATING_CLIENT;
            this.createDiagnostics(toolContext, error, (Location)location, new String[0]);
        }
    }

    private boolean validateCache(ToolContext toolContext, OASClientConfig clientConfig) throws IOException {
        Path cachePath = toolContext.cachePath();
        this.hashOpenAPI = this.getHashValue(clientConfig, toolContext.targetModule());
        if (!Files.isDirectory(cachePath, new LinkOption[0])) {
            return false;
        }
        Path cacheFilePath = Paths.get(cachePath.toString(), "openapi-cache.txt");
        String cacheContent = Files.readString(Paths.get(cacheFilePath.toString(), new String[0]));
        return cacheContent.equals(this.hashOpenAPI);
    }

    private void handleCodeGenerationMode(ToolContext toolContext, ImmutablePair<OASClientConfig, OASServiceMetadata> codeGeneratorConfig, TomlNodeLocation location, String mode) throws BallerinaOpenApiException, IOException, FormatterException, ClientException {
        if (mode.equals("client")) {
            this.generateClient(toolContext, codeGeneratorConfig, (Location)location);
        } else {
            Constants.DiagnosticMessages error = Constants.DiagnosticMessages.WARNING_FOR_OTHER_GENERATION;
            this.createDiagnostics(toolContext, error, (Location)location, mode);
        }
    }

    private boolean canHandle(String oasPath) {
        return oasPath.endsWith(".yaml") || oasPath.endsWith(".json") || oasPath.endsWith(".yml");
    }

    private Optional<OpenAPI> getOpenAPIContract(Path ballerinaFilePath, Path openAPIPath, Location location, ToolContext toolContext) {
        Constants.DiagnosticMessages error;
        boolean isSanitized = false;
        Map options = toolContext.options();
        if (options != null && options.containsKey("isUsingSanitizedOas")) {
            ToolContext.Option isUsingSanitizedOas = (ToolContext.Option)options.get("isUsingSanitizedOas");
            String value = isUsingSanitizedOas.value().toString().trim();
            isSanitized = Boolean.parseBoolean(value);
        }
        try {
            Path relativePath;
            Path inputPath = Paths.get(openAPIPath.toString(), new String[0]);
            if (inputPath.isAbsolute()) {
                relativePath = inputPath;
            } else {
                File file = new File(ballerinaFilePath.toString());
                File openapiContract = new File(file, openAPIPath.toString());
                relativePath = Paths.get(openapiContract.getCanonicalPath(), new String[0]);
            }
            if (Files.exists(relativePath, new LinkOption[0])) {
                return Optional.of(GeneratorUtils.normalizeOpenAPI((Path)relativePath, (boolean)this.operationIdValidationRequired(toolContext), (boolean)isSanitized));
            }
            error = Constants.DiagnosticMessages.INVALID_CONTRACT_PATH;
            this.createDiagnostics(toolContext, error, location, new String[0]);
        }
        catch (BallerinaOpenApiException exp) {
            error = Constants.DiagnosticMessages.OPENAPI_EXCEPTION;
            this.createDiagnostics(toolContext, error, location, exp.getMessage());
        }
        catch (IOException e) {
            error = Constants.DiagnosticMessages.UNEXPECTED_EXCEPTIONS;
            this.createDiagnostics(toolContext, error, location, new String[0]);
        }
        return Optional.empty();
    }

    private boolean operationIdValidationRequired(ToolContext toolContext) {
        Map options = toolContext.options();
        if (Objects.isNull(options)) {
            return false;
        }
        for (Map.Entry field : options.entrySet()) {
            String value = ((ToolContext.Option)field.getValue()).value().toString().trim();
            String fieldName = (String)field.getKey();
            if ((!fieldName.equals("clientMethods") || value.contains("resource")) && (!fieldName.equals("statusCodeBinding") || !value.contains("true"))) continue;
            return true;
        }
        return false;
    }

    public ImmutablePair<OASClientConfig, OASServiceMetadata> extractOptionDetails(ToolContext toolContext, OpenAPI openAPI) throws IOException, BallerinaOpenApiException {
        Filter filter = new Filter();
        OASClientConfig.Builder clientMetaDataBuilder = new OASClientConfig.Builder();
        OASServiceMetadata.Builder serviceMetaDataBuilder = new OASServiceMetadata.Builder();
        clientMetaDataBuilder.withOpenAPI(openAPI);
        serviceMetaDataBuilder.withOpenAPI(openAPI);
        Map options = toolContext.options();
        for (Map.Entry field : options.entrySet()) {
            String fieldName;
            String value = ((ToolContext.Option)field.getValue()).value().toString().trim();
            switch (fieldName = (String)field.getKey()) {
                case "tags": {
                    filter.setTags(this.getArrayItems(((ToolContext.Option)field.getValue()).value()));
                    break;
                }
                case "operations": {
                    filter.setOperations(this.getArrayItems(((ToolContext.Option)field.getValue()).value()));
                    break;
                }
                case "nullable": {
                    serviceMetaDataBuilder.withNullable(value.contains("true"));
                    clientMetaDataBuilder.withNullable(value.contains("true"));
                    break;
                }
                case "clientMethods": {
                    clientMetaDataBuilder.withResourceMode(value.contains("resource"));
                    break;
                }
                case "license": {
                    Optional<String> licenseContent;
                    if (value.isBlank()) {
                        Constants.DiagnosticMessages error = Constants.DiagnosticMessages.LICENSE_PATH_BLANK;
                        this.createDiagnostics(toolContext, error, (Location)((ToolContext.Option)field.getValue()).location(), new String[0]);
                        licenseContent = Optional.of("// AUTO-GENERATED FILE. DO NOT MODIFY.\n// This file is auto-generated by the Ballerina OpenAPI tool.\n\n");
                    } else {
                        licenseContent = this.getLicenseContent(toolContext, Paths.get(value, new String[0]));
                    }
                    clientMetaDataBuilder.withLicense(licenseContent.orElse("// AUTO-GENERATED FILE. DO NOT MODIFY.\n// This file is auto-generated by the Ballerina OpenAPI tool.\n\n"));
                    break;
                }
                case "statusCodeBinding": {
                    clientMetaDataBuilder.withStatusCodeBinding(value.contains("true"));
                    break;
                }
                case "mock": {
                    clientMetaDataBuilder.withMock(value.contains("true"));
                    break;
                }
                case "singleFile": {
                    clientMetaDataBuilder.withSingleFile(value.contains("true"));
                    break;
                }
                case "isUsingSanitizedOas": {
                    clientMetaDataBuilder.withIsUsingSanitizedOas(value.contains("true"));
                    serviceMetaDataBuilder.withIsUsingSanitizedOas(value.contains("true"));
                    break;
                }
            }
        }
        clientMetaDataBuilder.withFilters(filter);
        serviceMetaDataBuilder.withFilters(filter);
        return new ImmutablePair((Object)clientMetaDataBuilder.build(), (Object)serviceMetaDataBuilder.build());
    }

    private List<String> getArrayItems(Object valueNode) {
        ArrayList<String> arrayItems = new ArrayList<String>();
        if (valueNode instanceof ArrayList) {
            return (List)valueNode;
        }
        return arrayItems;
    }

    private void generateClient(ToolContext toolContext, ImmutablePair<OASClientConfig, OASServiceMetadata> codeGeneratorConfig, Location location) throws BallerinaOpenApiException, IOException, FormatterException, ClientException {
        boolean skipDependecyUpdate = true;
        if (this.getStatusCodeBindingOption(toolContext)) {
            try {
                skipDependecyUpdate = this.clientNativeDependencyAlreadyExist(this.getVersion(), toolContext, location);
            }
            catch (BallerinaOpenApiException e) {
                this.createDiagnostics(toolContext, Constants.DiagnosticMessages.CLIENT_NATIVE_DEPENDENCY_VERSION_MISMATCH, location, new String[0]);
                return;
            }
        }
        OASClientConfig clientConfig = (OASClientConfig)codeGeneratorConfig.getLeft();
        List<GenSrcFile> sources = this.generateClientFiles(clientConfig, toolContext, location);
        Path outputPath = toolContext.outputPath();
        this.writeGeneratedSources(sources, outputPath);
        Path cachePath = toolContext.cachePath();
        ArrayList<GenSrcFile> sourcesForCache = new ArrayList<GenSrcFile>();
        GenSrcFile genSrcFile = new GenSrcFile(GenSrcFile.GenFileType.CACHE_SRC, null, "openapi-cache.txt", this.hashOpenAPI);
        sourcesForCache.add(genSrcFile);
        this.writeGeneratedSources(sourcesForCache, cachePath);
        if (!skipDependecyUpdate) {
            this.updateBallerinaTomlWithClientNativeDependency(toolContext, toolContext.currentPackage().project().sourceRoot().resolve("Ballerina.toml"), location);
        }
    }

    private boolean getStatusCodeBindingOption(ToolContext toolContext) {
        return toolContext.options().containsKey("statusCodeBinding") && ((ToolContext.Option)toolContext.options().get("statusCodeBinding")).value().toString().contains("true");
    }

    private void updateBallerinaTomlWithClientNativeDependency(ToolContext toolContext, Path ballerinaTomlPath, Location location) {
        try {
            String version = this.getVersion();
            TextDocument configDocument = TextDocuments.from((String)Files.readString(ballerinaTomlPath));
            io.ballerina.toml.syntax.tree.SyntaxTree syntaxTree = io.ballerina.toml.syntax.tree.SyntaxTree.from((TextDocument)configDocument);
            DocumentNode rootNode = (DocumentNode)syntaxTree.rootNode();
            NodeList nodeList = rootNode.members();
            NodeList<DocumentMemberDeclarationNode> tomlMembers = AbstractNodeFactory.createEmptyNodeList();
            for (DocumentMemberDeclarationNode node : nodeList) {
                tomlMembers = tomlMembers.add((Node)node);
            }
            tomlMembers = this.addNewLine((NodeList)tomlMembers, 1);
            tomlMembers = this.populateClientNativeDependency(tomlMembers, version);
            IdentifierToken eofToken = AbstractNodeFactory.createIdentifierToken((String)"");
            DocumentNode documentNode = NodeFactory.createDocumentNode(tomlMembers, (Token)eofToken);
            TextDocument textDocument = TextDocuments.from((String)documentNode.toSourceCode());
            String content = io.ballerina.toml.syntax.tree.SyntaxTree.from((TextDocument)textDocument).toSourceCode();
            try (FileWriter writer = new FileWriter(ballerinaTomlPath.toString(), StandardCharsets.UTF_8);){
                writer.write(content);
                this.createDiagnostics(toolContext, Constants.DiagnosticMessages.TOML_UPDATED_WITH_CLIENT_NATIVE_DEPENDENCY, location, new String[0]);
            }
        }
        catch (IOException e) {
            this.createDiagnostics(toolContext, Constants.DiagnosticMessages.ERROR_WHILE_UPDATING_TOML, location, new String[0]);
        }
    }

    private boolean clientNativeDependencyAlreadyExist(String version, ToolContext toolContext, Location location) throws BallerinaOpenApiException {
        Project project = toolContext.currentPackage().project();
        Path path = project.sourceRoot();
        Map platforms = (project = BuildProject.load((Path)path)).currentPackage().manifest().platforms();
        if (Objects.nonNull(platforms) && platforms.containsKey("java21")) {
            Optional<Map> nativeDependency = ((PackageManifest.Platform)platforms.get("java21")).dependencies().stream().filter(dependency -> dependency.containsKey("groupId") && dependency.get("groupId").equals("io.ballerina.openapi") && dependency.containsKey("artifactId") && dependency.get("artifactId").equals("client-native")).findFirst();
            if (nativeDependency.isEmpty()) {
                return false;
            }
            if (!nativeDependency.get().containsKey("version") || !nativeDependency.get().get("version").equals(version)) {
                throw new BallerinaOpenApiException("client native dependency version mismatch");
            }
            this.createDiagnostics(toolContext, Constants.DiagnosticMessages.TOML_ALREADY_UPDATED_WITH_CLIENT_NATIVE_DEPENDENCY, location, new String[0]);
            return true;
        }
        return false;
    }

    private NodeList<DocumentMemberDeclarationNode> populateClientNativeDependency(NodeList<DocumentMemberDeclarationNode> tomlMembers, String version) {
        String desc = "This dependency is added automatically by the OpenAPI tool. DO NOT REMOVE UNLESS REQUIRED";
        tomlMembers = tomlMembers.add((Node)SampleNodeGenerator.createTableArray((String)"platform.java21.dependency", (String)desc));
        tomlMembers = tomlMembers.add((Node)SampleNodeGenerator.createStringKV((String)"groupId", (String)"io.ballerina.openapi", null));
        tomlMembers = tomlMembers.add((Node)SampleNodeGenerator.createStringKV((String)"artifactId", (String)"client-native", null));
        tomlMembers = tomlMembers.add((Node)SampleNodeGenerator.createStringKV((String)"version", (String)version, null));
        tomlMembers = tomlMembers.add((Node)SampleNodeGenerator.createBooleanKV((String)"graalvmCompatible", (Boolean)true, null));
        return tomlMembers;
    }

    private String getVersion() throws IOException {
        String string;
        block8: {
            InputStream inputStream = OpenAPICodeGeneratorTool.class.getClassLoader().getResourceAsStream("openapi-client-native-version.properties");
            try {
                Properties properties = new Properties();
                properties.load(inputStream);
                string = properties.getProperty("version");
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException exception) {
                    throw new IOException("error occurred while reading version from version.properties: " + exception.getMessage());
                }
            }
            inputStream.close();
        }
        return string;
    }

    public NodeList<DocumentMemberDeclarationNode> addNewLine(NodeList moduleMembers, int n) {
        for (int i = 0; i < n; ++i) {
            moduleMembers = moduleMembers.add((Node)AbstractNodeFactory.createIdentifierToken((String)System.lineSeparator()));
        }
        return moduleMembers;
    }

    private String getHashValue(OASClientConfig clientConfig, String targetPath) {
        String openAPIDefinitions = clientConfig.getOpenAPI().toString().trim().replaceAll("\\s+", "");
        StringBuilder summaryOfCodegen = new StringBuilder();
        summaryOfCodegen.append(openAPIDefinitions).append(targetPath).append(clientConfig.isResourceMode()).append(clientConfig.getLicense()).append(clientConfig.isNullable()).append(clientConfig.isStatusCodeBinding()).append(clientConfig.isMock()).append(clientConfig.singleFile()).append(clientConfig.isUsingSanitizedOas());
        List tags = clientConfig.getFilter().getTags();
        tags.sort(String.CASE_INSENSITIVE_ORDER);
        for (String str : tags) {
            summaryOfCodegen.append(str);
        }
        List operations = clientConfig.getFilter().getOperations();
        operations.sort(String.CASE_INSENSITIVE_ORDER);
        for (String str : operations) {
            summaryOfCodegen.append(str);
        }
        return DigestUtils.sha256Hex(summaryOfCodegen.toString()).toUpperCase(Locale.ENGLISH);
    }

    private List<GenSrcFile> generateClientFiles(OASClientConfig oasClientConfig, ToolContext toolContext, Location location) throws BallerinaOpenApiException, IOException, FormatterException, ClientException {
        String licenseHeader;
        ArrayList<GenSrcFile> sourceFiles = new ArrayList<GenSrcFile>();
        TypeHandler.createInstance((OpenAPI)oasClientConfig.getOpenAPI(), (boolean)oasClientConfig.isNullable());
        String licenseContent = oasClientConfig.getLicense();
        BallerinaClientGenerator ballerinaClientGenerator = this.getClientGenerator(oasClientConfig);
        SyntaxTree syntaxTree = ballerinaClientGenerator.generateSyntaxTree();
        List clientDiagnostic = ballerinaClientGenerator.getDiagnostics();
        for (Object diagnostic2 : clientDiagnostic) {
            this.createDiagnostics(toolContext, diagnostic2.getMessage(), diagnostic2.getCode(), diagnostic2.getDiagnosticSeverity(), location);
        }
        if (clientDiagnostic.stream().anyMatch(diagnostic -> diagnostic.getDiagnosticSeverity() == DiagnosticSeverity.ERROR)) {
            throw new ClientException("Error occurred while generating client");
        }
        List authNodes = ballerinaClientGenerator.getBallerinaAuthConfigGenerator().getAuthRelatedTypeDefinitionNodes();
        for (TypeDefinitionNode typeDef : authNodes) {
            TypeHandler.getInstance().addTypeDefinitionNode(typeDef.typeName().text(), typeDef);
        }
        String string = licenseHeader = licenseContent == null || licenseContent.isBlank() ? "" : licenseContent + System.lineSeparator();
        if (oasClientConfig.singleFile()) {
            this.generateSingleFileForClient(toolContext, syntaxTree, ballerinaClientGenerator, sourceFiles, licenseHeader);
        } else {
            OpenAPICodeGeneratorTool.generateFilesForClient(syntaxTree, sourceFiles, licenseHeader, ballerinaClientGenerator);
        }
        return sourceFiles;
    }

    private static void generateFilesForClient(SyntaxTree syntaxTree, List<GenSrcFile> sourceFiles, String licenseHeader, BallerinaClientGenerator ballerinaClientGenerator) throws FormatterException, IOException {
        SyntaxTree schemaSyntaxTree;
        String schemaContent;
        String mainContent = Formatter.format((SyntaxTree)syntaxTree).toSourceCode();
        sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, null, "client.bal", licenseHeader + mainContent));
        String utilContent = Formatter.format((SyntaxTree)ballerinaClientGenerator.getBallerinaUtilGenerator().generateUtilSyntaxTree()).toString();
        if (!utilContent.isBlank()) {
            sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.UTIL_SRC, null, "utils.bal", licenseHeader + utilContent));
        }
        if (!(schemaContent = Formatter.format((SyntaxTree)(schemaSyntaxTree = TypeHandler.getInstance().generateTypeSyntaxTree())).toSourceCode()).isBlank()) {
            sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.MODEL_SRC, null, "types.bal", licenseHeader + schemaContent));
        }
    }

    private void generateSingleFileForClient(ToolContext toolContext, SyntaxTree syntaxTree, BallerinaClientGenerator ballerinaClientGenerator, List<GenSrcFile> sourceFiles, String licenseHeader) throws IOException, FormatterException {
        syntaxTree = SingleFileGenerator.combineSyntaxTrees((SyntaxTree[])new SyntaxTree[]{syntaxTree, ballerinaClientGenerator.getBallerinaUtilGenerator().generateUtilSyntaxTree(), TypeHandler.getInstance().generateTypeSyntaxTree()});
        sourceFiles.add(new GenSrcFile(GenSrcFile.GenFileType.GEN_SRC, null, "client.bal", licenseHeader + Formatter.format((SyntaxTree)syntaxTree).toSourceCode()));
    }

    private BallerinaClientGenerator getClientGenerator(OASClientConfig oasClientConfig) {
        boolean statusCodeBinding = oasClientConfig.isStatusCodeBinding();
        boolean isMock = oasClientConfig.isMock();
        if (statusCodeBinding && isMock) {
            return new AdvanceMockClientGenerator(oasClientConfig);
        }
        if (statusCodeBinding) {
            return new BallerinaClientGeneratorWithStatusCodeBinding(oasClientConfig);
        }
        if (isMock) {
            return new BallerinaMockClientGenerator(oasClientConfig);
        }
        return new BallerinaClientGenerator(oasClientConfig);
    }

    private Optional<String> getLicenseContent(ToolContext context, Path licensePath) {
        Package packageInstance = context.currentPackage();
        TomlNodeLocation location = ((ToolContext.Option)context.options().get("license")).location();
        Path ballerinaFilePath = packageInstance.project().sourceRoot();
        try {
            Path relativePath = this.getLicensePath(licensePath, ballerinaFilePath);
            return relativePath != null ? this.createLicenseContent(relativePath, (Location)location, context) : Optional.empty();
        }
        catch (IOException e) {
            Constants.DiagnosticMessages error = Constants.DiagnosticMessages.ERROR_WHILE_READING_LICENSE_FILE;
            this.createDiagnostics(context, error, (Location)location, new String[0]);
            return Optional.empty();
        }
    }

    private Path getLicensePath(Path licensePath, Path ballerinaFilePath) throws IOException {
        Path relativePath = null;
        if (!licensePath.toString().isBlank()) {
            Path finalLicensePath = Paths.get(licensePath.toString(), new String[0]);
            if (finalLicensePath.isAbsolute()) {
                relativePath = finalLicensePath;
            } else {
                File openapiContract = new File(ballerinaFilePath.toString(), licensePath.toString());
                relativePath = Paths.get(openapiContract.getCanonicalPath(), new String[0]);
            }
        }
        return relativePath;
    }

    private Optional<String> createLicenseContent(Path relativePath, Location location, ToolContext toolContext) {
        Object licenseHeader;
        try {
            String newLine = System.lineSeparator();
            Path filePath = Paths.get(new File(relativePath.toString()).getCanonicalPath(), new String[0]);
            licenseHeader = Files.readString(Paths.get(filePath.toString(), new String[0]));
            if (!((String)licenseHeader).endsWith(newLine)) {
                licenseHeader = (String)licenseHeader + newLine + newLine;
            } else if (!((String)licenseHeader).endsWith(newLine + newLine)) {
                licenseHeader = (String)licenseHeader + newLine;
            }
        }
        catch (IOException e) {
            Constants.DiagnosticMessages error = Constants.DiagnosticMessages.ERROR_WHILE_READING_LICENSE_FILE;
            this.createDiagnostics(toolContext, error, location, new String[0]);
            return Optional.empty();
        }
        return Optional.of(licenseHeader);
    }

    private void createDiagnostics(ToolContext toolContext, Constants.DiagnosticMessages error, Location location, String ... args) {
        String message = String.format(error.getDescription(), args);
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(error.getCode(), message, error.getSeverity());
        toolContext.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])new Object[0]));
    }

    private void createDiagnostics(ToolContext toolContext, String diagnosticMessage, String diagnosticCode, DiagnosticSeverity severity, Location location) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(diagnosticCode, diagnosticMessage, severity);
        toolContext.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])new Object[0]));
    }

    private void writeGeneratedSources(List<GenSrcFile> sources, Path outputPath) throws IOException {
        for (GenSrcFile file : sources) {
            Path filePath = Paths.get(outputPath.resolve(file.getFileName()).toFile().getCanonicalPath(), new String[0]);
            String fileContent = file.getContent();
            this.writeFile(filePath, fileContent);
        }
    }

    public void writeFile(Path filePath, String content) throws IOException {
        File file = new File(filePath.toString());
        File parentDirectory = file.getParentFile();
        if (!parentDirectory.exists() && !parentDirectory.mkdirs()) {
            return;
        }
        try (FileWriter writer = new FileWriter(filePath.toString(), StandardCharsets.UTF_8);){
            writer.write(content);
        }
    }
}

