/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.tools.text;

import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.TextLine;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class LineMap {
    private final TextLine[] textLines;
    private final int length;

    LineMap(TextLine[] textLines) {
        this.textLines = textLines;
        this.length = textLines.length;
    }

    TextLine textLine(int line) {
        this.lineRangeCheck(line);
        return this.textLines[line];
    }

    LinePosition linePositionFrom(int position) {
        this.positionRangeCheck(position);
        TextLine textLine = this.findLineFrom(position);
        return LinePosition.from(textLine.lineNo(), position - textLine.startOffset());
    }

    int textPositionFrom(LinePosition linePosition) {
        this.lineRangeCheck(linePosition.line());
        TextLine textLine = this.textLines[linePosition.line()];
        if (textLine.length() < linePosition.offset()) {
            throw new IllegalArgumentException("Cannot find a line with the character offset '" + linePosition.offset() + "'");
        }
        return textLine.startOffset() + linePosition.offset();
    }

    List<String> textLines() {
        ArrayList<String> lines = new ArrayList<String>();
        for (TextLine textLine : this.textLines) {
            lines.add(textLine.text());
        }
        return Collections.unmodifiableList(lines);
    }

    private void positionRangeCheck(int position) {
        if (position < 0 || position > this.textLines[this.length - 1].endOffset()) {
            throw new IndexOutOfBoundsException("Index: '" + position + "', Size: '" + this.textLines[this.length - 1].endOffset() + "'");
        }
    }

    private void lineRangeCheck(int lineNo) {
        if (lineNo < 0 || lineNo > this.length) {
            throw new IndexOutOfBoundsException("Line number: '" + lineNo + "', Size: '" + this.length + "'");
        }
    }

    private TextLine findLineFrom(int position) {
        if (position == 0) {
            return this.textLines[0];
        }
        if (position == this.textLines[this.length - 1].endOffset()) {
            return this.textLines[this.length - 1];
        }
        TextLine foundTextLine = null;
        int left = 0;
        int right = this.length - 1;
        while (left <= right) {
            int middle = left + right >>> 1;
            int startOffset = this.textLines[middle].startOffset();
            int endOffset = this.textLines[middle].endOffsetWithNewLines();
            if (startOffset <= position && position < endOffset) {
                foundTextLine = this.textLines[middle];
                break;
            }
            if (endOffset <= position) {
                left = middle + 1;
                continue;
            }
            right = middle - 1;
        }
        return foundTextLine;
    }
}

