/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.tools.text;

import io.ballerina.tools.text.LineMap;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocumentChange;
import io.ballerina.tools.text.TextEdit;
import io.ballerina.tools.text.TextLine;
import io.ballerina.tools.text.TextRange;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.function.Supplier;

abstract class StringTextDocument
extends TextDocument {
    private LineMap textLineMap;

    StringTextDocument() {
    }

    protected abstract String text();

    @Override
    public TextDocument apply(TextDocumentChange textDocumentChange) {
        int startOffset = 0;
        StringBuilder sb = new StringBuilder();
        int textEditCount = textDocumentChange.getTextEditCount();
        for (int i = 0; i < textEditCount; ++i) {
            TextEdit textEdit = textDocumentChange.getTextEdit(i);
            TextRange textRange = textEdit.range();
            sb.append(this.text(), startOffset, textRange.startOffset());
            sb.append(textEdit.text());
            startOffset = textRange.endOffset();
        }
        sb.append(this.text(), startOffset, this.text().length());
        return new EagerStringTextDocument(sb.toString());
    }

    @Override
    protected LineMap populateTextLineMap() {
        if (this.textLineMap != null) {
            return this.textLineMap;
        }
        this.textLineMap = new LineMap(this.calculateTextLines());
        return this.textLineMap;
    }

    @Override
    public char[] toCharArray() {
        return this.text().toCharArray();
    }

    public String toString() {
        return this.text();
    }

    private TextLine[] calculateTextLines() {
        int startOffset = 0;
        ArrayList<TextLine> textLines = new ArrayList<TextLine>();
        StringBuilder lineBuilder = new StringBuilder();
        int index = 0;
        int line = 0;
        String text = this.text();
        int textLength = text.length();
        while (index < textLength) {
            char c = text.charAt(index);
            if (c == '\r' || c == '\n') {
                int nextCharIndex = index + 1;
                int lengthOfNewLineChars = c == '\r' && textLength != nextCharIndex && text.charAt(nextCharIndex) == '\n' ? 2 : 1;
                String strLine = lineBuilder.toString();
                int endOffset = startOffset + strLine.length();
                textLines.add(new TextLine(line++, strLine, startOffset, endOffset, lengthOfNewLineChars));
                startOffset = endOffset + lengthOfNewLineChars;
                lineBuilder = new StringBuilder();
                index += lengthOfNewLineChars;
                continue;
            }
            lineBuilder.append(c);
            ++index;
        }
        String strLine = lineBuilder.toString();
        textLines.add(new TextLine(line, strLine, startOffset, startOffset + strLine.length(), 0));
        return textLines.toArray(new TextLine[0]);
    }

    static class EagerStringTextDocument
    extends StringTextDocument {
        private final String text;

        EagerStringTextDocument(String text) {
            this.text = text;
        }

        @Override
        public String toString() {
            return this.text;
        }

        @Override
        protected String text() {
            return this.text;
        }
    }

    static class LazyStringTextDocument
    extends StringTextDocument {
        private final Supplier<String> text;
        private WeakReference<String> cachedText;

        LazyStringTextDocument(Supplier<String> text) {
            this.text = text;
            this.cachedText = new WeakReference<Object>(null);
        }

        @Override
        public String toString() {
            return this.getText();
        }

        @Override
        protected String text() {
            return this.getText();
        }

        private String getText() {
            String cached = (String)this.cachedText.get();
            if (cached == null) {
                cached = this.text.get();
                this.cachedText = new WeakReference<String>(cached);
            }
            assert (cached != null) : "LazyStringTextDocument text supplier should not return null";
            return cached;
        }
    }
}

