/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.cli;

import io.ballerina.shell.Evaluator;
import io.ballerina.shell.EvaluatorBuilder;
import io.ballerina.shell.parser.TreeParser;
import io.ballerina.shell.parser.TrialTreeParser;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;

public class BShellConfiguration {
    private final Evaluator evaluator;
    private final InputStream inputStream;
    private final OutputStream outputStream;
    private final String startFile;
    private boolean isDebug;
    private boolean isDumb;

    private BShellConfiguration(boolean isDebug, boolean isDumb, long treeParsingTimeout, InputStream inputStream, OutputStream outputStream, String startFile) {
        this.isDebug = isDebug;
        this.isDumb = isDumb;
        this.evaluator = new EvaluatorBuilder().treeParser((TreeParser)TrialTreeParser.defaultParser((long)treeParsingTimeout)).build();
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.startFile = startFile;
    }

    public Evaluator getEvaluator() {
        return this.evaluator;
    }

    public boolean isDebug() {
        return this.isDebug;
    }

    public void toggleDebug() {
        this.isDebug = !this.isDebug;
    }

    public boolean isDumb() {
        return this.isDumb;
    }

    public void setDumb(boolean dumb) {
        this.isDumb = dumb;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public Optional<String> getStartFile() {
        return Optional.ofNullable(this.startFile);
    }

    public static class Builder {
        private InputStream inputStream = System.in;
        private OutputStream outputStream = System.out;
        private long treeParsingTimeoutMs = 1000L;
        private String startFile = null;
        private boolean isDebug = false;
        private boolean isDumb = false;

        public Builder setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
            return this;
        }

        public Builder setOutputStream(OutputStream outputStream) {
            this.outputStream = outputStream;
            return this;
        }

        public Builder setTreeParsingTimeoutMs(long treeParsingTimeoutMs) {
            this.treeParsingTimeoutMs = treeParsingTimeoutMs;
            return this;
        }

        public Builder setDebug(boolean debug) {
            this.isDebug = debug;
            return this;
        }

        public Builder setDumb(boolean dumb) {
            this.isDumb = dumb;
            return this;
        }

        public Builder setStartFile(String startFile) {
            this.startFile = startFile;
            return this;
        }

        public BShellConfiguration build() {
            return new BShellConfiguration(this.isDebug, this.isDumb, this.treeParsingTimeoutMs, this.inputStream, this.outputStream, this.startFile);
        }
    }
}

