/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.cli;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Properties;

public class PropertiesLoader {
    public static final String APP_NAME = "app.name";
    public static final String REPL_PROMPT = "repl.prompt";
    public static final String HEADER_FILE = "resource.header.file";
    public static final String KEYWORDS_FILE = "resource.keywords.file";
    public static final String COMMANDS_FILE = "resource.commands.file";
    public static final String HELP_FILE = "resource.help.file";
    public static final String COMMAND_PREFIX = "commands.prefix";
    public static final String COMMAND_EXIT = "commands.exit";
    public static final String COMMAND_HELP = "commands.help";
    public static final String COMMAND_RESET = "commands.reset";
    public static final String COMMAND_DEBUG = "commands.debug";
    public static final String COMMAND_VARS = "commands.vars";
    public static final String COMMAND_IMPORTS = "commands.imports";
    public static final String COMMAND_DCLNS = "commands.dclns";
    public static final String COMMAND_DELETE = "commands.delete";
    public static final String COMMAND_FILE = "commands.file";
    public static final String HELP_DESCRIPTION_POSTFIX = "commands.help.ps.description";
    public static final String HELP_EXAMPLE_POSTFIX = "commands.help.ps.example";
    public static final String DESCRIPTION_URL_TEMPLATE = "help.description.url";
    public static final String EXAMPLE_URL_TEMPLATE = "help.example.url";
    private static final String PROPERTIES_FILE = "shell.properties";
    private static PropertiesLoader propertiesLoader;
    private final Properties properties = this.load();

    private PropertiesLoader() throws IOException {
    }

    public static synchronized PropertiesLoader getInstance() {
        try {
            if (propertiesLoader == null) {
                propertiesLoader = new PropertiesLoader();
            }
            return propertiesLoader;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getProperty(String key) {
        return PropertiesLoader.getInstance().get(key);
    }

    private Properties load() throws IOException {
        Properties properties = new Properties();
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(PROPERTIES_FILE);
        Objects.requireNonNull(inputStream, "Properties file open failed.");
        properties.load(inputStream);
        return properties;
    }

    public String get(String key) {
        return this.properties.getProperty(key);
    }
}

