/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.cli.jline.validator;

import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.shell.cli.jline.validator.Validator;
import io.ballerina.shell.cli.utils.IncompleteInputFinder;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;

public class ModuleMemberValidator
implements Validator {
    private Validator nextInValidator = null;

    @Override
    public void setNextValidator(Validator nextValidator) {
        this.nextInValidator = nextValidator;
    }

    @Override
    public boolean evaluate(String source) {
        Node lastNode;
        IncompleteInputFinder incompleteInputFinder = new IncompleteInputFinder();
        TextDocument document = TextDocuments.from((String)source);
        SyntaxTree tree = SyntaxTree.from((TextDocument)document);
        ModulePartNode node = (ModulePartNode)tree.rootNode();
        ModuleMemberDeclarationNode parsedNode = NodeParser.parseModuleMemberDeclaration((String)source);
        if (node.members().size() > 1 && (lastNode = node.members().get(node.members().size() - 1)).kind() == SyntaxKind.FUNCTION_DEFINITION) {
            return !lastNode.hasDiagnostics() || (Boolean)lastNode.apply((NodeTransformer)incompleteInputFinder) == false || this.nextInValidator.evaluate(lastNode.toSourceCode());
        }
        return !node.imports().isEmpty() || !parsedNode.hasDiagnostics() || (Boolean)parsedNode.apply((NodeTransformer)incompleteInputFinder) == false || this.nextInValidator.evaluate(source);
    }
}

