/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.xmldata.utils;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.xmldata.utils.Constants;
import io.ballerina.stdlib.xmldata.utils.ModuleUtils;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;

public final class XmlDataUtils {
    private static final String ERROR = "Error";
    private static final String ATTRIBUTE_PREFIX = "attribute_";
    private static final String VALUE = "value";

    private XmlDataUtils() {
    }

    public static BError getError(String message) {
        return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)ERROR, (BString)StringUtils.fromString((String)message), null, null);
    }

    public static Object getModifiedRecord(BMap<BString, Object> input, BTypedesc type) {
        BArray objectArray;
        Type elementType;
        Type describingType = type.getDescribingType();
        Object value = input.get((Object)((BString[])input.getKeys())[0]);
        if (describingType.getTag() == 27 && value instanceof BArray && (elementType = TypeUtils.getReferredType((Type)((ArrayType)(objectArray = (BArray)value).getType()).getElementType())).getTag() == 24) {
            BMap jsonMap = ValueCreator.createMapValue((MapType)Constants.JSON_MAP_TYPE);
            for (Map.Entry entry : input.entrySet()) {
                ArrayList<BMap> records = new ArrayList<BMap>();
                BArray arrayValue = (BArray)entry.getValue();
                int i = 0;
                while ((long)i < arrayValue.getLength()) {
                    BMap<BString, Object> record = XmlDataUtils.addFields((BMap<BString, Object>)((BMap)arrayValue.get((long)i)), elementType);
                    BMap<BString, Object> parentRecord = XmlDataUtils.processParentAnnotation(elementType, record);
                    records.add((BMap)parentRecord.get((Object)((BString[])parentRecord.getKeys())[0]));
                    ++i;
                }
                jsonMap.put((Object)((BString)entry.getKey()), (Object)ValueCreator.createArrayValue((Object[])records.toArray(), (ArrayType)TypeCreator.createArrayType((Type)elementType)));
            }
            return jsonMap;
        }
        if (describingType.getTag() == 24 && describingType.getFlags() != 2049L) {
            BArray jsonArray = ValueCreator.createArrayValue((ArrayType)PredefinedTypes.TYPE_JSON_ARRAY);
            BMap<BString, Object> recordField = XmlDataUtils.addFields(input, type.getDescribingType());
            BMap<BString, Object> processedRecord = XmlDataUtils.processParentAnnotation(type.getDescribingType(), recordField);
            BString rootTagName = ((BString[])processedRecord.getKeys())[0];
            jsonArray.append(processedRecord.get((Object)rootTagName));
            jsonArray.append((Object)rootTagName);
            return jsonArray;
        }
        return input;
    }

    private static BMap<BString, Object> addFields(BMap<BString, Object> input, Type type) {
        BMap recordValue = ValueCreator.createMapValue((MapType)Constants.JSON_MAP_TYPE);
        Map fields = ((RecordType)type).getFields();
        BMap annotations = ((RecordType)type).getAnnotations();
        for (Map.Entry entry : input.entrySet()) {
            String key = ((BString)entry.getKey()).getValue();
            Object value = entry.getValue();
            if (fields.containsKey(key)) {
                Type fieldType = ((Field)fields.get(key)).getFieldType();
                if ((fieldType = XmlDataUtils.getTypeFromUnionType(fieldType, value)).getTag() == 24) {
                    XmlDataUtils.processRecord(key, (BMap<BString, Object>)annotations, (BMap<BString, Object>)recordValue, value, fieldType);
                    continue;
                }
                if (fieldType.getTag() == 53) {
                    Type referredType = TypeUtils.getReferredType((Type)fieldType);
                    if (annotations.size() > 0) {
                        key = XmlDataUtils.getKeyNameFromAnnotation((BMap<BString, Object>)annotations, key);
                    }
                    BMap subRecordAnnotations = ((RecordType)referredType).getAnnotations();
                    key = XmlDataUtils.getElementName((BMap<BString, Object>)subRecordAnnotations, key);
                    BMap annotationRecord = ValueCreator.createMapValue((MapType)Constants.JSON_MAP_TYPE);
                    XmlDataUtils.processSubRecordAnnotation((BMap<BString, Object>)subRecordAnnotations, (BMap<BString, Object>)annotationRecord);
                    BMap<BString, Object> subRecordValue = XmlDataUtils.addFields((BMap<BString, Object>)((BMap)value), referredType);
                    if (annotationRecord.size() > 0) {
                        subRecordValue.put((Object)((BString[])annotationRecord.getKeys())[0], annotationRecord.get((Object)((BString[])annotationRecord.getKeys())[0]));
                    }
                    recordValue.put((Object)StringUtils.fromString((String)key), subRecordValue);
                    continue;
                }
                if (fieldType.getTag() == 32) {
                    XmlDataUtils.processArray(fieldType, (BMap<BString, Object>)annotations, (BMap<BString, Object>)recordValue, entry);
                    continue;
                }
                XmlDataUtils.addPrimitiveValue(StringUtils.fromString((String)key), (BMap<BString, Object>)annotations, (BMap<BString, Object>)recordValue, value);
                continue;
            }
            recordValue.put((Object)StringUtils.fromString((String)key), value);
        }
        return recordValue;
    }

    private static void processRecord(String key, BMap<BString, Object> parentAnnotations, BMap<BString, Object> record, Object value, Type childType) {
        BMap parentRecordAnnotations = ValueCreator.createMapValue((MapType)Constants.JSON_MAP_TYPE);
        BMap annotation = ((RecordType)childType).getAnnotations();
        if (parentAnnotations.size() > 0) {
            XmlDataUtils.processSubRecordAnnotation(parentAnnotations, (BMap<BString, Object>)parentRecordAnnotations);
        }
        BMap<BString, Object> subRecord = XmlDataUtils.addFields((BMap<BString, Object>)((BMap)value), childType);
        if (annotation.size() > 0) {
            XmlDataUtils.processSubRecordAnnotation((BMap<BString, Object>)annotation, subRecord);
        }
        key = XmlDataUtils.getElementName((BMap<BString, Object>)annotation, key);
        record.put((Object)StringUtils.fromString((String)key), subRecord);
        if (parentRecordAnnotations.size() > 0) {
            record.put((Object)((BString[])parentRecordAnnotations.getKeys())[0], parentRecordAnnotations.get((Object)((BString[])parentRecordAnnotations.getKeys())[0]));
        }
    }

    private static void addPrimitiveValue(BString key, BMap<BString, Object> annotations, BMap<BString, Object> record, Object value) {
        BString annotationKey = StringUtils.fromString((String)("$field$." + String.valueOf(key)).replace(":", "\\:"));
        if (annotations.containsKey((Object)annotationKey)) {
            BMap annotationValue = (BMap)annotations.get((Object)annotationKey);
            record.put((Object)StringUtils.fromString((String)XmlDataUtils.processFieldAnnotation((BMap<BString, Object>)annotationValue, key.getValue())), value);
        } else {
            record.put((Object)key, value);
        }
    }

    private static void processArray(Type childType, BMap<BString, Object> annotations, BMap<BString, Object> record, Map.Entry<BString, Object> entry) {
        Type elementType = TypeUtils.getReferredType((Type)((ArrayType)childType).getElementType());
        BMap annotationRecord = ValueCreator.createMapValue((MapType)Constants.JSON_MAP_TYPE);
        String keyName = entry.getKey().getValue();
        if (annotations.size() > 0) {
            keyName = XmlDataUtils.getKeyNameFromAnnotation(annotations, keyName);
            XmlDataUtils.processSubRecordAnnotation(annotations, (BMap<BString, Object>)annotationRecord);
        }
        BArray arrayValue = (BArray)entry.getValue();
        if (elementType.getTag() == 24) {
            ArrayList<BMap> records = new ArrayList<BMap>();
            int i = 0;
            while ((long)i < arrayValue.getLength()) {
                BMap<BString, Object> subRecord = XmlDataUtils.addFields((BMap<BString, Object>)((BMap)arrayValue.get((long)i)), elementType);
                subRecord = XmlDataUtils.processParentAnnotation(elementType, subRecord);
                records.add((BMap)subRecord.get((Object)((BString[])subRecord.getKeys())[0]));
                ++i;
            }
            record.put((Object)StringUtils.fromString((String)XmlDataUtils.getElementName((BMap<BString, Object>)((RecordType)elementType).getAnnotations(), keyName)), (Object)ValueCreator.createArrayValue((Object[])records.toArray(), (ArrayType)TypeCreator.createArrayType((Type)Constants.JSON_ARRAY_TYPE)));
        } else {
            ArrayList<Object> records = new ArrayList<Object>();
            int i = 0;
            while ((long)i < arrayValue.getLength()) {
                records.add(arrayValue.get((long)i));
                ++i;
            }
            record.put((Object)StringUtils.fromString((String)keyName), (Object)ValueCreator.createArrayValue((Object[])records.toArray(), (ArrayType)TypeCreator.createArrayType((Type)Constants.JSON_ARRAY_TYPE)));
        }
        if (annotationRecord.size() > 0) {
            record.put((Object)((BString[])annotationRecord.getKeys())[0], annotationRecord.get((Object)((BString[])annotationRecord.getKeys())[0]));
        }
    }

    private static String getKeyNameFromAnnotation(BMap<BString, Object> annotations, String keyName) {
        BString annotationKey = StringUtils.fromString((String)("$field$." + keyName).replace(":", "\\:"));
        if (annotations.containsKey((Object)annotationKey)) {
            BMap annotationValue = (BMap)annotations.get((Object)annotationKey);
            return XmlDataUtils.processFieldAnnotation((BMap<BString, Object>)annotationValue, keyName);
        }
        return keyName;
    }

    public static Type getTypeFromUnionType(Type childType, Object value) {
        if (childType instanceof UnionType) {
            UnionType bUnionType = (UnionType)childType;
            for (Type memberType : bUnionType.getMemberTypes()) {
                if (!value.getClass().getName().toUpperCase(Locale.ROOT).contains(memberType.getName().toUpperCase(Locale.ROOT))) continue;
                childType = TypeUtils.getReferredType((Type)memberType);
            }
        }
        return childType;
    }

    private static BMap<BString, Object> processParentAnnotation(Type type, BMap<BString, Object> record) {
        BMap parentRecord = ValueCreator.createMapValue((MapType)Constants.JSON_MAP_TYPE);
        BMap namespaces = ValueCreator.createMapValue((MapType)Constants.JSON_MAP_TYPE);
        BMap annotations = ((RecordType)type).getAnnotations();
        BString rootName = XmlDataUtils.processAnnotation((BMap<BString, Object>)annotations, type.getName(), (BMap<BString, Object>)namespaces);
        if (namespaces.size() > 0) {
            for (Map.Entry namespace : namespaces.entrySet()) {
                record.put((Object)((BString)namespace.getKey()), namespace.getValue());
            }
        }
        parentRecord.put((Object)rootName, record);
        return parentRecord;
    }

    private static String processFieldAnnotation(BMap<BString, Object> annotation, String key) {
        for (BString value : (BString[])annotation.getKeys()) {
            String stringValue = value.getValue();
            if (stringValue.endsWith("Name")) {
                BMap names = (BMap)annotation.get((Object)value);
                String name = names.get((Object)StringUtils.fromString((String)VALUE)).toString();
                key = ((String)key).contains(":") ? ((String)key).substring(0, ((String)key).indexOf(":") + 1) + name : (((String)key).contains(ATTRIBUTE_PREFIX) ? ((String)key).substring(0, ((String)key).indexOf("_") + 1) + name : name);
            }
            if (!stringValue.endsWith("Attribute")) continue;
            key = ATTRIBUTE_PREFIX.concat((String)key);
        }
        return key;
    }

    private static BString processAnnotation(BMap<BString, Object> annotation, String key, BMap<BString, Object> namespaces) {
        boolean hasNamespaceAnnotation = false;
        for (BString value : (BString[])annotation.getKeys()) {
            if (value.getValue().contains("$field$.")) continue;
            String stringValue = value.getValue();
            if (stringValue.endsWith("Name")) {
                key = XmlDataUtils.processNameAnnotation(annotation, key, value, hasNamespaceAnnotation);
            }
            if (!stringValue.endsWith("Namespace")) continue;
            hasNamespaceAnnotation = true;
            key = XmlDataUtils.processNamespaceAnnotation(annotation, key, value, namespaces);
        }
        return StringUtils.fromString((String)key);
    }

    private static void processSubRecordAnnotation(BMap<BString, Object> annotation, BMap<BString, Object> subRecord) {
        BString[] keys;
        for (BString value : keys = (BString[])annotation.getKeys()) {
            if (!value.getValue().endsWith("Namespace")) continue;
            XmlDataUtils.processNamespaceAnnotation(annotation, "", value, subRecord);
        }
    }

    private static String getElementName(BMap<BString, Object> annotation, String key) {
        BString[] keys = (BString[])annotation.getKeys();
        boolean hasNamespaceAnnotation = false;
        for (BString value : keys) {
            if (value.getValue().endsWith("Namespace")) {
                hasNamespaceAnnotation = true;
                BMap namespaceAnnotation = (BMap)annotation.get((Object)value);
                BString prefix = (BString)namespaceAnnotation.get((Object)StringUtils.fromString((String)"prefix"));
                if (prefix != null) {
                    key = prefix.getValue().concat(":").concat(key);
                }
            }
            if (!value.getValue().endsWith("Name")) continue;
            key = XmlDataUtils.processNameAnnotation(annotation, key, value, hasNamespaceAnnotation);
        }
        return key;
    }

    private static String processNameAnnotation(BMap<BString, Object> annotation, String key, BString value, boolean hasNamespaceAnnotation) {
        String nameValue = ((BMap)annotation.get((Object)value)).get((Object)StringUtils.fromString((String)VALUE)).toString();
        if (hasNamespaceAnnotation) {
            return key.substring(0, key.indexOf(":") + 1) + nameValue;
        }
        return nameValue;
    }

    private static String processNamespaceAnnotation(BMap<BString, Object> annotation, String key, BString value, BMap<BString, Object> subRecord) {
        BMap namespaceAnnotation = (BMap)annotation.get((Object)value);
        BString uri = (BString)namespaceAnnotation.get((Object)StringUtils.fromString((String)"uri"));
        BString prefix = (BString)namespaceAnnotation.get((Object)StringUtils.fromString((String)"prefix"));
        if (prefix == null) {
            subRecord.put((Object)StringUtils.fromString((String)"attribute_xmlns"), (Object)uri);
        } else {
            subRecord.put((Object)StringUtils.fromString((String)("attribute_xmlns:" + String.valueOf(prefix))), (Object)uri);
            key = prefix.getValue().concat(":").concat(key);
        }
        return key;
    }
}

