/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ai;

import io.ballerina.stdlib.ai.AbstractTagSplitter;
import io.ballerina.stdlib.ai.RecursiveChunker;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AbstractTagSplitterTest {
    @Test
    public void testSimpleHtml() {
        TestTagSplitter splitter = new TestTagSplitter("h1");
        Iterator iterator = splitter.split("Before<h1>Header Content</h1>After");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix.piece(), (String)"Before");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag.piece(), (String)"<h1>Header Content</h1>");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix.piece(), (String)"After");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testMultipleInstances() {
        TestTagSplitter splitter = new TestTagSplitter("p");
        Iterator iterator = splitter.split("Start<p>First</p>Middle<p>Second</p>End");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix1 = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix1.piece(), (String)"Start");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag1 = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag1.piece(), (String)"<p>First</p>");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix1 = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix1.piece(), (String)"Middle");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix2 = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix2.piece(), (String)"");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag2 = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag2.piece(), (String)"<p>Second</p>");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix2 = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix2.piece(), (String)"End");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testNoPrefixNoSuffix() {
        TestTagSplitter splitter = new TestTagSplitter("h1");
        Iterator iterator = splitter.split("<h1>Just Header</h1>");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix.piece(), (String)"");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag.piece(), (String)"<h1>Just Header</h1>");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix.piece(), (String)"");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testNestedTags() {
        TestTagSplitter splitter = new TestTagSplitter("div");
        Iterator iterator = splitter.split("Before<div>Content <span>nested</span> more</div>After");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix.piece(), (String)"Before");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag.piece(), (String)"<div>Content <span>nested</span> more</div>");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix.piece(), (String)"After");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testTagsAroundTarget() {
        TestTagSplitter splitter = new TestTagSplitter("h1");
        Iterator iterator = splitter.split("<p>Paragraph</p><h1>Header</h1><span>Span</span>");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix.piece(), (String)"<p>Paragraph</p>");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag.piece(), (String)"<h1>Header</h1>");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix.piece(), (String)"<span>Span</span>");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testTagWithAttributes() {
        TestTagSplitter splitter = new TestTagSplitter("div");
        Iterator iterator = splitter.split("Before<div class=\"container\" id=\"main\">Content</div>After");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix.piece(), (String)"Before");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag.piece(), (String)"<div class=\"container\" id=\"main\">Content</div>");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix.piece(), (String)"After");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test(expectedExceptions={IndexOutOfBoundsException.class})
    public void testUnclosedTag() {
        TestTagSplitter splitter = new TestTagSplitter("h1");
        Iterator iterator = splitter.split("Before<h1>Unclosed content");
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    static class TestTagSplitter
    extends AbstractTagSplitter {
        TestTagSplitter(String tagName) {
            super(tagName);
        }
    }
}

