/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ai;

import io.ballerina.stdlib.ai.HtmlHeaderSplitter;
import io.ballerina.stdlib.ai.RecursiveChunker;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HtmlHeaderSplitterTest {
    @Test
    public void testH1HeaderBasic() {
        HtmlHeaderSplitter splitter = new HtmlHeaderSplitter(1);
        Iterator iterator = splitter.split("Before<h1>Main Title</h1>After");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix.piece(), (String)"Before");
        Assert.assertEquals((int)prefix.metadata().size(), (int)0);
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag.piece(), (String)"<h1>Main Title</h1>");
        Assert.assertEquals((int)tag.metadata().size(), (int)2);
        Assert.assertEquals((String)((String)tag.metadata().get("header1")), (String)"Main Title");
        Assert.assertEquals((String)((String)tag.metadata().get("header")), (String)"Main Title");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix.piece(), (String)"After");
        Assert.assertEquals((int)suffix.metadata().size(), (int)2);
        Assert.assertEquals((String)((String)suffix.metadata().get("header1")), (String)"Main Title");
        Assert.assertEquals((String)((String)tag.metadata().get("header")), (String)"Main Title");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testH2Header() {
        HtmlHeaderSplitter splitter = new HtmlHeaderSplitter(2);
        Iterator iterator = splitter.split("Content<h2>Subtitle</h2>More content");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix.piece(), (String)"Content");
        Assert.assertEquals((int)prefix.metadata().size(), (int)0);
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag.piece(), (String)"<h2>Subtitle</h2>");
        Assert.assertEquals((String)((String)tag.metadata().get("header2")), (String)"Subtitle");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix.piece(), (String)"More content");
        Assert.assertEquals((String)((String)suffix.metadata().get("header2")), (String)"Subtitle");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testMultipleHeaders() {
        HtmlHeaderSplitter splitter = new HtmlHeaderSplitter(1);
        Iterator iterator = splitter.split("Start<h1>First</h1>Middle<h1>Second</h1>End");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix1 = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix1.piece(), (String)"Start");
        Assert.assertEquals((int)prefix1.metadata().size(), (int)0);
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag1 = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag1.piece(), (String)"<h1>First</h1>");
        Assert.assertEquals((String)((String)tag1.metadata().get("header1")), (String)"First");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix1 = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix1.piece(), (String)"Middle");
        Assert.assertEquals((String)((String)suffix1.metadata().get("header1")), (String)"First");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix2 = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix2.piece(), (String)"");
        Assert.assertEquals((int)prefix2.metadata().size(), (int)0);
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag2 = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag2.piece(), (String)"<h1>Second</h1>");
        Assert.assertEquals((String)((String)tag2.metadata().get("header1")), (String)"Second");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix2 = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix2.piece(), (String)"End");
        Assert.assertEquals((String)((String)suffix2.metadata().get("header1")), (String)"Second");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testHeaderWithAttributes() {
        HtmlHeaderSplitter splitter = new HtmlHeaderSplitter(1);
        Iterator iterator = splitter.split("Before<h1 class=\"title\" id=\"main\">Header with Attributes</h1>After");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix.piece(), (String)"Before");
        Assert.assertEquals((int)prefix.metadata().size(), (int)0);
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag.piece(), (String)"<h1 class=\"title\" id=\"main\">Header with Attributes</h1>");
        Assert.assertEquals((String)((String)tag.metadata().get("header1")), (String)"Header with Attributes");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix.piece(), (String)"After");
        Assert.assertEquals((String)((String)suffix.metadata().get("header1")), (String)"Header with Attributes");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testHeaderWithNestedTags() {
        HtmlHeaderSplitter splitter = new HtmlHeaderSplitter(2);
        Iterator iterator = splitter.split("Text<h2>Header with <em>emphasis</em></h2>More text");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix.piece(), (String)"Text");
        Assert.assertEquals((int)prefix.metadata().size(), (int)0);
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag.piece(), (String)"<h2>Header with <em>emphasis</em></h2>");
        Assert.assertEquals((String)((String)tag.metadata().get("header2")), (String)"Header with emphasis");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix.piece(), (String)"More text");
        Assert.assertEquals((String)((String)suffix.metadata().get("header2")), (String)"Header with emphasis");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testDifferentHeaderLevels() {
        for (int level = 1; level <= 6; ++level) {
            HtmlHeaderSplitter splitter = new HtmlHeaderSplitter(level);
            String tagName = "h" + level;
            String content = String.format("Before<%s>Level %d Header</%s>After", tagName, level, tagName);
            Iterator iterator = splitter.split(content);
            Assert.assertTrue((boolean)iterator.hasNext());
            iterator.next();
            Assert.assertTrue((boolean)iterator.hasNext());
            RecursiveChunker.Chunk tag = (RecursiveChunker.Chunk)iterator.next();
            Assert.assertEquals((String)((String)tag.metadata().get("header" + level)), (String)("Level " + level + " Header"));
            Assert.assertTrue((boolean)iterator.hasNext());
            RecursiveChunker.Chunk suffix = (RecursiveChunker.Chunk)iterator.next();
            Assert.assertEquals((String)((String)suffix.metadata().get("header" + level)), (String)("Level " + level + " Header"));
        }
    }

    @Test
    public void testEmptyHeader() {
        HtmlHeaderSplitter splitter = new HtmlHeaderSplitter(1);
        Iterator iterator = splitter.split("Before<h1></h1>After");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix.piece(), (String)"Before");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag.piece(), (String)"<h1></h1>");
        Assert.assertEquals((String)((String)tag.metadata().get("header1")), (String)"");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix.piece(), (String)"After");
        Assert.assertEquals((String)((String)suffix.metadata().get("header1")), (String)"");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testWhitespaceInHeader() {
        HtmlHeaderSplitter splitter = new HtmlHeaderSplitter(3);
        Iterator iterator = splitter.split("Text<h3>   Whitespace Header   </h3>More");
        iterator.next();
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)((String)tag.metadata().get("header3")), (String)"Whitespace Header");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)((String)suffix.metadata().get("header3")), (String)"Whitespace Header");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testNoHeaders() {
        HtmlHeaderSplitter splitter = new HtmlHeaderSplitter(1);
        Iterator iterator = splitter.split("Just plain text with no headers");
        boolean hasChunks = false;
        if (iterator.hasNext()) {
            RecursiveChunker.Chunk chunk = (RecursiveChunker.Chunk)iterator.next();
            hasChunks = true;
            Assert.assertNotNull((Object)chunk.piece());
        }
        Assert.assertTrue((boolean)hasChunks, (String)"Should produce at least one chunk");
    }

    @Test
    public void testHeaderAtStart() {
        HtmlHeaderSplitter splitter = new HtmlHeaderSplitter(1);
        Iterator iterator = splitter.split("<h1>First Header</h1>Content after");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix.piece(), (String)"");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag.piece(), (String)"<h1>First Header</h1>");
        Assert.assertEquals((String)((String)tag.metadata().get("header1")), (String)"First Header");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix.piece(), (String)"Content after");
        Assert.assertEquals((String)((String)suffix.metadata().get("header1")), (String)"First Header");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testHeaderAtEnd() {
        HtmlHeaderSplitter splitter = new HtmlHeaderSplitter(2);
        Iterator iterator = splitter.split("Content before<h2>Last Header</h2>");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix.piece(), (String)"Content before");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag.piece(), (String)"<h2>Last Header</h2>");
        Assert.assertEquals((String)((String)tag.metadata().get("header2")), (String)"Last Header");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix.piece(), (String)"");
        Assert.assertEquals((String)((String)suffix.metadata().get("header2")), (String)"Last Header");
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

