/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ai;

import io.ballerina.stdlib.ai.HtmlParagraphSplitter;
import io.ballerina.stdlib.ai.RecursiveChunker;
import java.util.Iterator;
import org.testng.Assert;
import org.testng.annotations.Test;

public class HtmlParagraphSplitterTest {
    @Test
    public void testBasicParagraph() {
        HtmlParagraphSplitter splitter = new HtmlParagraphSplitter();
        Iterator iterator = splitter.split("Before<p>Paragraph content</p>After");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix.piece(), (String)"Before");
        Assert.assertEquals((int)prefix.metadata().size(), (int)0);
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag.piece(), (String)"<p>Paragraph content</p>");
        Assert.assertEquals((int)tag.metadata().size(), (int)0);
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix.piece(), (String)"After");
        Assert.assertEquals((int)suffix.metadata().size(), (int)0);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testMultipleParagraphs() {
        HtmlParagraphSplitter splitter = new HtmlParagraphSplitter();
        Iterator iterator = splitter.split("Start<p>First paragraph</p>Middle<p>Second paragraph</p>End");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix1 = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix1.piece(), (String)"Start");
        Assert.assertEquals((int)prefix1.metadata().size(), (int)0);
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag1 = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag1.piece(), (String)"<p>First paragraph</p>");
        Assert.assertEquals((int)tag1.metadata().size(), (int)0);
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix1 = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix1.piece(), (String)"Middle");
        Assert.assertEquals((int)suffix1.metadata().size(), (int)0);
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix2 = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix2.piece(), (String)"");
        Assert.assertEquals((int)prefix2.metadata().size(), (int)0);
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag2 = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag2.piece(), (String)"<p>Second paragraph</p>");
        Assert.assertEquals((int)tag2.metadata().size(), (int)0);
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix2 = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix2.piece(), (String)"End");
        Assert.assertEquals((int)suffix2.metadata().size(), (int)0);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testParagraphWithAttributes() {
        HtmlParagraphSplitter splitter = new HtmlParagraphSplitter();
        Iterator iterator = splitter.split("Before<p class=\"intro\" id=\"first\">Paragraph with attributes</p>After");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix.piece(), (String)"Before");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag.piece(), (String)"<p class=\"intro\" id=\"first\">Paragraph with attributes</p>");
        Assert.assertEquals((int)tag.metadata().size(), (int)0);
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix.piece(), (String)"After");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testParagraphWithNestedTags() {
        HtmlParagraphSplitter splitter = new HtmlParagraphSplitter();
        Iterator iterator = splitter.split("Text<p>Paragraph with <strong>bold</strong> text</p>More text");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix.piece(), (String)"Text");
        Assert.assertEquals((int)prefix.metadata().size(), (int)0);
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag.piece(), (String)"<p>Paragraph with <strong>bold</strong> text</p>");
        Assert.assertEquals((int)tag.metadata().size(), (int)0);
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix.piece(), (String)"More text");
        Assert.assertEquals((int)suffix.metadata().size(), (int)0);
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testEmptyParagraph() {
        HtmlParagraphSplitter splitter = new HtmlParagraphSplitter();
        Iterator iterator = splitter.split("Before<p></p>After");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix.piece(), (String)"Before");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag.piece(), (String)"<p></p>");
        Assert.assertEquals((int)tag.metadata().size(), (int)0);
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix.piece(), (String)"After");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testParagraphAtStart() {
        HtmlParagraphSplitter splitter = new HtmlParagraphSplitter();
        Iterator iterator = splitter.split("<p>First paragraph</p>Content after");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix.piece(), (String)"");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag.piece(), (String)"<p>First paragraph</p>");
        Assert.assertEquals((int)tag.metadata().size(), (int)0);
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix.piece(), (String)"Content after");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testParagraphAtEnd() {
        HtmlParagraphSplitter splitter = new HtmlParagraphSplitter();
        Iterator iterator = splitter.split("Content before<p>Last paragraph</p>");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix.piece(), (String)"Content before");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag.piece(), (String)"<p>Last paragraph</p>");
        Assert.assertEquals((int)tag.metadata().size(), (int)0);
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix.piece(), (String)"");
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testNoParagraphs() {
        HtmlParagraphSplitter splitter = new HtmlParagraphSplitter();
        Iterator iterator = splitter.split("Just plain text with no paragraphs");
        boolean hasChunks = false;
        if (iterator.hasNext()) {
            RecursiveChunker.Chunk chunk = (RecursiveChunker.Chunk)iterator.next();
            hasChunks = true;
            Assert.assertNotNull((Object)chunk.piece());
        }
        Assert.assertTrue((boolean)hasChunks, (String)"Should produce at least one chunk");
    }

    @Test
    public void testParagraphsAroundOtherTags() {
        HtmlParagraphSplitter splitter = new HtmlParagraphSplitter();
        Iterator iterator = splitter.split("<div>Div content</div><p>Paragraph content</p><span>Span content</span>");
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk prefix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)prefix.piece(), (String)"<div>Div content</div>");
        Assert.assertEquals((int)prefix.metadata().size(), (int)0);
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk tag = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)tag.piece(), (String)"<p>Paragraph content</p>");
        Assert.assertEquals((int)tag.metadata().size(), (int)0);
        Assert.assertTrue((boolean)iterator.hasNext());
        RecursiveChunker.Chunk suffix = (RecursiveChunker.Chunk)iterator.next();
        Assert.assertEquals((String)suffix.piece(), (String)"<span>Span content</span>");
        Assert.assertEquals((int)suffix.metadata().size(), (int)0);
        Assert.assertFalse((boolean)iterator.hasNext());
    }
}

