/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ai;

import dev.langchain4j.data.segment.TextSegment;
import io.ballerina.stdlib.ai.MarkdownChunker;
import io.ballerina.stdlib.ai.RecursiveChunker;
import io.ballerina.stdlib.ai.TestUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class MarkdownChunkerIntegrationTest {
    private static final int CHUNK_SIZE = 500;
    private static final int MAX_OVERLAP_SIZE = 50;
    private static final String INPUT_DIR = "markdown-chunker-test/input";
    private static final String EXPECTED_DIR = "markdown-chunker-test/expected";

    @BeforeMethod
    public void setUp() throws Exception {
        TestUtil.resetChunkIdCounter();
    }

    static String normalizeNewLines(String content) {
        return content.replaceAll("\r\n", "\n").replaceAll("\r", "\n");
    }

    /*
     * Exception decompiling
     */
    @DataProvider(name="markdownFiles")
    public Object[][] markdownFiles() throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Test(dataProvider="markdownFiles")
    public void testMarkdownChunking(String fileName) throws IOException {
        String inputContent = MarkdownChunkerIntegrationTest.normalizeNewLines(this.loadFileContent("markdown-chunker-test/input/" + fileName));
        List chunks = MarkdownChunker.chunk((String)inputContent, (int)500, (int)50);
        this.validateTextSegmentIndices(chunks);
        this.validateTextSegmentMaxSize(chunks, 500);
        this.validateChunkContent(chunks, inputContent);
        String actualOutput = TestUtil.formatChunksOutput(chunks, 500, 50);
        String expectedFileName = fileName.replace(".md", "_500_50.txt");
        String expectedOutput = MarkdownChunkerIntegrationTest.normalizeNewLines(this.getExpectedOutput(expectedFileName, actualOutput));
        Assert.assertEquals((String)actualOutput, (String)expectedOutput, (String)("Chunking output for " + fileName + " does not match expected result"));
    }

    @Test(dataProvider="markdownFiles")
    public void testMarkdownChunkingWithoutOverlap(String fileName) throws IOException {
        String inputContent = MarkdownChunkerIntegrationTest.normalizeNewLines(this.loadFileContent("markdown-chunker-test/input/" + fileName));
        List chunks = MarkdownChunker.chunk((String)inputContent, (int)500, (int)0);
        this.validateTextSegmentIndices(chunks);
        this.validateTextSegmentMaxSize(chunks, 500);
        String combinedChunks = chunks.stream().map(TextSegment::text).collect(Collectors.joining());
        Assert.assertEquals((String)combinedChunks, (String)inputContent, (String)("Chunking without overlap should return the original content for " + fileName));
        String actualOutput = TestUtil.formatChunksOutput(chunks, 500, 0);
        String expectedFileName = fileName.replace(".md", "_500_0.txt");
        String expectedOutput = MarkdownChunkerIntegrationTest.normalizeNewLines(this.getExpectedOutput(expectedFileName, actualOutput));
        Assert.assertEquals((String)actualOutput, (String)expectedOutput, (String)("Chunking output for " + fileName + " does not match expected result"));
    }

    private String loadFileContent(String relativePath) throws IOException {
        Path resourcePath = this.getResourcePath(relativePath);
        return Files.readString(resourcePath);
    }

    private Path getResourcePath(String relativePath) {
        return Paths.get(System.getProperty("user.dir"), new String[0]).resolve("src/test/resources").resolve(relativePath);
    }

    @DataProvider(name="chunkStrategies")
    public Object[][] chunkStrategies() {
        return new Object[][]{{MarkdownChunker.MarkdownChunkStrategy.BY_HEADER}, {MarkdownChunker.MarkdownChunkStrategy.BY_CODE_BLOCK}, {MarkdownChunker.MarkdownChunkStrategy.BY_HORIZONTAL_LINE}, {MarkdownChunker.MarkdownChunkStrategy.BY_PARAGRAPH}, {MarkdownChunker.MarkdownChunkStrategy.BY_LINE}, {MarkdownChunker.MarkdownChunkStrategy.BY_SENTENCE}, {MarkdownChunker.MarkdownChunkStrategy.BY_WORD}, {MarkdownChunker.MarkdownChunkStrategy.BY_CHARACTER}};
    }

    @Test
    public void testByHeaderStrategy() {
        String markdownWithHeaders = "# Header 1\nContent under header 1.\n\n## Header 2\nContent under header 2.\n\n### Header 3\nContent under header 3.\n";
        List chunks = MarkdownChunker.chunk((String)markdownWithHeaders, (MarkdownChunker.MarkdownChunkStrategy)MarkdownChunker.MarkdownChunkStrategy.BY_HEADER, (int)200, (int)20);
        Assert.assertFalse((boolean)chunks.isEmpty(), (String)"BY_HEADER should produce chunks");
        boolean hasHeaderMetadata = chunks.stream().anyMatch(chunk -> chunk.metadata().toMap().containsKey("header"));
    }

    @Test
    public void testByCodeBlockStrategy() {
        String markdownWithCode = "Some text before code.\n\n```java\npublic void example() {\n    foo(\"Hello\");\n}\n```\n\nSome text after code.\n\n```python\nprint(\"Hello\")\n```\n\nFinal text.\n";
        List chunks = MarkdownChunker.chunk((String)markdownWithCode, (MarkdownChunker.MarkdownChunkStrategy)MarkdownChunker.MarkdownChunkStrategy.BY_CODE_BLOCK, (int)200, (int)20);
        Assert.assertTrue((chunks.size() >= 3 ? 1 : 0) != 0, (String)"BY_CODE_BLOCK should separate code blocks");
        boolean hasCodeBlockMetadata = chunks.stream().anyMatch(chunk -> "code_block".equals(chunk.metadata().toMap().get("type")));
        Assert.assertTrue((boolean)hasCodeBlockMetadata, (String)"Code blocks should have type metadata");
        boolean hasLanguageMetadata = chunks.stream().anyMatch(chunk -> chunk.metadata().toMap().containsKey("language"));
        Assert.assertTrue((boolean)hasLanguageMetadata, (String)"Code blocks should have language metadata");
    }

    @Test
    public void testByHorizontalLineStrategy() {
        String markdownWithHorizontalLines = "Section 1 content.\n\n---\n\nSection 2 content.\n\n***\n\nSection 3 content.\n\n___\n\nSection 4 content.\n";
        List chunks = MarkdownChunker.chunk((String)markdownWithHorizontalLines, (MarkdownChunker.MarkdownChunkStrategy)MarkdownChunker.MarkdownChunkStrategy.BY_HORIZONTAL_LINE, (int)200, (int)20);
        Assert.assertFalse((boolean)chunks.isEmpty(), (String)"BY_HORIZONTAL_LINE should produce chunks");
    }

    @Test
    public void testByParagraphStrategy() {
        String markdownWithParagraphs = "First paragraph with some content.\n\nSecond paragraph with different content.\n\nThird paragraph here.\n";
        List chunks = MarkdownChunker.chunk((String)markdownWithParagraphs, (MarkdownChunker.MarkdownChunkStrategy)MarkdownChunker.MarkdownChunkStrategy.BY_PARAGRAPH, (int)100, (int)10);
        Assert.assertFalse((boolean)chunks.isEmpty(), (String)"BY_PARAGRAPH should produce chunks");
    }

    @Test
    public void testByLineStrategy() {
        String markdownWithLines = "Line 1\nLine 2\nLine 3\nLine 4\n";
        List chunks = MarkdownChunker.chunk((String)markdownWithLines, (MarkdownChunker.MarkdownChunkStrategy)MarkdownChunker.MarkdownChunkStrategy.BY_LINE, (int)20, (int)5);
        Assert.assertTrue((chunks.size() >= 2 ? 1 : 0) != 0, (String)"BY_LINE should split at line breaks");
    }

    @Test
    public void testBySentenceStrategy() {
        String markdownWithSentences = "First sentence. Second sentence. Third sentence. Fourth sentence.";
        List chunks = MarkdownChunker.chunk((String)markdownWithSentences, (MarkdownChunker.MarkdownChunkStrategy)MarkdownChunker.MarkdownChunkStrategy.BY_SENTENCE, (int)30, (int)5);
        Assert.assertTrue((chunks.size() >= 2 ? 1 : 0) != 0, (String)"BY_SENTENCE should split at sentence boundaries");
    }

    @Test
    public void testByWordStrategy() {
        String markdownWithWords = "word1 word2 word3 word4 word5 word6 word7 word8";
        List chunks = MarkdownChunker.chunk((String)markdownWithWords, (MarkdownChunker.MarkdownChunkStrategy)MarkdownChunker.MarkdownChunkStrategy.BY_WORD, (int)15, (int)3);
        Assert.assertTrue((chunks.size() >= 3 ? 1 : 0) != 0, (String)"BY_WORD should split at word boundaries");
    }

    @Test
    public void testByCharacterStrategy() {
        String shortText = "abcdefghijklmnopqrstuvwxyz";
        List chunks = MarkdownChunker.chunk((String)shortText, (MarkdownChunker.MarkdownChunkStrategy)MarkdownChunker.MarkdownChunkStrategy.BY_CHARACTER, (int)5, (int)1);
        Assert.assertTrue((chunks.size() >= 5 ? 1 : 0) != 0, (String)"BY_CHARACTER should split at character boundaries");
        String reconstructed = chunks.stream().map(TextSegment::text).collect(Collectors.joining());
        Assert.assertTrue((boolean)reconstructed.contains(shortText.substring(0, Math.min(5, shortText.length()))), (String)"Character chunking should preserve content");
    }

    @Test(dataProvider="chunkStrategies")
    void testStrategyConsistency(MarkdownChunker.MarkdownChunkStrategy strategy) throws IOException {
        String inputContent = this.loadFileContent("markdown-chunker-test/input/sample7.md");
        List chunks1 = MarkdownChunker.chunk((String)inputContent, (MarkdownChunker.MarkdownChunkStrategy)strategy, (int)500, (int)50);
        List chunks2 = MarkdownChunker.chunk((String)inputContent, (MarkdownChunker.MarkdownChunkStrategy)strategy, (int)500, (int)50);
        Assert.assertEquals((int)chunks1.size(), (int)chunks2.size(), (String)("Strategy " + String.valueOf(strategy) + " should be deterministic"));
        for (int i = 0; i < chunks1.size(); ++i) {
            Assert.assertEquals((String)((TextSegment)chunks1.get(i)).text(), (String)((TextSegment)chunks2.get(i)).text(), (String)("Chunk " + i + " should be identical for strategy " + String.valueOf(strategy)));
        }
    }

    @Test(dataProvider="chunkStrategies")
    void testStrategyWithDifferentSizes(MarkdownChunker.MarkdownChunkStrategy strategy) throws IOException {
        int[] chunkSizes;
        String inputContent = this.loadFileContent("markdown-chunker-test/input/sample7.md");
        for (int chunkSize : chunkSizes = new int[]{100, 500, 1000}) {
            List chunks = MarkdownChunker.chunk((String)inputContent, (MarkdownChunker.MarkdownChunkStrategy)strategy, (int)chunkSize, (int)20);
            Assert.assertTrue((chunks.size() > 0 ? 1 : 0) != 0, (String)("Strategy " + String.valueOf(strategy) + " with chunk size " + chunkSize + " should produce chunks"));
            for (TextSegment chunk : chunks) {
                Assert.assertTrue((chunk.text().length() <= chunkSize + 200 ? 1 : 0) != 0, (String)("Chunk size " + chunk.text().length() + " exceeds limit for strategy " + String.valueOf(strategy)));
            }
        }
    }

    @Test
    public void testStrategyFallbackBehavior() {
        String singleWord = "word";
        for (MarkdownChunker.MarkdownChunkStrategy strategy : MarkdownChunker.MarkdownChunkStrategy.values()) {
            List chunks = MarkdownChunker.chunk((String)singleWord, (MarkdownChunker.MarkdownChunkStrategy)strategy, (int)100, (int)10);
            Assert.assertEquals((int)chunks.size(), (int)1, (String)("Strategy " + String.valueOf(strategy) + " should produce one chunk for single word"));
            Assert.assertEquals((String)((TextSegment)chunks.getFirst()).text(), (String)singleWord, (String)("Strategy " + String.valueOf(strategy) + " should preserve single word content"));
        }
    }

    private void validateTextSegmentMaxSize(List<TextSegment> chunks, int maxSize) {
        for (TextSegment chunk : chunks) {
            String text = chunk.text();
            Assert.assertTrue((text.length() <= maxSize ? 1 : 0) != 0, (String)("TextSegment exceeds max size of " + maxSize + ": " + text.length()));
        }
    }

    private void validateChunkContent(List<TextSegment> chunks, String originalContent) {
        for (TextSegment chunk : chunks) {
            String text = chunk.text();
            Assert.assertTrue((boolean)originalContent.contains(text), (String)("Chunk content should be part of the original content: " + text));
        }
    }

    private void validateTextSegmentIndices(List<TextSegment> chunks) {
        for (int i = 0; i < chunks.size(); ++i) {
            TextSegment chunk = chunks.get(i);
            Map metadata = chunk.metadata().toMap();
            Assert.assertTrue((boolean)metadata.containsKey("index"), (String)("TextSegment at position " + i + " should have index in metadata"));
            Object indexValue = metadata.get("index");
            Assert.assertTrue((boolean)(indexValue instanceof Integer), (String)("Index should be an Integer, but was " + indexValue.getClass().getSimpleName()));
            Integer index = (Integer)indexValue;
            Assert.assertEquals((int)index, (int)i, (String)("TextSegment at position " + i + " should have index " + i + ", but had " + index));
        }
    }

    @Test
    public void testBreakUpChunkMetadataLinking() {
        Map<String, String> originalMetadata = Map.of("type", "test", "source", "unit_test");
        RecursiveChunker.Chunk originalChunk = new RecursiveChunker.Chunk("This is a very long text that needs to be broken up into smaller chunks", originalMetadata);
        List brokenChunks = RecursiveChunker.breakUpChunk((RecursiveChunker.Chunk)originalChunk, (int)10);
        Assert.assertTrue((brokenChunks.size() > 1 ? 1 : 0) != 0, (String)"Should create multiple chunks when breaking up large content");
        RecursiveChunker.Chunk firstChunk = (RecursiveChunker.Chunk)brokenChunks.get(0);
        Assert.assertFalse((boolean)firstChunk.metadata().containsKey("prev"), (String)"First chunk should not have a prev link");
        for (int i = 1; i < brokenChunks.size(); ++i) {
            RecursiveChunker.Chunk currentChunk = (RecursiveChunker.Chunk)brokenChunks.get(i);
            RecursiveChunker.Chunk previousChunk = (RecursiveChunker.Chunk)brokenChunks.get(i - 1);
            Assert.assertTrue((boolean)currentChunk.metadata().containsKey("prev"), (String)("Chunk " + i + " should have a prev link"));
            String prevId = (String)currentChunk.metadata().get("prev");
            Assert.assertEquals((String)prevId, (String)String.valueOf(previousChunk.id()), (String)("Chunk " + i + " should link to previous chunk's ID"));
        }
        for (RecursiveChunker.Chunk chunk : brokenChunks) {
            Assert.assertEquals((String)((String)chunk.metadata().get("type")), (String)"test", (String)"All chunks should preserve original type metadata");
            Assert.assertEquals((String)((String)chunk.metadata().get("source")), (String)"unit_test", (String)"All chunks should preserve original source metadata");
        }
        String combinedText = brokenChunks.stream().map(RecursiveChunker.Chunk::piece).collect(Collectors.joining());
        Assert.assertEquals((String)combinedText, (String)originalChunk.piece(), (String)"Combined text from broken chunks should equal original text");
    }

    @Test
    public void testBreakUpChunkEdgeCases() {
        Map<String, String> metadata = Map.of("type", "small");
        RecursiveChunker.Chunk smallChunk = new RecursiveChunker.Chunk("Small", metadata);
        List result = RecursiveChunker.breakUpChunk((RecursiveChunker.Chunk)smallChunk, (int)10);
        Assert.assertEquals((int)result.size(), (int)1, (String)"Should return single chunk when content is smaller than max size");
        Assert.assertEquals((String)((RecursiveChunker.Chunk)result.get(0)).piece(), (String)"Small", (String)"Should preserve original content");
        Assert.assertFalse((boolean)((RecursiveChunker.Chunk)result.get(0)).metadata().containsKey("prev"), (String)"Single chunk should not have prev link");
        RecursiveChunker.Chunk emptyChunk = new RecursiveChunker.Chunk("", metadata);
        List emptyResult = RecursiveChunker.breakUpChunk((RecursiveChunker.Chunk)emptyChunk, (int)10);
        Assert.assertEquals((int)emptyResult.size(), (int)0, (String)"Should return empty list for empty chunk");
        RecursiveChunker.Chunk exactChunk = new RecursiveChunker.Chunk("Exactly10!", metadata);
        List exactResult = RecursiveChunker.breakUpChunk((RecursiveChunker.Chunk)exactChunk, (int)10);
        Assert.assertEquals((int)exactResult.size(), (int)1, (String)"Should return single chunk when content is exactly max size");
        Assert.assertEquals((String)((RecursiveChunker.Chunk)exactResult.get(0)).piece(), (String)"Exactly10!", (String)"Should preserve original content");
    }

    private String getExpectedOutput(String expectedFileName, String actualOutput) throws IOException {
        String blessEnv = System.getenv("BLESS");
        boolean shouldBless = "true".equalsIgnoreCase(blessEnv);
        Path expectedPath = this.getResourcePath("markdown-chunker-test/expected/" + expectedFileName);
        if (shouldBless) {
            Files.createDirectories(expectedPath.getParent(), new FileAttribute[0]);
            Files.writeString(expectedPath, (CharSequence)actualOutput, new OpenOption[0]);
            return actualOutput;
        }
        return Files.readString(expectedPath);
    }

    private static /* synthetic */ Object[][] lambda$markdownFiles$3(int x$0) {
        return new Object[x$0][];
    }
}

