/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ai;

import dev.langchain4j.data.segment.TextSegment;
import io.ballerina.stdlib.ai.RecursiveChunker;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class TestUtil {
    public static void resetChunkIdCounter() throws Exception {
        Field nextIdField = RecursiveChunker.Chunk.class.getDeclaredField("nextId");
        nextIdField.setAccessible(true);
        AtomicLong nextId = (AtomicLong)nextIdField.get(null);
        nextId.set(0L);
    }

    static String formatChunksOutput(List<TextSegment> chunks, int chunkSize, int maxOverlapSize) {
        StringBuilder sb = new StringBuilder();
        sb.append(chunkSize).append(" ").append(maxOverlapSize).append("\n\n");
        for (int i = 0; i < chunks.size(); ++i) {
            sb.append("--- Chunk ").append(i + 1).append(" ---\n");
            Map metadata = chunks.get(i).metadata().toMap();
            String body = metadata.keySet().stream().sorted().map(key -> "\"%s\": \"%s\"\n".formatted(key, metadata.get(key).toString())).map(String::trim).collect(Collectors.joining(","));
            sb.append("Metadata: {").append(body).append("}\n");
            sb.append(chunks.get(i).text());
            if (i >= chunks.size() - 1) continue;
            sb.append("\n\n");
        }
        return sb.toString();
    }
}

