/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.ai;

import io.ballerina.stdlib.ai.TextDataLoader;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.tika.exception.TikaException;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.xml.sax.SAXException;

public class TextDataLoaderTest {
    @Test
    public void testParsePDF() throws TikaException, IOException, SAXException {
        Path resourcePath = Paths.get(System.getProperty("user.dir"), new String[0]).resolve("src/test/resources").resolve("doc-reader-test/TestDoc.pdf");
        TextDataLoader.TextDocumentInfo doc = TextDataLoader.parsePDF((String)resourcePath.toString());
        String content = doc.content();
        Assert.assertNotNull((Object)content, (String)"PDF parsing result should not be null");
        Assert.assertFalse((boolean)content.trim().isEmpty(), (String)"PDF parsing result should not be empty");
        Assert.assertTrue((content.length() > 100 ? 1 : 0) != 0, (String)"PDF should contain substantial content");
    }

    @Test
    public void testParseOfficeXDocx() {
        Path resourcePath = Paths.get(System.getProperty("user.dir"), new String[0]).resolve("src/test/resources").resolve("doc-reader-test/TestDoc.docx");
        String result = TextDataLoader.parseOfficeX((String)resourcePath.toString());
        Assert.assertNotNull((Object)result, (String)"DOCX parsing result should not be null");
        Assert.assertFalse((boolean)result.trim().isEmpty(), (String)"DOCX parsing result should not be empty");
        Assert.assertTrue((result.length() > 10 ? 1 : 0) != 0, (String)"DOCX should contain substantial content");
    }

    @Test
    public void testParseOfficeXPptx() {
        Path resourcePath = Paths.get(System.getProperty("user.dir"), new String[0]).resolve("src/test/resources").resolve("doc-reader-test/Test presentation.pptx");
        String result = TextDataLoader.parseOfficeX((String)resourcePath.toString());
        Assert.assertNotNull((Object)result, (String)"PPTX parsing result should not be null");
        Assert.assertFalse((boolean)result.trim().isEmpty(), (String)"PPTX parsing result should not be empty");
        Assert.assertTrue((result.length() > 10 ? 1 : 0) != 0, (String)"PPTX should contain substantial content");
    }

    @Test(expectedExceptions={RuntimeException.class})
    public void testParseOfficeXWithInvalidPath() {
        TextDataLoader.parseOfficeX((String)"non-existent-file.docx");
    }
}

