/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.architecturemodelgenerator.plugin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.ballerina.architecturemodelgenerator.core.ArchitectureModel;
import io.ballerina.architecturemodelgenerator.core.ArchitectureModelBuilder;
import io.ballerina.architecturemodelgenerator.plugin.diagnostic.DiagnosticMessage;
import io.ballerina.projects.BuildOptions;
import io.ballerina.projects.Project;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.CompilationAnalysisContext;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;

public class CompilationAnalysisTask
implements AnalysisTask<CompilationAnalysisContext> {
    public void perform(CompilationAnalysisContext compilationAnalysisContext) {
        Project project = compilationAnalysisContext.currentPackage().project();
        BuildOptions buildOptions = project.buildOptions();
        if (buildOptions.exportComponentModel()) {
            Path outPath = project.targetDir();
            ArchitectureModelBuilder architectureModelBuilder = new ArchitectureModelBuilder();
            ArchitectureModel projectModel = architectureModelBuilder.constructComponentModel(compilationAnalysisContext.currentPackage(), compilationAnalysisContext.compilation());
            Gson gson = new GsonBuilder().setPrettyPrinting().serializeNulls().create();
            String componentModelJson = gson.toJson((Object)projectModel) + System.lineSeparator();
            this.writeComponentModelJson(outPath, componentModelJson, compilationAnalysisContext);
        }
    }

    private void writeComponentModelJson(Path outPath, String componentModelJson, CompilationAnalysisContext context) {
        try {
            Path componentModelExportDir = outPath.resolve("component-model");
            Files.createDirectories(componentModelExportDir, new FileAttribute[0]);
            Path writePath = componentModelExportDir.resolve("component-model.json");
            this.writeFile(writePath, componentModelJson);
        }
        catch (IOException | SecurityException | InvalidPathException e) {
            DiagnosticMessage diagnosticMessage = DiagnosticMessage.ERROR_100;
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(diagnosticMessage.getCode(), diagnosticMessage.getMessageFormat(), diagnosticMessage.getSeverity());
            Diagnostic diagnostic = DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, null, (Object[])new Object[]{e.getMessage()});
            context.reportDiagnostic(diagnostic);
        }
    }

    private void writeFile(Path filePath, String content) throws IOException {
        try (FileWriter writer = new FileWriter(filePath.toString(), StandardCharsets.UTF_8);){
            writer.write(content);
        }
    }
}

