/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.testerina.core;

import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.JarLibrary;
import io.ballerina.projects.JarResolver;
import io.ballerina.projects.Module;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.util.FileUtils;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LinePosition;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.ballerinalang.model.elements.Flag;
import org.ballerinalang.model.elements.PackageID;
import org.ballerinalang.test.runtime.entity.Test;
import org.ballerinalang.test.runtime.entity.TestSuite;
import org.ballerinalang.testerina.core.TesterinaRegistry;
import org.wso2.ballerinalang.compiler.util.Names;

public class TestProcessor {
    private static final String TEST_ANNOTATION_NAME = "Config";
    private static final String BEFORE_SUITE_ANNOTATION_NAME = "BeforeSuite";
    private static final String AFTER_SUITE_ANNOTATION_NAME = "AfterSuite";
    private static final String BEFORE_EACH_ANNOTATION_NAME = "BeforeEach";
    private static final String AFTER_EACH_ANNOTATION_NAME = "AfterEach";
    private static final String TEST_EXECUTE_FILE_PREFIX = "test_execute-generated_";
    private static final String MOCK_ANNOTATION_NAME = "Mock";
    private static final String BEFORE_FUNCTION = "before";
    private static final String AFTER_FUNCTION = "after";
    private static final String DEPENDS_ON_FUNCTIONS = "dependsOn";
    private static final String GROUP_ANNOTATION_NAME = "groups";
    private static final String VALUE_SET_ANNOTATION_NAME = "dataProvider";
    private static final String TEST_ENABLE_ANNOTATION_NAME = "enable";
    private static final String ALWAYS_RUN_FIELD_NAME = "alwaysRun";
    private static final String VALUE_FIELD_NAME = "value";
    private static final String BEFORE_GROUPS_ANNOTATION_NAME = "BeforeGroups";
    private static final String AFTER_GROUPS_ANNOTATION_NAME = "AfterGroups";
    private static final String TEST_PREFIX = "test";
    private static final String FILE_NAME_PERIOD_SEPARATOR = "$$$";
    private static final String MODULE_DELIMITER = "\u00a7";
    private final TesterinaRegistry registry = TesterinaRegistry.getInstance();
    private JarResolver jarResolver;

    public TestProcessor() {
    }

    public TestProcessor(JarResolver jarResolver) {
        this.jarResolver = jarResolver;
    }

    public Optional<TestSuite> testSuite(Module module) {
        if (module.project().kind() != ProjectKind.SINGLE_FILE_PROJECT && module.testDocumentIds().isEmpty()) {
            return Optional.empty();
        }
        if (module.project().buildOptions().skipTests()) {
            return Optional.empty();
        }
        return Optional.of(this.generateTestSuite(module, this.jarResolver));
    }

    private Map<Document, SyntaxTree> getTestSyntaxTreeMap(Module module) {
        HashMap<Document, SyntaxTree> syntaxTreeMap = new HashMap<Document, SyntaxTree>();
        if (this.isSingleFileProject(module.project())) {
            module.documentIds().forEach(documentId -> {
                Document document = module.document(documentId);
                syntaxTreeMap.put(document, document.syntaxTree());
            });
        } else {
            module.testDocumentIds().forEach(documentId -> {
                Document document = module.document(documentId);
                syntaxTreeMap.put(document, document.syntaxTree());
            });
        }
        return syntaxTreeMap;
    }

    private TestSuite generateTestSuite(Module module, JarResolver jarResolver) {
        String testModuleName = TestProcessor.getTestModuleName(module);
        TestSuite testSuite = this.createTestSuite(module, testModuleName);
        if (jarResolver == null) {
            throw new IllegalStateException("Jar resolver is null");
        }
        if (!this.areTestsDelegated(module)) {
            TestProcessor.addTestExecutionDependencies(module, jarResolver, testSuite);
        } else if (module.project().buildOptions().nativeImage()) {
            TestProcessor.addTestExecutionDependencies(module, jarResolver, testSuite);
        }
        this.addUtilityFunctions(module, testSuite);
        this.populateMockFunctionNamesMap(module, testSuite);
        return testSuite;
    }

    private static void addTestExecutionDependencies(Module module, JarResolver jarResolver, TestSuite testSuite) {
        ArrayList<Path> jarPaths = new ArrayList<Path>();
        for (JarLibrary jarLibrary : jarResolver.getJarFilePathsRequiredForTestExecution(module.moduleName())) {
            jarPaths.add(jarLibrary.path());
        }
        testSuite.addTestExecutionDependencies(jarPaths);
    }

    private TestSuite createTestSuite(Module module, String testModuleName) {
        TestSuite testSuite = new TestSuite(module.descriptor().name().toString(), testModuleName, module.descriptor().packageName().toString(), module.descriptor().org().value(), module.descriptor().version().toString(), this.getExecutePath(module));
        TesterinaRegistry.getInstance().getTestSuites().put(module.descriptor().name().toString(), testSuite);
        testSuite.setPackageName(module.descriptor().packageName().toString());
        if (!this.areTestsDelegated(module)) {
            testSuite.setSourceRootPath(module.project().sourceRoot().toString());
        } else {
            testSuite.setSourceRootPath("./");
        }
        return testSuite;
    }

    public static String getTestModuleName(Module module) {
        PackageID packageID = module.descriptor().moduleTestCompilationId();
        return packageID.isTestPkg ? packageID.name.value + String.valueOf(Names.TEST_PACKAGE) : packageID.name.value;
    }

    private void processAnnotations(Module module, TestSuite suite) {
        Map<Document, SyntaxTree> syntaxTreeMap = this.getTestSyntaxTreeMap(module);
        List<FunctionSymbol> functionSymbolList = this.getFunctionSymbolList(syntaxTreeMap, module);
        for (FunctionSymbol functionSymbol : functionSymbolList) {
            String functionName = (String)functionSymbol.getName().get();
            List annotations = functionSymbol.annotations();
            for (AnnotationSymbol annotationSymbol : annotations) {
                String annotationName = (String)annotationSymbol.getName().get();
                if (annotationName.contains(BEFORE_SUITE_ANNOTATION_NAME)) {
                    suite.addBeforeSuiteFunction(functionName);
                    continue;
                }
                if (annotationName.contains(AFTER_SUITE_ANNOTATION_NAME)) {
                    suite.addAfterSuiteFunction(functionName, this.isAlwaysRunValue(this.getAnnotationNode(annotationSymbol, syntaxTreeMap, functionName)));
                    continue;
                }
                if (annotationName.contains(BEFORE_GROUPS_ANNOTATION_NAME)) {
                    this.processGroupsAnnotation(this.getAnnotationNode(annotationSymbol, syntaxTreeMap, functionName), functionName, suite, true);
                    continue;
                }
                if (annotationName.contains(AFTER_GROUPS_ANNOTATION_NAME)) {
                    this.processGroupsAnnotation(this.getAnnotationNode(annotationSymbol, syntaxTreeMap, functionName), functionName, suite, false);
                    continue;
                }
                if (annotationName.contains(BEFORE_EACH_ANNOTATION_NAME)) {
                    suite.addBeforeEachFunction(functionName);
                    continue;
                }
                if (annotationName.contains(AFTER_EACH_ANNOTATION_NAME)) {
                    suite.addAfterEachFunction(functionName);
                    continue;
                }
                if (!annotationName.contains(TEST_ANNOTATION_NAME)) continue;
                this.processTestAnnotation(this.getAnnotationNode(annotationSymbol, syntaxTreeMap, functionName), functionName, suite);
            }
        }
    }

    private AnnotationNode getAnnotationNode(AnnotationSymbol annotationSymbol, Map<Document, SyntaxTree> syntaxTreeMap, String name) {
        for (Map.Entry<Document, SyntaxTree> syntaxTreeEntry : syntaxTreeMap.entrySet()) {
            if (!syntaxTreeEntry.getValue().containsModulePart()) continue;
            ModulePartNode modulePartNode = (ModulePartNode)syntaxTreeMap.get(syntaxTreeEntry.getKey()).rootNode();
            for (Node node : modulePartNode.members()) {
                Optional optionalMetadataNode;
                String functionName;
                if (node.kind() != SyntaxKind.FUNCTION_DEFINITION || !(functionName = ((FunctionDefinitionNode)node).functionName().text()).equals(name) || !(optionalMetadataNode = ((FunctionDefinitionNode)node).metadata()).isPresent()) continue;
                NodeList annotations = ((MetadataNode)optionalMetadataNode.get()).annotations();
                for (AnnotationNode annotation : annotations) {
                    Node annotReference = annotation.annotReference();
                    if (annotReference.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE) continue;
                    QualifiedNameReferenceNode qualifiedNameRef = (QualifiedNameReferenceNode)annotReference;
                    String annotSymbolName = (String)annotationSymbol.getName().get();
                    if (!qualifiedNameRef.modulePrefix().text().equals(TEST_PREFIX) || !qualifiedNameRef.identifier().text().equals(annotSymbolName)) continue;
                    return annotation;
                }
            }
        }
        return null;
    }

    private List<FunctionSymbol> getFunctionSymbolList(Map<Document, SyntaxTree> syntaxTreeMap, Module module) {
        ArrayList<FunctionSymbol> functionSymbolList = new ArrayList<FunctionSymbol>();
        ArrayList<String> functionNamesList = new ArrayList<String>();
        for (Map.Entry<Document, SyntaxTree> syntaxTreeEntry : syntaxTreeMap.entrySet()) {
            List symbols = module.getCompilation().getSemanticModel().visibleSymbols(syntaxTreeEntry.getKey(), LinePosition.from((int)syntaxTreeEntry.getValue().rootNode().location().lineRange().endLine().line(), (int)syntaxTreeEntry.getValue().rootNode().location().lineRange().endLine().offset()));
            for (Symbol symbol : symbols) {
                if (symbol.kind() != SymbolKind.FUNCTION || !(symbol instanceof FunctionSymbol) || functionNamesList.contains(symbol.getName().get())) continue;
                functionSymbolList.add((FunctionSymbol)symbol);
                functionNamesList.add((String)symbol.getName().get());
            }
        }
        return functionSymbolList;
    }

    private boolean isSingleFileProject(Project project) {
        boolean isSingleFileProject = false;
        if (project.kind() == ProjectKind.SINGLE_FILE_PROJECT) {
            isSingleFileProject = true;
        }
        return isSingleFileProject;
    }

    private void addUtilityFunctions(Module module, TestSuite testSuite) {
        HashMap<Document, SyntaxTree> syntaxTreeMap = new HashMap<Document, SyntaxTree>();
        module.documentIds().forEach(documentId -> {
            Document document = module.document(documentId);
            syntaxTreeMap.put(document, document.syntaxTree());
        });
        if (!this.isSingleFileProject(module.project())) {
            module.testDocumentIds().forEach(documentId -> {
                Document document = module.document(documentId);
                syntaxTreeMap.put(document, document.syntaxTree());
            });
        }
        List<FunctionSymbol> functionSymbolList = this.getFunctionSymbolList(syntaxTreeMap, module);
        for (FunctionSymbol functionSymbol : functionSymbolList) {
            String functionName = (String)functionSymbol.getName().get();
            Location pos = (Location)functionSymbol.getLocation().get();
            List qualifiers = functionSymbol.qualifiers();
            boolean isUtility = true;
            for (Qualifier qualifier : qualifiers) {
                if (!Flag.RESOURCE.name().equals(qualifier.getValue()) && !Flag.REMOTE.name().equals(qualifier.getValue())) continue;
                isUtility = false;
                break;
            }
            if (!isUtility) continue;
            boolean testable = ((ModuleSymbol)functionSymbol.getModule().get()).id().isTestable();
            PackageID moduleTestCompilationId = module.descriptor().moduleTestCompilationId();
            String testModuleName = testable ? moduleTestCompilationId.name.value + String.valueOf(Names.TEST_PACKAGE) : moduleTestCompilationId.name.value;
            String className = pos.lineRange().fileName().replace(".bal", "").replace(".", FILE_NAME_PERIOD_SEPARATOR).replace("/", ".");
            String functionClassName = JarResolver.getQualifiedClassName((String)module.descriptor().org().value(), (String)testModuleName, (String)module.descriptor().version().toString(), (String)className);
            testSuite.addTestUtilityFunction(functionName, functionClassName);
        }
    }

    private void populateMockFunctionNamesMap(Module module, TestSuite testSuite) {
        Map<String, String> mockFunctionsSourceMap = this.registry.getMockFunctionSourceMap();
        for (Map.Entry<String, String> entry : mockFunctionsSourceMap.entrySet()) {
            String[] entryValues = entry.getKey().split(MODULE_DELIMITER);
            if (!module.moduleName().toString().equals(entryValues[0])) continue;
            testSuite.addMockFunction(entryValues[1], entry.getValue());
        }
    }

    private boolean isGroupAvailable(List<String> inputGroups, List<String> functionGroups) {
        for (String group : inputGroups) {
            for (String funcGroup : functionGroups) {
                if (!group.equals(funcGroup)) continue;
                return true;
            }
        }
        return false;
    }

    private String getStringValue(Node valueExpr) {
        return valueExpr.toString().replace("\"", "").trim();
    }

    private AtomicBoolean isAlwaysRunValue(AnnotationNode annotationNode) {
        Optional mappingNodes;
        AtomicBoolean alwaysRun = new AtomicBoolean(false);
        if (annotationNode != null && !annotationNode.annotValue().isEmpty() && !(mappingNodes = annotationNode.annotValue()).isEmpty()) {
            ((MappingConstructorExpressionNode)mappingNodes.get()).fields().forEach(mappingFieldNode -> {
                String literalText;
                ExpressionNode valueExpr;
                SpecificFieldNode specificField;
                if (mappingFieldNode.kind() == SyntaxKind.SPECIFIC_FIELD && ALWAYS_RUN_FIELD_NAME.equals(this.getFieldName(specificField = (SpecificFieldNode)mappingFieldNode)) && (valueExpr = (ExpressionNode)specificField.valueExpr().orElse(null)) != null && SyntaxKind.BOOLEAN_LITERAL == valueExpr.kind() && (literalText = ((BasicLiteralNode)valueExpr).literalToken().text()).equals(Boolean.TRUE.toString())) {
                    alwaysRun.set(true);
                }
            });
        }
        return alwaysRun;
    }

    private void processGroupsAnnotation(AnnotationNode annotationNode, String functionName, TestSuite suite, boolean isBeforeGroups) {
        Optional mappingNodes;
        if (annotationNode != null && !annotationNode.annotValue().isEmpty() && !(mappingNodes = annotationNode.annotValue()).isEmpty()) {
            for (MappingFieldNode mappingFieldNode : ((MappingConstructorExpressionNode)mappingNodes.get()).fields()) {
                ExpressionNode valueExpr;
                SpecificFieldNode specificField;
                if (mappingFieldNode.kind() != SyntaxKind.SPECIFIC_FIELD || !VALUE_FIELD_NAME.equals(this.getFieldName(specificField = (SpecificFieldNode)mappingFieldNode)) || SyntaxKind.LIST_CONSTRUCTOR != (valueExpr = (ExpressionNode)specificField.valueExpr().orElse(null)).kind() || !(valueExpr instanceof ListConstructorExpressionNode)) continue;
                ListConstructorExpressionNode listConstructorExprNode = (ListConstructorExpressionNode)valueExpr;
                ArrayList groupList = new ArrayList();
                listConstructorExprNode.expressions().forEach(expression -> groupList.add(this.getStringValue((Node)expression)));
                if (isBeforeGroups) {
                    suite.addBeforeGroupsFunction(functionName, groupList);
                    continue;
                }
                suite.addAfterGroupFunction(functionName, groupList, this.isAlwaysRunValue(annotationNode));
            }
        }
    }

    private void processTestAnnotation(AnnotationNode annotationNode, String functionName, TestSuite suite) {
        Optional mappingNodes;
        Test test = new Test();
        test.setTestName(functionName);
        AtomicBoolean shouldSkip = new AtomicBoolean();
        AtomicBoolean groupsFound = new AtomicBoolean();
        List<String> groups = this.registry.getGroups();
        boolean shouldIncludeGroups = this.registry.shouldIncludeGroups();
        if (annotationNode != null && !annotationNode.annotValue().isEmpty() && !(mappingNodes = annotationNode.annotValue()).isEmpty()) {
            for (MappingFieldNode mappingFieldNode : ((MappingConstructorExpressionNode)mappingNodes.get()).fields()) {
                ListConstructorExpressionNode listConstructorExprNode;
                String literalText;
                if (mappingFieldNode.kind() != SyntaxKind.SPECIFIC_FIELD) continue;
                SpecificFieldNode specificField = (SpecificFieldNode)mappingFieldNode;
                String fieldName = this.getFieldName(specificField);
                ExpressionNode valueExpr = specificField.valueExpr().orElse(null);
                if (valueExpr == null) continue;
                if (TEST_ENABLE_ANNOTATION_NAME.equals(fieldName) && SyntaxKind.BOOLEAN_LITERAL == valueExpr.kind() && (literalText = ((BasicLiteralNode)valueExpr).literalToken().text()).equals(Boolean.FALSE.toString())) {
                    shouldSkip.set(true);
                    break;
                }
                if (GROUP_ANNOTATION_NAME.equals(fieldName) && SyntaxKind.LIST_CONSTRUCTOR == valueExpr.kind() && valueExpr instanceof ListConstructorExpressionNode) {
                    listConstructorExprNode = (ListConstructorExpressionNode)valueExpr;
                    ArrayList groupList = new ArrayList();
                    listConstructorExprNode.expressions().forEach(expression -> groupList.add(this.getStringValue((Node)expression)));
                    test.setGroups(groupList);
                    suite.addTestToGroups(test);
                    if (groups != null && !groups.isEmpty()) {
                        boolean isGroupPresent = this.isGroupAvailable(groups, test.getGroups());
                        if (shouldIncludeGroups) {
                            if (!isGroupPresent) {
                                shouldSkip.set(true);
                                continue;
                            }
                        } else if (isGroupPresent) {
                            shouldSkip.set(true);
                            continue;
                        }
                        groupsFound.set(true);
                    }
                }
                if (VALUE_SET_ANNOTATION_NAME.equals(fieldName)) {
                    test.setDataProvider(this.getStringValue((Node)valueExpr));
                }
                if (BEFORE_FUNCTION.equals(fieldName)) {
                    test.setBeforeTestFunction(this.getStringValue((Node)valueExpr));
                }
                if (AFTER_FUNCTION.equals(fieldName)) {
                    test.setAfterTestFunction(this.getStringValue((Node)valueExpr));
                }
                if (!DEPENDS_ON_FUNCTIONS.equals(fieldName) || SyntaxKind.LIST_CONSTRUCTOR != valueExpr.kind() || !(valueExpr instanceof ListConstructorExpressionNode)) continue;
                listConstructorExprNode = (ListConstructorExpressionNode)valueExpr;
                ArrayList dependsOnFunctions = new ArrayList();
                listConstructorExprNode.expressions().forEach(expression -> dependsOnFunctions.add(this.getStringValue((Node)expression)));
                for (String function : dependsOnFunctions) {
                    test.addDependsOnTestFunction(function);
                }
            }
        }
        if (groups != null && !groups.isEmpty() && !groupsFound.get() && shouldIncludeGroups) {
            shouldSkip.set(true);
        }
        if (!shouldSkip.get()) {
            suite.addTests(test);
        }
    }

    private String getFieldName(SpecificFieldNode specificField) {
        Node fieldNameNode = specificField.fieldName();
        if (fieldNameNode.kind() != SyntaxKind.STRING_LITERAL) {
            return ((Token)fieldNameNode).text();
        }
        String fieldName = ((BasicLiteralNode)fieldNameNode).literalToken().text();
        return fieldName.substring(1, fieldName.length() - 1);
    }

    private String getExecutePath(Module module) {
        String executePath = "";
        if (this.isSingleFileProject(module.project())) {
            executePath = Optional.of(module.project().sourceRoot().getFileName()).get().toString();
            return FileUtils.getFileNameWithoutExtension((String)executePath);
        }
        for (DocumentId docId : module.testDocumentIds()) {
            if (!module.document(docId).name().startsWith("tests/test_execute-generated_")) continue;
            executePath = module.document(docId).name().replace("/", ".");
            return FileUtils.getFileNameWithoutExtension((String)executePath);
        }
        return executePath;
    }

    private boolean areTestsDelegated(Module module) {
        return module.project().buildOptions().cloud().equals("docker");
    }
}

