/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.testerina.natives;

import io.ballerina.runtime.api.types.FunctionType;
import io.ballerina.runtime.api.types.Parameter;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BFunctionPointer;

public final class CommonUtils {
    private CommonUtils() {
    }

    public static BDecimal currentTimeInMillis() {
        return BDecimal.valueOf((long)System.currentTimeMillis());
    }

    public static Object isFunctionParamConcurrencySafe(BFunctionPointer func) {
        Parameter[] functionParameters;
        FunctionType functionType = (FunctionType)func.getType();
        for (Parameter functionParameter : functionParameters = functionType.getParameters()) {
            Type parameterType = functionParameter.type;
            if (CommonUtils.isSubTypeOfReadOnly(parameterType)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSubTypeOfReadOnly(Type type) {
        if (type.isReadOnly()) {
            return true;
        }
        if (!(type instanceof UnionType)) {
            return false;
        }
        UnionType unionType = (UnionType)type;
        for (Type memberType : unionType.getMemberTypes()) {
            if (CommonUtils.isSubTypeOfReadOnly(memberType)) continue;
            return false;
        }
        return true;
    }
}

