/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.sequencemodelgenerator.core;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeDescTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.tools.text.TextRange;
import java.nio.file.Path;
import java.util.Optional;

public class CommonUtil {
    private CommonUtil() {
    }

    public static String getTypeSignature(TypeSymbol typeSymbol) {
        return switch (typeSymbol.typeKind()) {
            case TypeDescKind.TYPE_REFERENCE -> {
                TypeReferenceTypeSymbol typeReferenceTypeSymbol = (TypeReferenceTypeSymbol)typeSymbol;
                String modulePrefix = CommonUtil.getModuleName((Symbol)typeReferenceTypeSymbol).map(s -> s + ":").orElse("");
                yield typeReferenceTypeSymbol.definition().getName().map(name -> modulePrefix + name).orElseGet(() -> CommonUtil.getTypeSignature(typeReferenceTypeSymbol.typeDescriptor()));
            }
            case TypeDescKind.UNION -> {
                UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)typeSymbol;
                yield unionTypeSymbol.memberTypeDescriptors().stream().map(CommonUtil::getTypeSignature).reduce((s1, s2) -> s1 + "|" + s2).orElse(unionTypeSymbol.signature());
            }
            case TypeDescKind.TYPEDESC -> {
                TypeDescTypeSymbol typeDescTypeSymbol = (TypeDescTypeSymbol)typeSymbol;
                yield typeDescTypeSymbol.typeParameter().map(CommonUtil::getTypeSignature).orElse(typeDescTypeSymbol.signature());
            }
            default -> {
                Optional<String> moduleName = typeSymbol.getModule().map(module -> module.id().modulePrefix());
                yield moduleName.map(s -> s + ":").orElse("") + typeSymbol.signature();
            }
        };
    }

    public static SyntaxTree getSyntaxTree(Project project, Path filePath) {
        DocumentId documentId = project.documentId(filePath);
        return project.currentPackage().module(documentId.moduleId()).document(documentId).syntaxTree();
    }

    public static Path getFilePath(Project project, String fileName, String moduleName) {
        Path sourceRoot = project.sourceRoot();
        Path filePath = switch (project.kind()) {
            case ProjectKind.SINGLE_FILE_PROJECT -> sourceRoot;
            case ProjectKind.BUILD_PROJECT -> {
                Path tempFilePath = Path.of(fileName, new String[0]);
                if (tempFilePath.isAbsolute()) {
                    yield tempFilePath;
                }
                Path modulePath = moduleName == null || moduleName.equals(".") ? sourceRoot : sourceRoot.resolve("modules").resolve(moduleName);
                yield modulePath.resolve(tempFilePath);
            }
            default -> throw new IllegalStateException("Unsupported project kind: " + String.valueOf(project.kind()));
        };
        return filePath.isAbsolute() ? filePath : sourceRoot.resolve(filePath);
    }

    public static NonTerminalNode getNode(SyntaxTree syntaxTree, TextRange textRange) {
        ModulePartNode modulePartNode = (ModulePartNode)syntaxTree.rootNode();
        return modulePartNode.findNode(textRange, true);
    }

    public static Optional<String> getModuleName(Symbol symbol) {
        return symbol.getModule().map(module -> module.id().modulePrefix());
    }

    public static SemanticModel getSemanticModel(Project project, Path filePath) {
        return project.currentPackage().getCompilation().getSemanticModel(project.documentId(filePath).moduleId());
    }
}

