/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.datasource.xa.session;

import com.atomikos.datasource.xa.XAResourceTransaction;
import com.atomikos.datasource.xa.XATransactionalResource;
import com.atomikos.datasource.xa.session.BranchEndedStateHandler;
import com.atomikos.datasource.xa.session.BranchSuspendedStateHandler;
import com.atomikos.datasource.xa.session.InvalidSessionHandleStateException;
import com.atomikos.datasource.xa.session.NotInBranchStateHandler;
import com.atomikos.datasource.xa.session.TransactionContextStateHandler;
import com.atomikos.datasource.xa.session.UnexpectedTransactionContextException;
import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

class BranchEnlistedStateHandler
extends TransactionContextStateHandler {
    private static final Logger LOGGER = LoggerFactory.createLogger(BranchEnlistedStateHandler.class);
    private CompositeTransaction ct;
    private XAResourceTransaction branch;

    BranchEnlistedStateHandler(XATransactionalResource resource, CompositeTransaction ct, XAResource xaResource) {
        super(resource, xaResource);
        this.ct = ct;
        this.branch = (XAResourceTransaction)resource.getResourceTransaction(ct);
        this.branch.setXAResource(xaResource);
        this.branch.resume();
    }

    public BranchEnlistedStateHandler(XATransactionalResource resource, CompositeTransaction ct, XAResource xaResource, XAResourceTransaction branch) throws InvalidSessionHandleStateException {
        super(resource, xaResource);
        this.ct = ct;
        this.branch = branch;
        branch.setXAResource(xaResource);
        try {
            branch.xaResume();
        }
        catch (XAException e2) {
            String msg = "Failed to resume branch: " + branch;
            throw new InvalidSessionHandleStateException(msg);
        }
    }

    @Override
    TransactionContextStateHandler checkEnlistBeforeUse(CompositeTransaction currentTx) throws InvalidSessionHandleStateException, UnexpectedTransactionContextException {
        if (currentTx == null || !currentTx.isSameTransaction(this.ct)) {
            String msg = "The connection/session object is already enlisted in a (different) transaction.";
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace(msg);
            }
            throw new UnexpectedTransactionContextException();
        }
        return null;
    }

    @Override
    TransactionContextStateHandler sessionClosed() {
        return new BranchEndedStateHandler(this.getXATransactionalResource(), this.branch, this.ct);
    }

    @Override
    TransactionContextStateHandler transactionTerminated(CompositeTransaction tx) {
        NotInBranchStateHandler ret = null;
        if (this.ct.isSameTransaction(tx)) {
            ret = new NotInBranchStateHandler(this.getXATransactionalResource(), this.getXAResource());
        }
        return ret;
    }

    @Override
    public TransactionContextStateHandler transactionSuspended() throws InvalidSessionHandleStateException {
        try {
            this.branch.xaSuspend();
        }
        catch (XAException e2) {
            LOGGER.logWarning("Error in suspending transaction context for transaction: " + this.ct, e2);
            String msg = "Failed to suspend branch: " + this.branch;
            throw new InvalidSessionHandleStateException(msg, e2);
        }
        return new BranchSuspendedStateHandler(this.getXATransactionalResource(), this.branch, this.ct, this.getXAResource());
    }

    @Override
    boolean isInTransaction(CompositeTransaction tx) {
        return this.ct.isSameTransaction(tx);
    }
}

