/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.imp.CommitCallback;
import com.atomikos.icatch.imp.CoordinatorImp;
import com.atomikos.icatch.imp.CoordinatorStateHandler;
import com.atomikos.icatch.imp.IndoubtStateHandler;
import com.atomikos.icatch.imp.PrepareMessage;
import com.atomikos.icatch.imp.PrepareResult;
import com.atomikos.icatch.imp.RollbackCallback;
import com.atomikos.icatch.imp.TerminatedStateHandler;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.TxState;
import com.atomikos.thread.InterruptedExceptionHelper;
import java.util.Enumeration;
import java.util.Vector;

class ActiveStateHandler
extends CoordinatorStateHandler {
    private static final Logger LOGGER = LoggerFactory.createLogger(ActiveStateHandler.class);
    private long rollbackTicks_ = 0L;
    private int globalSiblingCount_;
    private boolean wasSetToRollbackOnly = false;

    ActiveStateHandler(CoordinatorImp coordinator) {
        super(coordinator);
    }

    @Override
    protected long getRollbackTicks() {
        return this.rollbackTicks_;
    }

    @Override
    protected TxState getState() {
        return TxState.ACTIVE;
    }

    @Override
    protected void onTimeout() {
        try {
            if (this.rollbackTicks_ < this.getCoordinator().getMaxRollbackTicks()) {
                ++this.rollbackTicks_;
            } else if (this.getCoordinator().getState() == TxState.ACTIVE) {
                if (this.getCoordinator().hasActiveSiblings()) {
                    if (!this.wasSetToRollbackOnly) {
                        LOGGER.logWarning("Transaction " + this.getCoordinator().getCoordinatorId() + " has timed out and will rollback.");
                        this.getCoordinator().timedout(true);
                        this.wasSetToRollbackOnly = true;
                    }
                } else {
                    LOGGER.logWarning("Transaction " + this.getCoordinator().getCoordinatorId() + " has timed out - rolling back...");
                    this.rollbackWithAfterCompletionNotification(new RollbackCallback(){

                        @Override
                        public void doRollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
                            ActiveStateHandler.this.getCoordinator().timedout(false);
                            ActiveStateHandler.this.rollbackFromWithinCallback(false, false);
                        }
                    });
                }
            } else if (this.getCoordinator().getState().isOneOf(TxState.PREPARING, TxState.COMMITTING, TxState.ABORTING)) {
                this.removePendingOltpCoordinatorFromTransactionService();
            }
        }
        catch (Exception e2) {
            LOGGER.logDebug("Error in timeout: " + e2.getMessage() + " for transaction " + this.getCoordinator().getCoordinatorId());
        }
    }

    @Override
    protected void setGlobalSiblingCount(int count2) {
        this.globalSiblingCount_ = count2;
    }

    @Override
    protected int prepare() throws RollbackException, IllegalStateException, HeurHazardException, HeurMixedException, SysException {
        CoordinatorStateHandler nextStateHandler;
        int ret;
        boolean allReadOnly;
        block18: {
            int count2 = 0;
            PrepareResult result = null;
            allReadOnly = true;
            ret = 0;
            Vector<Participant> participants = this.getCoordinator().getParticipants();
            nextStateHandler = null;
            if (this.orphansExist()) {
                try {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.logTrace("Orphans detected: " + this.getCoordinator().getLocalSiblingCount() + " vs " + this.globalSiblingCount_ + " - forcing rollback.");
                    }
                    this.rollbackWithAfterCompletionNotification(new RollbackCallback(){

                        @Override
                        public void doRollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
                            ActiveStateHandler.this.rollbackFromWithinCallback(false, false);
                        }
                    });
                }
                catch (HeurCommitException hc) {
                    throw new HeurMixedException();
                }
                throw new RollbackException("Orphans detected.");
            }
            try {
                try {
                    this.getCoordinator().setState(TxState.PREPARING);
                }
                catch (RuntimeException error2) {
                    String msg = "Error in preparing: " + error2.getMessage() + " - rolling back instead";
                    LOGGER.logWarning(msg, error2);
                    try {
                        this.rollbackWithAfterCompletionNotification(new RollbackCallback(){

                            @Override
                            public void doRollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
                                ActiveStateHandler.this.rollbackFromWithinCallback(false, false);
                            }
                        });
                        throw new RollbackException(msg, error2);
                    }
                    catch (HeurCommitException e2) {
                        LOGGER.logError("Illegal heuristic commit during rollback before prepare:" + e2);
                        throw new HeurMixedException();
                    }
                }
                count2 = participants.size();
                result = new PrepareResult(count2);
                Enumeration<Participant> enumm = participants.elements();
                while (enumm.hasMoreElements()) {
                    Participant p = enumm.nextElement();
                    PrepareMessage pm = new PrepareMessage(p, result);
                    if (this.getCascadeList() != null && p.getURI() != null) {
                        Integer sibnum = this.getCascadeList().get(p.getURI());
                        if (sibnum != null) {
                            p.setGlobalSiblingCount(sibnum);
                        }
                        p.setCascadeList(this.getCascadeList());
                    }
                    this.getPropagator().submitPropagationMessage(pm);
                }
                result.waitForReplies();
                boolean voteOK = result.allYes();
                this.setReadOnlyTable(result.getReadOnlyTable());
                allReadOnly = result.allReadOnly();
                if (voteOK) break block18;
                int res = result.getResult();
                Exception cause2 = result.findFirstOriginalException();
                try {
                    this.rollbackWithAfterCompletionNotification(new RollbackCallback(){

                        @Override
                        public void doRollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
                            ActiveStateHandler.this.rollbackFromWithinCallback(true, false);
                        }
                    });
                }
                catch (HeurCommitException hc) {
                    throw new SysException("Unexpected heuristic: " + hc.getMessage(), hc);
                }
                String msg = "Prepare failed because one or more resources refused to commit. This transaction has been rolled back instead. The cause could be either:\n1. a transaction timeout (in which case you should see additional timeout warnings in this log file), or\n2. inability to reach the resource (in which case you should see network errors), or\n3. a resource-internal cause that we can\u2019t inspect";
                throw new RollbackException(msg, cause2);
            }
            catch (RuntimeException runerr) {
                throw new SysException("Error in prepare: " + runerr.getMessage(), runerr);
            }
            catch (InterruptedException err) {
                InterruptedExceptionHelper.handleInterruptedException(err);
                throw new SysException("Error in prepare: " + err.getMessage(), err);
            }
        }
        if (allReadOnly) {
            nextStateHandler = new TerminatedStateHandler(this);
            this.getCoordinator().setStateHandler(nextStateHandler);
            ret = 0;
            this.notifySynchronizationsAfterCompletion(TxState.COMMITTING, TxState.TERMINATED);
        } else {
            nextStateHandler = new IndoubtStateHandler(this);
            this.getCoordinator().setStateHandler(nextStateHandler);
            ret = 1;
        }
        return ret;
    }

    private boolean orphansExist() {
        return this.globalSiblingCount_ != this.getCoordinator().getLocalSiblingCount();
    }

    @Override
    protected void commit(boolean onePhase) throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
        if (!onePhase) {
            throw new IllegalStateException("Illegal state for commit: ACTIVE!");
        }
        if (this.getCoordinator().getParticipants().size() > 1) {
            int prepareResult = 1;
            this.setGlobalSiblingCount(1);
            prepareResult = this.prepare();
            if (prepareResult != 0) {
                this.commitWithAfterCompletionNotification(new CommitCallback(){

                    @Override
                    public void doCommit() throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
                        ActiveStateHandler.this.commitFromWithinCallback(false, false);
                    }
                });
            }
        } else {
            this.commitWithAfterCompletionNotification(new CommitCallback(){

                @Override
                public void doCommit() throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
                    ActiveStateHandler.this.commitFromWithinCallback(false, true);
                }
            });
        }
    }

    @Override
    protected void rollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        this.rollbackWithAfterCompletionNotification(new RollbackCallback(){

            @Override
            public void doRollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
                ActiveStateHandler.this.rollbackFromWithinCallback(false, false);
            }
        });
    }

    @Override
    protected Boolean replayCompletion(Participant participant) throws IllegalStateException {
        throw new IllegalStateException("No prepares sent yet.");
    }
}

