/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.Propagation;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.TransactionService;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.TxState;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;

public class CompositeTransactionManagerImp
implements CompositeTransactionManager,
SubTxAwareParticipant {
    private static final Logger LOGGER = LoggerFactory.createLogger(CompositeTransactionManagerImp.class);
    private Map<Thread, Stack<CompositeTransaction>> threadtotxmap_ = new HashMap<Thread, Stack<CompositeTransaction>>();
    private Map<CompositeTransaction, Thread> txtothreadmap_ = new HashMap<CompositeTransaction, Thread>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread getThread(CompositeTransaction ct) {
        Thread thread2 = null;
        Map<CompositeTransaction, Thread> map2 = this.txtothreadmap_;
        synchronized (map2) {
            thread2 = this.txtothreadmap_.get(ct);
        }
        return thread2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stack<CompositeTransaction> removeThreadMappings(Thread thread2) {
        Stack<CompositeTransaction> ret = null;
        Map<Thread, Stack<CompositeTransaction>> map2 = this.threadtotxmap_;
        synchronized (map2) {
            ret = this.threadtotxmap_.remove(thread2);
            CompositeTransaction tx = ret.peek();
            this.txtothreadmap_.remove(tx);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setThreadMappings(CompositeTransaction ct, Thread thread2) throws IllegalStateException, SysException {
        ct.addSubTxAwareParticipant(this);
        Map<Thread, Stack<CompositeTransaction>> map2 = this.threadtotxmap_;
        synchronized (map2) {
            if (TxState.ACTIVE.equals((Object)ct.getState())) {
                Stack<CompositeTransaction> txs = this.threadtotxmap_.get(thread2);
                if (txs == null) {
                    txs = new Stack();
                }
                txs.push(ct);
                this.threadtotxmap_.put(thread2, txs);
                this.txtothreadmap_.put(ct, thread2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreThreadMappings(Stack<CompositeTransaction> stack, Thread thread2) throws IllegalStateException {
        CompositeTransaction tx = stack.peek();
        tx.addSubTxAwareParticipant(this);
        Map<Thread, Stack<CompositeTransaction>> map2 = this.threadtotxmap_;
        synchronized (map2) {
            TxState state = tx.getState();
            if (state.isOneOf(TxState.ACTIVE, TxState.MARKED_ABORT)) {
                Stack<CompositeTransaction> txs = this.threadtotxmap_.get(thread2);
                if (txs != null) {
                    throw new IllegalStateException("Thread already has subtx stack");
                }
                this.threadtotxmap_.put(thread2, stack);
                this.txtothreadmap_.put(tx, thread2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompositeTransaction getCurrentTx() {
        Thread thread2 = Thread.currentThread();
        Map<Thread, Stack<CompositeTransaction>> map2 = this.threadtotxmap_;
        synchronized (map2) {
            Stack<CompositeTransaction> txs = this.threadtotxmap_.get(thread2);
            if (txs == null) {
                return null;
            }
            return txs.peek();
        }
    }

    private TransactionService getTransactionService() {
        TransactionService ret = Configuration.getTransactionService();
        if (ret == null) {
            throw new IllegalStateException("Not initialized");
        }
        return ret;
    }

    @Override
    public void committed(CompositeTransaction tx) {
        this.removeTransaction(tx);
    }

    @Override
    public void rolledback(CompositeTransaction tx) {
        this.removeTransaction(tx);
    }

    @Override
    public CompositeTransaction getCompositeTransaction() throws SysException {
        CompositeTransaction ct = null;
        ct = this.getCurrentTx();
        if (ct != null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("getCompositeTransaction()  returning instance with id " + ct.getTid());
            }
        } else if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace("getCompositeTransaction() returning NULL!");
        }
        return ct;
    }

    @Override
    public CompositeTransaction getCompositeTransaction(String tid) throws SysException {
        CompositeTransaction ret = this.getTransactionService().getCompositeTransaction(tid);
        if (ret != null) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTrace("getCompositeTransaction ( " + tid + " ) returning instance with tid " + ret.getTid());
            }
        } else if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace("getCompositeTransaction ( " + tid + " ) returning null");
        }
        return ret;
    }

    @Override
    public synchronized CompositeTransaction recreateCompositeTransaction(Propagation context) throws SysException {
        CompositeTransaction ct = null;
        ct = this.getCurrentTx();
        if (ct != null) {
            LOGGER.logWarning("Recreating a transaction with existing transaction: " + ct.getTid());
        }
        ct = this.getTransactionService().recreateCompositeTransaction(context);
        Thread t = Thread.currentThread();
        this.setThreadMappings(ct, t);
        return ct;
    }

    @Override
    public CompositeTransaction suspend() throws SysException {
        CompositeTransaction ret = this.getCurrentTx();
        if (ret != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("suspend() for transaction " + ret.getTid());
            }
            Thread thread2 = Thread.currentThread();
            this.removeThreadMappings(thread2);
            this.suspendInTransactionService(ret);
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("suspend() called without a transaction context");
        }
        return ret;
    }

    private void suspendInTransactionService(CompositeTransaction ret) {
        try {
            this.getTransactionService().transactionSuspended(ret);
        }
        catch (Exception e2) {
            LOGGER.logWarning("Unexpected error on suspend - ignoring...", e2);
        }
    }

    private void resumeInTransactionService(CompositeTransaction ret) {
        try {
            this.getTransactionService().transactionResumed(ret);
        }
        catch (Exception e2) {
            LOGGER.logWarning("Unexpected error on resume - ignoring...", e2);
        }
    }

    @Override
    public void resume(CompositeTransaction ct) throws IllegalStateException, SysException {
        Stack<CompositeTransaction> ancestors = new Stack<CompositeTransaction>();
        Stack<CompositeTransaction> tmp = new Stack<CompositeTransaction>();
        Stack lineage = (Stack)ct.getLineage().clone();
        boolean done = false;
        while (!lineage.isEmpty() && !done) {
            CompositeTransaction parent = (CompositeTransaction)lineage.pop();
            if (!parent.isLocal()) {
                done = true;
                continue;
            }
            tmp.push(parent);
        }
        while (!tmp.isEmpty()) {
            ancestors.push((CompositeTransaction)tmp.pop());
        }
        ancestors.push(ct);
        Thread thread2 = Thread.currentThread();
        this.restoreThreadMappings(ancestors, thread2);
        this.resumeInTransactionService(ct);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logDebug("resume ( " + ct + " ) done for transaction " + ct.getTid());
        }
    }

    public void shutdown(boolean force) throws SysException, IllegalStateException {
        this.getTransactionService().shutdown(force);
    }

    protected void startlistening(CompositeTransaction transaction2) throws SysException {
        transaction2.addSubTxAwareParticipant(this);
    }

    private void removeTransaction(CompositeTransaction ct) {
        if (ct == null) {
            return;
        }
        Thread thread2 = this.getThread(ct);
        if (thread2 == null) {
            return;
        }
        Stack<CompositeTransaction> mappings = this.removeThreadMappings(thread2);
        if (mappings != null && !mappings.empty()) {
            mappings.pop();
            if (!mappings.empty()) {
                this.restoreThreadMappings(mappings, thread2);
            }
        }
    }

    @Override
    public CompositeTransaction createCompositeTransaction(long timeout) throws SysException {
        CompositeTransaction ct = null;
        CompositeTransaction ret = null;
        ct = this.getCurrentTx();
        if (ct == null) {
            ret = this.getTransactionService().createCompositeTransaction(timeout);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("createCompositeTransaction ( " + timeout + " ): created new ROOT transaction with id " + ret.getTid());
            }
        } else {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug("createCompositeTransaction ( " + timeout + " )");
            }
            ret = ct.createSubTransaction();
        }
        Thread thread2 = Thread.currentThread();
        this.setThreadMappings(ret, thread2);
        return ret;
    }
}

