/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.imp.CoordinatorImp;
import com.atomikos.icatch.imp.CoordinatorStateHandler;
import com.atomikos.icatch.imp.TerminatedStateHandler;
import com.atomikos.recovery.TxState;

class HeurCommittedStateHandler
extends CoordinatorStateHandler {
    private long timeoutTicks = 0L;
    private long maxTimeoutTicks = Configuration.getConfigProperties().getMaxTimeout() / CoordinatorImp.DEFAULT_MILLIS_BETWEEN_TIMER_WAKEUPS + 1L;

    HeurCommittedStateHandler(CoordinatorStateHandler previous) {
        super(previous);
    }

    @Override
    protected TxState getState() {
        return TxState.HEUR_COMMITTED;
    }

    @Override
    protected void onTimeout() {
        if (this.timeoutTicks < this.maxTimeoutTicks) {
            ++this.timeoutTicks;
        } else {
            this.removePendingOltpCoordinatorFromTransactionService();
        }
    }

    @Override
    protected void setGlobalSiblingCount(int count2) {
    }

    @Override
    protected int prepare() throws RollbackException, IllegalStateException, HeurHazardException, HeurMixedException, SysException {
        throw new HeurHazardException();
    }

    @Override
    protected void commit(boolean onePhase) throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
        TerminatedStateHandler termStateHandler = new TerminatedStateHandler(this);
        this.getCoordinator().setStateHandler(termStateHandler);
    }

    @Override
    protected void rollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        throw new HeurCommitException();
    }
}

