/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.icatch.imp.ActiveStateHandler;
import com.atomikos.icatch.imp.CommitCallback;
import com.atomikos.icatch.imp.CoordinatorStateHandler;
import com.atomikos.icatch.imp.RollbackCallback;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.TxState;

class IndoubtStateHandler
extends CoordinatorStateHandler {
    private static final Logger LOGGER = LoggerFactory.createLogger(IndoubtStateHandler.class);
    private long timeoutTicks = 0L;

    IndoubtStateHandler(ActiveStateHandler previous) {
        super(previous);
        this.timeoutTicks = previous.getRollbackTicks();
    }

    @Override
    protected TxState getState() {
        return TxState.IN_DOUBT;
    }

    @Override
    protected void onTimeout() {
        if (!this.getCoordinator().getState().equals((Object)this.getState())) {
            return;
        }
        if (this.timeoutTicks < this.getCoordinator().getMaxIndoubtTicks()) {
            ++this.timeoutTicks;
        } else {
            try {
                if (this.getCoordinator().requiresHeuristics()) {
                    LOGGER.logWarning("Transaction " + this.getCoordinator().getCoordinatorId() + " has timed out - performing heuristic rollback. See https://www.atomikos.com/Documentation/HeuristicExceptions for more details or try https://www.atomikos.com/Main/ExtremeTransactions for self-healing recovery.");
                    this.rollbackWithAfterCompletionNotification(new RollbackCallback(){

                        @Override
                        public void doRollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
                            IndoubtStateHandler.this.rollbackFromWithinCallback(true, true);
                        }
                    });
                } else {
                    this.removePendingOltpCoordinatorFromTransactionService();
                }
            }
            catch (Exception e2) {
                LOGGER.logWarning("Error in timeout of INDOUBT state: " + e2.getMessage());
            }
        }
    }

    @Override
    protected void setGlobalSiblingCount(int count2) {
    }

    @Override
    protected int prepare() throws RollbackException, IllegalStateException, HeurHazardException, HeurMixedException, SysException {
        return 1;
    }

    @Override
    protected void commit(boolean onePhase) throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
        this.commitWithAfterCompletionNotification(new CommitCallback(){

            @Override
            public void doCommit() throws HeurRollbackException, HeurMixedException, HeurHazardException, IllegalStateException, RollbackException, SysException {
                IndoubtStateHandler.this.commitFromWithinCallback(false, false);
            }
        });
    }

    @Override
    protected void rollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
        this.rollbackWithAfterCompletionNotification(new RollbackCallback(){

            @Override
            public void doRollback() throws HeurCommitException, HeurMixedException, SysException, HeurHazardException, IllegalStateException {
                IndoubtStateHandler.this.rollbackFromWithinCallback(true, false);
            }
        });
    }
}

