/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.icatch.Participant;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.imp.PropagationException;
import com.atomikos.icatch.imp.Reply;
import com.atomikos.icatch.imp.Result;

abstract class PropagationMessage {
    private static final int MAX_RETRIES_ON_COMM_FAILURE = Configuration.getConfigProperties().getOltpMaxRetries();
    private Participant participant_;
    private int retrycount_ = 0;
    private Result result_ = null;

    public PropagationMessage(Participant participant, Result result) {
        this.participant_ = participant;
        this.result_ = result;
    }

    public Participant getParticipant() {
        return this.participant_;
    }

    protected abstract Object send() throws PropagationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean submit() {
        boolean failed = false;
        boolean transienterr = false;
        Exception exception = null;
        Object result = null;
        boolean retried = false;
        try {
            result = this.send();
        }
        catch (PropagationException e2) {
            failed = true;
            transienterr = e2.isTransient();
            exception = e2.getDetail();
        }
        finally {
            if (failed && transienterr && this.retrycount_ < MAX_RETRIES_ON_COMM_FAILURE) {
                retried = true;
                ++this.retrycount_;
            }
            if (this.result_ != null) {
                this.result_.addReply(new Reply(result, exception, this.getParticipant(), retried));
            }
        }
        return retried;
    }
}

