/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.imp;

import com.atomikos.datasource.RecoverableResource;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.event.transaction.TransactionHeuristicEvent;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.publish.EventPublisher;
import com.atomikos.recovery.PendingTransactionRecord;
import com.atomikos.recovery.RecoveryLog;
import com.atomikos.recovery.TxState;
import com.atomikos.thread.TaskManager;
import com.atomikos.timing.AlarmTimer;
import com.atomikos.timing.AlarmTimerListener;
import com.atomikos.timing.PooledAlarmTimer;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class RecoveryDomainService {
    private static final Logger LOGGER = LoggerFactory.createLogger(RecoveryDomainService.class);
    private RecoveryLog recoveryLog;
    private long maxTimeout;
    private PooledAlarmTimer recoveryTimer;
    private String recoveryDomainName;

    public RecoveryDomainService(RecoveryLog recoveryLog) {
        this.recoveryLog = recoveryLog;
    }

    public void init() {
        long recoveryDelay = Configuration.getConfigProperties().getRecoveryDelay();
        this.setMaxTimeout(Configuration.getConfigProperties().getMaxTimeout());
        this.recoveryDomainName = Configuration.getConfigProperties().getTmUniqueName();
        this.recoveryTimer = new PooledAlarmTimer(recoveryDelay);
        this.recoveryTimer.addAlarmTimerListener(new AlarmTimerListener(){

            @Override
            public void alarm(AlarmTimer timer) {
                RecoveryDomainService.this.performRecovery();
            }
        });
        TaskManager.SINGLETON.executeTask(this.recoveryTimer);
    }

    public void setMaxTimeout(long maxTimeout) {
        this.maxTimeout = maxTimeout;
    }

    protected synchronized void performRecovery() {
        if (this.recoveryLog.isActive()) {
            try {
                boolean allOk = true;
                long startOfRecovery = System.currentTimeMillis();
                Set<RecoverableResource> resourcesToRecover = this.getResourcesForRecovery();
                Collection<PendingTransactionRecord> indoubtCoordinators = this.recoveryLog.getIndoubtTransactionRecords();
                Collection<PendingTransactionRecord> foreignIndoubtCoordinators = this.extractForeignRecords(indoubtCoordinators);
                Collection<PendingTransactionRecord> foreignCoordinatorsForHeuristicAbort = this.extractForeignIndoubtCoordinatorsForHeuristicAbort(foreignIndoubtCoordinators, startOfRecovery);
                Collection<PendingTransactionRecord> expiredCommittingCoordinators = this.recoveryLog.getExpiredPendingCommittingTransactionRecordsAt(startOfRecovery);
                for (RecoverableResource recoverableResource : resourcesToRecover) {
                    try {
                        allOk = allOk && recoverableResource.recover(startOfRecovery, expiredCommittingCoordinators, foreignIndoubtCoordinators);
                    }
                    catch (Throwable e2) {
                        allOk = false;
                        LOGGER.logError(e2.getMessage(), e2);
                    }
                }
                HashSet<PendingTransactionRecord> recordsToDelete = new HashSet<PendingTransactionRecord>();
                if (allOk) {
                    recordsToDelete.addAll(expiredCommittingCoordinators);
                    Collection<PendingTransactionRecord> expiredNativeIndoubtCoordinators = this.extractNativeIndoubtCoordinatorsExpiredSince(startOfRecovery - this.maxTimeout, indoubtCoordinators);
                    recordsToDelete.addAll(expiredNativeIndoubtCoordinators);
                }
                recordsToDelete.addAll(foreignCoordinatorsForHeuristicAbort);
                this.recoveryLog.forgetTransactionRecords(recordsToDelete);
            }
            catch (Throwable e3) {
                LOGGER.logError(e3.getMessage(), e3);
            }
        }
    }

    private Collection<PendingTransactionRecord> extractNativeIndoubtCoordinatorsExpiredSince(long momentInThePast, Collection<PendingTransactionRecord> collection2) {
        return PendingTransactionRecord.collectLineages(r2 -> r2.isLocalRoot(this.recoveryDomainName) && !r2.isForeignInDomain(this.recoveryDomainName) && r2.expires < momentInThePast && r2.state == TxState.IN_DOUBT, collection2);
    }

    private Collection<PendingTransactionRecord> extractForeignRecords(Collection<PendingTransactionRecord> collection2) {
        return PendingTransactionRecord.collectLineages(r2 -> r2.isForeignInDomain(this.recoveryDomainName), collection2);
    }

    private Collection<PendingTransactionRecord> extractForeignIndoubtCoordinatorsForHeuristicAbort(Collection<PendingTransactionRecord> foreignIndoubtCoordinators, long startOfRecovery) {
        HashSet<PendingTransactionRecord> ret = new HashSet<PendingTransactionRecord>();
        for (PendingTransactionRecord record : foreignIndoubtCoordinators) {
            if (record.expires + this.maxTimeout < startOfRecovery) {
                if (record.allowsHeuristicTermination(this.recoveryDomainName)) {
                    ret.add(record);
                } else {
                    TransactionHeuristicEvent event = new TransactionHeuristicEvent(record.id, record.superiorId, TxState.IN_DOUBT);
                    EventPublisher.INSTANCE.publish(event);
                }
            }
            for (PendingTransactionRecord entry : ret) {
                foreignIndoubtCoordinators.remove(entry);
                PendingTransactionRecord.removeAllDescendants(entry, foreignIndoubtCoordinators);
                TransactionHeuristicEvent event = new TransactionHeuristicEvent(record.id, record.superiorId, TxState.HEUR_ABORTED);
                EventPublisher.INSTANCE.publish(event);
            }
        }
        return ret;
    }

    private Set<RecoverableResource> getResourcesForRecovery() {
        Collection<RecoverableResource> resources = null;
        resources = Configuration.getResources();
        return this.filterDuplicates(resources);
    }

    private Set<RecoverableResource> filterDuplicates(Collection<RecoverableResource> resources) {
        return new HashSet<RecoverableResource>(resources);
    }

    public void stop() {
        if (this.recoveryTimer != null) {
            this.recoveryTimer.stopTimer();
            this.recoveryTimer = null;
        }
    }

    public synchronized boolean hasMoreToRecover() {
        boolean ret = false;
        if (!this.recoveryLog.isActive()) {
            return false;
        }
        for (RecoverableResource res : this.getResourcesForRecovery()) {
            if (!res.hasMoreToRecover()) continue;
            return true;
        }
        return ret;
    }
}

