/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.icatch.jta.template;

import com.atomikos.icatch.jta.UserTransactionManager;
import com.atomikos.icatch.jta.template.MandatoryTemplate;
import com.atomikos.icatch.jta.template.NestedTemplate;
import com.atomikos.icatch.jta.template.NeverTemplate;
import com.atomikos.icatch.jta.template.NotSupportedTemplate;
import com.atomikos.icatch.jta.template.RequiredTemplate;
import com.atomikos.icatch.jta.template.RequiresNewTemplate;
import com.atomikos.icatch.jta.template.SupportsTemplate;
import java.util.concurrent.Callable;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;

public class TransactionTemplate {
    private int timeout;
    protected TransactionManager utm;
    private boolean newTransactionStartedHere;
    private Transaction existingTransaction;

    public TransactionTemplate() {
        this(new UserTransactionManager(), 0);
    }

    TransactionTemplate(TransactionManager utm, int timeout) {
        this.timeout = timeout;
        this.utm = utm;
    }

    public TransactionTemplate withTimeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public TransactionTemplate required() {
        return new RequiredTemplate(this.utm, this.timeout);
    }

    public TransactionTemplate nested() {
        return new NestedTemplate(this.utm, this.timeout);
    }

    protected void beginTransaction() throws Exception {
        this.utm.setTransactionTimeout(this.timeout);
        this.utm.begin();
        this.newTransactionStartedHere = true;
    }

    protected void commitTransactionIfStartedHere() throws Exception {
        if (this.newTransactionStartedHere) {
            this.utm.commit();
        }
    }

    protected void forceRollback(Throwable e2) throws Exception {
        if (this.newTransactionStartedHere) {
            this.utm.rollback();
        } else {
            this.utm.setRollbackOnly();
        }
    }

    protected void beginTransactionIfNoneExists() throws Exception {
        if (this.utm.getTransaction() == null) {
            this.beginTransaction();
        } else {
            this.newTransactionStartedHere = false;
        }
    }

    protected void resumeExistingTransaction() throws Exception {
        if (this.existingTransaction != null) {
            this.utm.resume(this.existingTransaction);
        }
    }

    protected void suspendExistingTransaction() throws Exception {
        this.existingTransaction = this.utm.suspend();
    }

    public <T> T execute(Callable<T> work) throws Exception {
        return new RequiredTemplate(this.utm, this.timeout).execute(work);
    }

    public TransactionTemplate requiresNew() {
        return new RequiresNewTemplate(this.utm, this.timeout);
    }

    public TransactionTemplate mandatory() {
        return new MandatoryTemplate(this.utm, this.timeout);
    }

    public TransactionTemplate never() {
        return new NeverTemplate(this.utm, this.timeout);
    }

    public TransactionTemplate supports() {
        return new SupportsTemplate(this.utm, this.timeout);
    }

    public TransactionTemplate notSupported() {
        return new NotSupportedTemplate(this.utm, this.timeout);
    }
}

