/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc;

import com.atomikos.beans.PropertyUtils;
import com.atomikos.datasource.RecoverableResource;
import com.atomikos.datasource.pool.ConnectionFactory;
import com.atomikos.datasource.pool.ConnectionPoolProperties;
import com.atomikos.datasource.pool.CreateConnectionException;
import com.atomikos.datasource.pool.XPooledConnection;
import com.atomikos.datasource.xa.jdbc.JdbcTransactionalResource;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.jdbc.internal.AbstractDataSourceBean;
import com.atomikos.jdbc.internal.AtomikosSQLException;
import com.atomikos.jdbc.internal.AtomikosXAPooledConnection;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.ClassLoadingHelper;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class AtomikosDataSourceBean
extends AbstractDataSourceBean {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosDataSourceBean.class);
    private static final long serialVersionUID = 1L;
    private Properties xaProperties = new Properties();
    private String xaDataSourceClassName;
    private transient XADataSource xaDataSource;
    private boolean localTransactionMode = true;

    public Properties getXaProperties() {
        return this.xaProperties;
    }

    public void setXaProperties(Properties xaProperties) {
        this.xaProperties = xaProperties;
    }

    public String getXaDataSourceClassName() {
        return this.xaDataSourceClassName;
    }

    public void setXaDataSourceClassName(String xaDataSourceClassName) {
        this.xaDataSourceClassName = xaDataSourceClassName;
    }

    public XADataSource getXaDataSource() {
        return this.xaDataSource;
    }

    public void setXaDataSource(XADataSource xaDataSource) {
        this.xaDataSource = xaDataSource;
    }

    @Override
    public boolean getLocalTransactionMode() {
        return this.localTransactionMode;
    }

    public void setLocalTransactionMode(boolean localTransactionMode) {
        this.localTransactionMode = localTransactionMode;
    }

    @Override
    protected ConnectionFactory<Connection> doInit() throws Exception {
        if (this.xaDataSource == null) {
            if (this.xaDataSourceClassName == null) {
                this.throwAtomikosSQLException("Property 'xaDataSourceClassName' cannot be null");
            }
            if (this.xaProperties == null) {
                this.throwAtomikosSQLException("Property 'xaProperties' cannot be null");
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.logInfo(this + ": initializing with [ xaDataSourceClassName=" + this.xaDataSourceClassName + ", uniqueResourceName=" + this.getUniqueResourceName() + ", maxPoolSize=" + this.getMaxPoolSize() + ", minPoolSize=" + this.getMinPoolSize() + ", borrowConnectionTimeout=" + this.getBorrowConnectionTimeout() + ", maxIdleTime=" + this.getMaxIdleTime() + ", reapTimeout=" + this.getReapTimeout() + ", maintenanceInterval=" + this.getMaintenanceInterval() + ", testQuery=" + this.getTestQuery() + ", xaProperties=" + PropertyUtils.toString(this.xaProperties) + ", loginTimeout=" + this.getLoginTimeout() + ", maxLifetime=" + this.getMaxLifetime() + ", localTransactionMode=" + this.getLocalTransactionMode() + "]");
        }
        if (this.xaDataSource == null) {
            try {
                Class xadsClass = ClassLoadingHelper.loadClass(this.getXaDataSourceClassName());
                this.xaDataSource = (XADataSource)xadsClass.newInstance();
            }
            catch (ClassNotFoundException nf) {
                AtomikosSQLException.throwAtomikosSQLException("The class '" + this.getXaDataSourceClassName() + "' specified by property 'xaDataSourceClassName' could not be found in the classpath. Please make sure the spelling is correct, and that the required jar(s) are in the classpath.", nf);
            }
            catch (ClassCastException cce) {
                AtomikosSQLException.throwAtomikosSQLException("The class '" + this.getXaDataSourceClassName() + "' specified by property 'xaDataSourceClassName' does not implement the required interface javax.jdbc.XADataSource. Please make sure the spelling is correct, and check your JDBC driver vendor's documentation.");
            }
            this.xaDataSource.setLoginTimeout(this.getLoginTimeout());
            this.xaDataSource.setLogWriter(this.getLogWriter());
            PropertyUtils.setProperties(this.xaDataSource, this.xaProperties);
        }
        JdbcTransactionalResource tr = new JdbcTransactionalResource(this.getUniqueResourceName(), this.xaDataSource);
        AtomikosXAConnectionFactory cf = new AtomikosXAConnectionFactory(this.xaDataSource, tr, this);
        Configuration.addResource(tr);
        return cf;
    }

    @Override
    protected void doClose() {
        RecoverableResource res = Configuration.getResource(this.getUniqueResourceName());
        if (res != null) {
            Configuration.removeResource(this.getUniqueResourceName());
            res.close();
        }
    }

    @Override
    protected boolean isAssignableFromWrappedVendorClass(Class<?> iface) {
        boolean ret = false;
        if (this.xaDataSource != null) {
            ret = iface.isAssignableFrom(this.xaDataSource.getClass());
        }
        return ret;
    }

    @Override
    protected Object unwrapVendorInstance() {
        return this.xaDataSource;
    }

    @Override
    public boolean getIgnoreJtaTransactions() {
        return false;
    }

    private static class AtomikosXAConnectionFactory
    implements ConnectionFactory<Connection> {
        private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosXAConnectionFactory.class);
        private final JdbcTransactionalResource jdbcTransactionalResource;
        private final XADataSource xaDataSource;
        private final ConnectionPoolProperties props;

        private AtomikosXAConnectionFactory(XADataSource xaDataSource, JdbcTransactionalResource jdbcTransactionalResource, ConnectionPoolProperties props) {
            this.xaDataSource = xaDataSource;
            this.jdbcTransactionalResource = jdbcTransactionalResource;
            this.props = props;
        }

        @Override
        public XPooledConnection<Connection> createPooledConnection() throws CreateConnectionException {
            try {
                XAConnection xaConnection = this.xaDataSource.getXAConnection();
                return new AtomikosXAPooledConnection(xaConnection, this.jdbcTransactionalResource, this.props);
            }
            catch (SQLException e2) {
                String msg = "XAConnectionFactory: failed to create pooled connection - DBMS down or unreachable?";
                LOGGER.logWarning(msg, e2);
                throw new CreateConnectionException(msg, e2);
            }
        }
    }
}

