/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.internal;

import com.atomikos.jdbc.internal.AbstractJdbcConnectionProxy;
import com.atomikos.jdbc.internal.AtomikosSQLException;
import com.atomikos.util.DynamicProxySupport;
import com.atomikos.util.Proxied;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class AtomikosJdbcStatementProxy<StmtInterface extends Statement>
extends DynamicProxySupport<StmtInterface> {
    private final AbstractJdbcConnectionProxy connection;

    public AtomikosJdbcStatementProxy(AbstractJdbcConnectionProxy connectionProxy, StmtInterface delegate) {
        super(delegate);
        this.connection = connectionProxy;
    }

    @Override
    protected void throwInvocationAfterClose(String method) throws Exception {
        String msg = "Statement was already closed - calling " + method + " is no longer allowed!";
        AtomikosSQLException.throwAtomikosSQLException(msg);
    }

    @Proxied
    public void close() throws SQLException {
        try {
            ((Statement)this.delegate).close();
        }
        finally {
            this.connection.removeStatement((Statement)this.delegate);
        }
    }

    @Override
    protected void handleInvocationException(Throwable e2) throws Throwable {
        throw e2;
    }

    public String toString() {
        return "atomikosJdbcStatementProxy for vendor instance " + this.delegate;
    }

    @Override
    protected Class<StmtInterface> getRequiredInterfaceType() {
        if (this.delegate instanceof PreparedStatement) {
            return PreparedStatement.class;
        }
        if (this.delegate instanceof CallableStatement) {
            return CallableStatement.class;
        }
        return Statement.class;
    }
}

