/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.internal;

import com.atomikos.icatch.HeurCommitException;
import com.atomikos.icatch.HeurHazardException;
import com.atomikos.icatch.HeurMixedException;
import com.atomikos.icatch.HeurRollbackException;
import com.atomikos.icatch.Participant;
import com.atomikos.icatch.RollbackException;
import com.atomikos.icatch.SysException;
import com.atomikos.jdbc.AtomikosNonXADataSourceBean;
import com.atomikos.jdbc.internal.NonXaConnectionProxy;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import java.util.Map;

class AtomikosNonXAParticipant
implements Participant {
    private static final Logger LOGGER = LoggerFactory.createLogger(AtomikosNonXAParticipant.class);
    private boolean readOnly;
    private String name;
    private NonXaConnectionProxy connection;

    AtomikosNonXAParticipant(NonXaConnectionProxy connection, String name) {
        this.connection = connection;
        this.name = name;
    }

    @Override
    public void setCascadeList(Map<String, Integer> allParticipants) throws SysException {
    }

    @Override
    public void setGlobalSiblingCount(int count2) {
    }

    @Override
    public int prepare() throws RollbackException, HeurHazardException, HeurMixedException, SysException {
        if (!this.readOnly) {
            String msg = this.toString();
            LOGGER.logWarning(msg);
            throw new RollbackException(msg);
        }
        int ret = 1;
        return ret;
    }

    @Override
    public void commit(boolean onePhase) throws HeurRollbackException, HeurHazardException, HeurMixedException, RollbackException, SysException {
        try {
            this.connection.transactionTerminated(true);
        }
        catch (Exception e2) {
            LOGGER.logError("Error in non-XA commit", e2);
            throw new HeurMixedException();
        }
    }

    @Override
    public void rollback() throws HeurCommitException, HeurMixedException, HeurHazardException, SysException {
        try {
            this.connection.transactionTerminated(false);
        }
        catch (Exception e2) {
            LOGGER.logError("Error in non-XA rollback", e2);
            throw new HeurMixedException();
        }
    }

    @Override
    public void forget() {
    }

    @Override
    public String getURI() {
        return null;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String toString() {
        return AtomikosNonXADataSourceBean.class.getName() + " '" + this.name + "' [NB: this resource does not support two-phase commit unless configured as readOnly]";
    }

    @Override
    public String getResourceName() {
        return this.name;
    }

    public boolean equals(Object o) {
        boolean ret = false;
        if (o instanceof AtomikosNonXAParticipant) {
            AtomikosNonXAParticipant other = (AtomikosNonXAParticipant)o;
            ret = this.connection == other.connection;
        }
        return ret;
    }

    public int hashCode() {
        return this.connection.hashCode();
    }
}

