/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.jdbc.internal;

import com.atomikos.icatch.CompositeTransaction;
import com.atomikos.icatch.CompositeTransactionManager;
import com.atomikos.icatch.SubTxAwareParticipant;
import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.jta.TransactionManagerImp;
import com.atomikos.jdbc.internal.AbstractJdbcConnectionProxy;
import com.atomikos.jdbc.internal.AtomikosNonXAParticipant;
import com.atomikos.jdbc.internal.AtomikosNonXAPooledConnection;
import com.atomikos.jdbc.internal.AtomikosSQLException;
import com.atomikos.jdbc.internal.JdbcNonXAConnectionHandleState;
import com.atomikos.jdbc.internal.NonXaConnectionProxy;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.util.Proxied;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.util.Stack;

public class JtaAwareThreadLocalConnection
extends AbstractJdbcConnectionProxy
implements NonXaConnectionProxy {
    private static final Logger LOGGER = LoggerFactory.createLogger(JtaAwareThreadLocalConnection.class);
    private int useCount = 0;
    private boolean stale;
    private final AtomikosNonXAPooledConnection pooledConnection;
    private boolean originalAutoCommitState;
    private final String resourceName;
    private final JdbcNonXAConnectionHandleState state;

    public JtaAwareThreadLocalConnection(AtomikosNonXAPooledConnection pooledConnection, String resourceName) {
        super(pooledConnection.getConnection());
        this.pooledConnection = pooledConnection;
        this.resourceName = resourceName;
        this.state = new JdbcNonXAConnectionHandleState(pooledConnection.getReadOnly());
    }

    @Override
    protected void updateTransactionContext() throws SQLException {
        CompositeTransactionManager ctm = Configuration.getCompositeTransactionManager();
        if (ctm == null) {
            return;
        }
        CompositeTransaction ct = ctm.getCompositeTransaction();
        if (ct != null && TransactionManagerImp.isJtaTransaction(ct)) {
            try {
                this.state.notifyBeforeUse(ct);
            }
            catch (JdbcNonXAConnectionHandleState.ParticipantRegistrationRequiredException e2) {
                this.registerAsParticipantFor(ct);
            }
            catch (JdbcNonXAConnectionHandleState.ReadOnlyParticipantRegistrationRequiredException e3) {
                this.registerAsReadOnlyParticipantFor(ct);
            }
            catch (JdbcNonXAConnectionHandleState.SubTxAwareParticipantRegistrationRequiredException e4) {
                this.registerAsSubTxAwareParticipantFor(ct);
            }
            catch (JdbcNonXAConnectionHandleState.TransactionContextException e5) {
                AtomikosSQLException.throwAtomikosSQLException(e5.getMessage(), e5);
            }
        } else {
            AtomikosSQLException.throwAtomikosSQLException("A JTA transaction is required but none was found - please start one first (or set localTransactionMode=true to allow JDBC transactions)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void transactionTerminated(boolean commit) throws SQLException {
        try {
            if (commit) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug(this + ": committing on connection...");
                }
                ((Connection)this.delegate).commit();
            } else {
                this.forceCloseAllPendingStatements(false);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.logDebug(this + ": transaction aborting - pessimistically closing all pending statements to avoid autoCommit after timeout");
                    LOGGER.logDebug(this + ": rolling back on connection...");
                }
                ((Connection)this.delegate).rollback();
            }
        }
        catch (SQLException e2) {
            this.pooledConnection.setErroneous();
            String msg = "Error in commit on vendor connection";
            if (!commit) {
                msg = "Error in rollback on vendor connection";
            }
            AtomikosSQLException.throwAtomikosSQLException(msg, e2);
        }
        finally {
            this.resetForNextTransaction();
            this.markForReuseIfPossible();
        }
    }

    private void resetForNextTransaction() {
        this.state.reset();
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.logDebug(this + ": resetting autoCommit to " + this.originalAutoCommitState);
            }
            ((Connection)this.delegate).setAutoCommit(this.originalAutoCommitState);
        }
        catch (Exception ex) {
            LOGGER.logError(this + ": failed to reset original autoCommit state: " + ex.getMessage(), ex);
        }
    }

    boolean isInTransaction(CompositeTransaction ct) {
        return this.state.isEnlistedInGlobalTransaction(ct);
    }

    @Proxied
    public void close() throws SQLException {
        this.decUseCount();
    }

    public void incUseCount() {
        ++this.useCount;
    }

    private void decUseCount() {
        --this.useCount;
        this.markForReuseIfPossible();
    }

    boolean isStale() {
        return this.stale;
    }

    private void markForReuseIfPossible() {
        if (this.isAvailableForReuseByPool()) {
            LOGGER.logTrace(this + ": detected reusability");
            this.setStale();
            this.forceCloseAllPendingStatements(false);
            this.pooledConnection.fireOnXPooledConnectionTerminated();
        } else if (LOGGER.isTraceEnabled()) {
            LOGGER.logTrace(this + ": not reusable yet");
        }
    }

    private void setStale() {
        this.stale = true;
    }

    @Override
    public boolean isAvailableForReuseByPool() {
        return this.useCount <= 0 && !this.isEnlistedInGlobalTransaction();
    }

    @Override
    protected boolean isEnlistedInGlobalTransaction() {
        return this.state.isEnlistedInGlobalTransaction();
    }

    @Override
    protected void handleInvocationException(Throwable e2) throws Throwable {
        this.pooledConnection.setErroneous();
        throw e2;
    }

    public String toString() {
        return "jtaAwareThreadLocalConnection (isAvailable = " + this.isAvailableForReuseByPool() + ")  for vendor instance " + this.delegate;
    }

    private void registerAsParticipantFor(CompositeTransaction ct) throws SQLException {
        this.originalAutoCommitState = ((Connection)this.delegate).getAutoCommit();
        ((Connection)this.delegate).setAutoCommit(false);
        AtomikosNonXAParticipant participant = new AtomikosNonXAParticipant(this, this.resourceName);
        CompositeTransaction localRoot = this.findLocalRoot(ct);
        localRoot.addParticipant(participant);
        if (localRoot != ct) {
            this.registerAsSubTxAwareParticipantFor(ct);
        }
    }

    private void registerAsReadOnlyParticipantFor(CompositeTransaction ct) throws SQLException {
        this.originalAutoCommitState = ((Connection)this.delegate).getAutoCommit();
        ((Connection)this.delegate).setAutoCommit(false);
        CompositeTransaction localRoot = this.findLocalRoot(ct);
        ReadOnlyParticipant participant = new ReadOnlyParticipant(this);
        localRoot.addSubTxAwareParticipant(participant);
    }

    private void registerAsSubTxAwareParticipantFor(CompositeTransaction ct) throws SQLException {
        boolean supportsSavepoints = false;
        try {
            supportsSavepoints = ((Connection)this.delegate).getMetaData().supportsSavepoints();
        }
        catch (Error e2) {
            LOGGER.logDebug("Failed to determine savepoint support in JDBC driver - see stacktrace for details", e2);
        }
        if (!supportsSavepoints) {
            this.state.subTransactionTerminated();
            AtomikosSQLException.throwAtomikosSQLException("You're trying to use nested transactions but the underlying JDBC driver does not support savepoints - which is required for this to work...");
        }
        SubTxParticipant participant = new SubTxParticipant(ct.getTid(), this);
        ct.addSubTxAwareParticipant(participant);
    }

    private CompositeTransaction findLocalRoot(CompositeTransaction ct) {
        CompositeTransaction ret = ct;
        Stack<CompositeTransaction> parents = ct.getLineage();
        if (parents != null) {
            Stack parentsClone = (Stack)parents.clone();
            while (!parentsClone.isEmpty()) {
                CompositeTransaction parent = (CompositeTransaction)parentsClone.pop();
                if (!parent.isLocal()) continue;
                ret = parent;
            }
        }
        return ret;
    }

    @Override
    protected Class<Connection> getRequiredInterfaceType() {
        return Connection.class;
    }

    private static class ReadOnlyParticipant
    implements SubTxAwareParticipant {
        JtaAwareThreadLocalConnection owner;

        ReadOnlyParticipant(JtaAwareThreadLocalConnection owner) {
            this.owner = owner;
        }

        @Override
        public void rolledback(CompositeTransaction transaction2) {
            try {
                this.owner.transactionTerminated(false);
            }
            catch (SQLException e2) {
                LOGGER.logWarning("Unexpected error during rollback", e2);
            }
        }

        @Override
        public void committed(CompositeTransaction transaction2) {
            try {
                this.owner.transactionTerminated(true);
            }
            catch (SQLException e2) {
                LOGGER.logWarning("Unexpected error during commit", e2);
            }
        }

        public boolean equals(Object o) {
            boolean ret = false;
            if (o instanceof ReadOnlyParticipant) {
                ReadOnlyParticipant other = (ReadOnlyParticipant)o;
                ret = this.owner == other.owner;
            }
            return ret;
        }

        public int hashCode() {
            return this.owner.hashCode();
        }
    }

    private static class SubTxParticipant
    implements SubTxAwareParticipant {
        private Savepoint savepoint;
        private JtaAwareThreadLocalConnection owner;

        SubTxParticipant(String tid, JtaAwareThreadLocalConnection owner) throws SQLException {
            this.owner = owner;
            this.savepoint = ((Connection)owner.delegate).setSavepoint(tid);
        }

        @Override
        public void committed(CompositeTransaction transaction2) {
            this.owner.state.subTransactionTerminated();
        }

        @Override
        public void rolledback(CompositeTransaction transaction2) {
            this.owner.state.subTransactionTerminated();
            try {
                ((Connection)this.owner.delegate).rollback(this.savepoint);
            }
            catch (SQLException e2) {
                LOGGER.logWarning("Failed to rollback to savepoint", e2);
                this.owner.pooledConnection.setErroneous();
            }
        }

        public boolean equals(Object o) {
            boolean ret = false;
            if (o instanceof SubTxParticipant) {
                SubTxParticipant other = (SubTxParticipant)o;
                ret = this.owner == other.owner;
            }
            return ret;
        }

        public int hashCode() {
            return this.owner.hashCode();
        }
    }
}

