/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.recovery.fs;

import com.atomikos.icatch.config.Configuration;
import com.atomikos.icatch.provider.ConfigProperties;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.LogException;
import com.atomikos.recovery.LogReadException;
import com.atomikos.recovery.LogWriteException;
import com.atomikos.recovery.PendingTransactionRecord;
import com.atomikos.recovery.TxState;
import com.atomikos.recovery.fs.InMemoryRepository;
import com.atomikos.recovery.fs.Repository;
import java.util.Collection;
import java.util.HashSet;

public class CachedRepository
implements Repository {
    private static final Logger LOGGER = LoggerFactory.createLogger(CachedRepository.class);
    private boolean corrupt = false;
    private final InMemoryRepository inMemoryCoordinatorLogEntryRepository;
    private final Repository backupCoordinatorLogEntryRepository;
    private volatile long numberOfPutsSinceLastCheckpoint = 0L;
    private long checkpointInterval;
    private long forgetOrphanedLogEntriesDelay;

    public CachedRepository(InMemoryRepository inMemoryCoordinatorLogEntryRepository, Repository backupCoordinatorLogEntryRepository) {
        this.inMemoryCoordinatorLogEntryRepository = inMemoryCoordinatorLogEntryRepository;
        this.backupCoordinatorLogEntryRepository = backupCoordinatorLogEntryRepository;
    }

    @Override
    public void init() {
        ConfigProperties configProperties = Configuration.getConfigProperties();
        this.checkpointInterval = configProperties.getCheckpointInterval();
        this.forgetOrphanedLogEntriesDelay = configProperties.getForgetOrphanedLogEntriesDelay();
        try {
            Collection<PendingTransactionRecord> coordinatorLogEntries = this.backupCoordinatorLogEntryRepository.getAllCoordinatorLogEntries();
            for (PendingTransactionRecord coordinatorLogEntry : coordinatorLogEntries) {
                this.inMemoryCoordinatorLogEntryRepository.put(coordinatorLogEntry.id, coordinatorLogEntry);
            }
            this.performCheckpoint();
        }
        catch (LogException e2) {
            LOGGER.logFatal("Corrupted log file - restart JVM", e2);
            this.corrupt = true;
        }
    }

    @Override
    public synchronized void put(String id, PendingTransactionRecord coordinatorLogEntry) throws IllegalArgumentException, LogWriteException {
        try {
            if (this.needsCheckpoint()) {
                this.performCheckpoint();
            }
            this.backupCoordinatorLogEntryRepository.put(id, coordinatorLogEntry);
            this.inMemoryCoordinatorLogEntryRepository.put(id, coordinatorLogEntry);
            ++this.numberOfPutsSinceLastCheckpoint;
        }
        catch (Exception e2) {
            this.performCheckpoint();
        }
    }

    private synchronized void performCheckpoint() throws LogWriteException {
        try {
            Collection<PendingTransactionRecord> coordinatorLogEntries = this.purgeExpiredCoordinatorLogEntriesInStateAborting();
            this.backupCoordinatorLogEntryRepository.writeCheckpoint(coordinatorLogEntries);
            this.inMemoryCoordinatorLogEntryRepository.writeCheckpoint(coordinatorLogEntries);
            this.numberOfPutsSinceLastCheckpoint = 0L;
        }
        catch (LogWriteException corrupted) {
            LOGGER.logFatal("Corrupted log file - restart JVM", corrupted);
            this.corrupt = true;
            throw corrupted;
        }
        catch (Exception corrupted) {
            LOGGER.logFatal("Corrupted log file - restart JVM", corrupted);
            this.corrupt = true;
            throw new LogWriteException(corrupted);
        }
    }

    private Collection<PendingTransactionRecord> purgeExpiredCoordinatorLogEntriesInStateAborting() {
        HashSet<PendingTransactionRecord> ret = new HashSet<PendingTransactionRecord>();
        long now = System.currentTimeMillis();
        Collection<PendingTransactionRecord> coordinatorLogEntries = this.inMemoryCoordinatorLogEntryRepository.getAllCoordinatorLogEntries();
        for (PendingTransactionRecord coordinatorLogEntry : coordinatorLogEntries) {
            if (this.canBeForgotten(now, coordinatorLogEntry)) continue;
            ret.add(coordinatorLogEntry);
        }
        return ret;
    }

    protected boolean canBeForgotten(long now, PendingTransactionRecord coordinatorLogEntry) {
        TxState entryState;
        boolean ret = false;
        if (coordinatorLogEntry.expires + this.forgetOrphanedLogEntriesDelay < now && !(entryState = coordinatorLogEntry.state).isHeuristic()) {
            LOGGER.logWarning("Purging orphaned entry from log: " + coordinatorLogEntry);
            ret = true;
        }
        return ret;
    }

    private boolean needsCheckpoint() {
        return this.numberOfPutsSinceLastCheckpoint >= this.checkpointInterval;
    }

    @Override
    public PendingTransactionRecord get(String coordinatorId) throws LogReadException {
        this.assertNotCorrupted();
        return this.inMemoryCoordinatorLogEntryRepository.get(coordinatorId);
    }

    protected void assertNotCorrupted() throws LogReadException {
        if (this.corrupt) {
            throw new LogReadException("Log corrupted - restart JVM");
        }
    }

    @Override
    public Collection<PendingTransactionRecord> findAllCommittingCoordinatorLogEntries() throws LogReadException {
        this.assertNotCorrupted();
        return this.inMemoryCoordinatorLogEntryRepository.findAllCommittingCoordinatorLogEntries();
    }

    @Override
    public void close() {
        this.backupCoordinatorLogEntryRepository.close();
        this.inMemoryCoordinatorLogEntryRepository.close();
    }

    @Override
    public Collection<PendingTransactionRecord> getAllCoordinatorLogEntries() {
        return this.inMemoryCoordinatorLogEntryRepository.getAllCoordinatorLogEntries();
    }

    @Override
    public void writeCheckpoint(Collection<PendingTransactionRecord> checkpointContent) {
        throw new UnsupportedOperationException();
    }
}

