/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.recovery.fs;

import com.atomikos.icatch.config.Configuration;
import com.atomikos.logging.Logger;
import com.atomikos.logging.LoggerFactory;
import com.atomikos.recovery.LogException;
import com.atomikos.recovery.LogReadException;
import com.atomikos.recovery.PendingTransactionRecord;
import com.atomikos.recovery.RecoveryLog;
import com.atomikos.recovery.TxState;
import com.atomikos.recovery.fs.Repository;
import java.util.Collection;

public class RecoveryLogImp
implements RecoveryLog {
    private static final Logger LOGGER = LoggerFactory.createLogger(RecoveryLogImp.class);
    private Repository repository;
    private String recoveryDomainName = Configuration.getConfigProperties().getTmUniqueName();

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    @Override
    public Collection<PendingTransactionRecord> getPendingTransactionRecords() throws LogReadException {
        return this.repository.getAllCoordinatorLogEntries();
    }

    @Override
    public void closing() {
    }

    @Override
    public Collection<PendingTransactionRecord> getExpiredPendingCommittingTransactionRecordsAt(long time) throws LogReadException {
        Collection<PendingTransactionRecord> allCoordinatorLogEntries = this.repository.findAllCommittingCoordinatorLogEntries();
        return PendingTransactionRecord.collectLineages(r2 -> r2.isLocalRoot(this.recoveryDomainName) && r2.expires < time && r2.state == TxState.COMMITTING, allCoordinatorLogEntries);
    }

    @Override
    public Collection<PendingTransactionRecord> getIndoubtTransactionRecords() throws LogReadException {
        Collection<PendingTransactionRecord> allCoordinatorLogEntries = this.repository.getAllCoordinatorLogEntries();
        return PendingTransactionRecord.collectLineages(r2 -> r2.state == TxState.IN_DOUBT, allCoordinatorLogEntries);
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void forgetTransactionRecords(Collection<PendingTransactionRecord> coordinators) {
        try {
            for (PendingTransactionRecord entry : coordinators) {
                PendingTransactionRecord terminated = entry.markAsTerminated();
                this.repository.put(terminated.id, terminated);
            }
        }
        catch (Exception e2) {
            LOGGER.logDebug("Unexpected exception - ignoring...", e2);
        }
    }

    @Override
    public void recordAsCommitting(String coordinatorId) throws LogException {
        PendingTransactionRecord entry = this.repository.get(coordinatorId);
        if (entry != null) {
            PendingTransactionRecord committing = entry.markAsCommitting();
            this.repository.put(committing.id, committing);
        } else {
            LOGGER.logWarning("Entry for coordinator " + coordinatorId + " no longer found - consider https://www.atomikos.com/Main/LogCloud for full distributed recovery among microservices");
        }
    }

    @Override
    public void forget(String coordinatorId) {
        try {
            PendingTransactionRecord rec = this.repository.get(coordinatorId);
            if (rec != null) {
                PendingTransactionRecord terminated = rec.markAsTerminated();
                this.repository.put(terminated.id, terminated);
            }
        }
        catch (Exception e2) {
            LOGGER.logDebug("Unexpected exception - ignoring...", e2);
        }
    }

    @Override
    public PendingTransactionRecord get(String coordinatorId) throws LogReadException {
        return this.repository.get(coordinatorId);
    }

    @Override
    public void closed() {
    }
}

