/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.Hashtable;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.spi.ObjectFactory;

public class SerializableObjectFactory
implements ObjectFactory {
    static Reference createReference(Serializable object, String factoryClassName) throws NamingException {
        ByteArrayOutputStream bout;
        Reference ret = null;
        BinaryRefAddr handle = null;
        try {
            bout = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bout);
            out.writeObject(object);
            out.close();
        }
        catch (IOException e2) {
            throw new NamingException(e2.getMessage());
        }
        handle = new BinaryRefAddr("com.atomikos.serializable", bout.toByteArray());
        ret = new Reference(object.getClass().getName(), handle, factoryClassName, null);
        return ret;
    }

    public static Reference createReference(Serializable object) throws NamingException {
        return SerializableObjectFactory.createReference(object, SerializableObjectFactory.class.getName());
    }

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws Exception {
        Reference ref;
        RefAddr ra;
        Object ret = null;
        if (obj instanceof Reference && (ra = (ref = (Reference)obj).get("com.atomikos.serializable")) != null) {
            byte[] bytes = (byte[])ra.getContent();
            ByteArrayInputStream bin = new ByteArrayInputStream(bytes);
            ObjectInputStream in = new ObjectInputStream(bin){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    try {
                        return super.resolveClass(desc);
                    }
                    catch (ClassNotFoundException ex) {
                        return Thread.currentThread().getContextClassLoader().loadClass(desc.getName());
                    }
                }
            };
            ret = in.readObject();
            in.close();
        }
        return ret;
    }
}

