/*
 * Decompiled with CFR 0.152.
 */
package com.atomikos.util;

public class UniqueIdMgr {
    private static final int MAX_COUNTER_WITHIN_SAME_MILLIS = 32000;
    private static final int MAX_LENGTH_OF_NUMERIC_SUFFIX = String.valueOf(Long.MAX_VALUE).length() + String.valueOf(32000).length();
    private final String commonPartOfId;
    private int lastcounter;

    public UniqueIdMgr(String server) {
        this.commonPartOfId = UniqueIdMgr.getCommonPartOfId(server);
        this.lastcounter = 0;
    }

    private String getCountWithLeadingZeroes(int number) {
        String ret = Long.toString(number);
        int max2 = Long.toString(32000L).length();
        StringBuffer zeroes = new StringBuffer();
        for (int len = ret.length(); len < max2; ++len) {
            zeroes.append("0");
        }
        ret = zeroes.append(ret).toString();
        return ret;
    }

    public String get() {
        StringBuffer buffer = new StringBuffer();
        String id = buffer.append(this.commonPartOfId).append(System.currentTimeMillis()).append(this.getCountWithLeadingZeroes(this.incrementAndGet())).toString();
        return id;
    }

    private synchronized int incrementAndGet() {
        ++this.lastcounter;
        if (this.lastcounter == 32000) {
            this.lastcounter = 0;
        }
        return this.lastcounter;
    }

    private static String getCommonPartOfId(String server) {
        StringBuffer ret = new StringBuffer(64);
        ret.append(server);
        return ret.toString();
    }

    public int getMaxIdLengthInBytes() {
        return this.commonPartOfId.getBytes().length + MAX_LENGTH_OF_NUMERIC_SUFFIX;
    }
}

