/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.shaded.msv_core.datatype.xsd;

import com.ctc.wstx.shaded.msv.xsd_util.XmlChars;

public class XmlNames {
    private XmlNames() {
    }

    public static boolean isName(String value2) {
        if (value2 == null || value2.length() == 0) {
            return false;
        }
        char c = value2.charAt(0);
        if (!XmlChars.isLetter(c) && c != '_' && c != ':') {
            return false;
        }
        for (int i = 1; i < value2.length(); ++i) {
            if (XmlChars.isNameChar(value2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isUnqualifiedName(String value2) {
        if (value2 == null || value2.length() == 0) {
            return false;
        }
        char c = value2.charAt(0);
        if (!XmlChars.isLetter(c) && c != '_') {
            return false;
        }
        for (int i = 1; i < value2.length(); ++i) {
            if (XmlChars.isNCNameChar(value2.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isQualifiedName(String value2) {
        if (value2 == null || value2.length() == 0) {
            return false;
        }
        int first2 = value2.indexOf(58);
        if (first2 <= 0) {
            return XmlNames.isUnqualifiedName(value2);
        }
        int last2 = value2.lastIndexOf(58);
        if (last2 != first2) {
            return false;
        }
        return XmlNames.isUnqualifiedName(value2.substring(0, first2)) && XmlNames.isUnqualifiedName(value2.substring(first2 + 1));
    }

    public static boolean isNmtoken(String token) {
        if (token == null || token.length() == 0) {
            return false;
        }
        int length2 = token.length();
        for (int i = 0; i < length2; ++i) {
            if (XmlChars.isNameChar(token.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNCNmtoken(String token) {
        return XmlNames.isNmtoken(token) && token.indexOf(58) < 0;
    }

    public static boolean isNCName(String token) {
        return XmlNames.isName(token) && token.indexOf(58) < 0;
    }
}

