/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.shaded.msv_core.grammar.util;

import com.ctc.wstx.shaded.msv_core.grammar.AttributeExp;
import com.ctc.wstx.shaded.msv_core.grammar.BinaryExp;
import com.ctc.wstx.shaded.msv_core.grammar.ChoiceExp;
import com.ctc.wstx.shaded.msv_core.grammar.ConcurExp;
import com.ctc.wstx.shaded.msv_core.grammar.DataExp;
import com.ctc.wstx.shaded.msv_core.grammar.ElementExp;
import com.ctc.wstx.shaded.msv_core.grammar.Expression;
import com.ctc.wstx.shaded.msv_core.grammar.ExpressionVisitor;
import com.ctc.wstx.shaded.msv_core.grammar.InterleaveExp;
import com.ctc.wstx.shaded.msv_core.grammar.ListExp;
import com.ctc.wstx.shaded.msv_core.grammar.MixedExp;
import com.ctc.wstx.shaded.msv_core.grammar.OneOrMoreExp;
import com.ctc.wstx.shaded.msv_core.grammar.OtherExp;
import com.ctc.wstx.shaded.msv_core.grammar.ReferenceContainer;
import com.ctc.wstx.shaded.msv_core.grammar.ReferenceExp;
import com.ctc.wstx.shaded.msv_core.grammar.SequenceExp;
import com.ctc.wstx.shaded.msv_core.grammar.ValueExp;
import java.util.Iterator;

public class ExpressionPrinter
implements ExpressionVisitor {
    public static final int FRAGMENT = 1;
    public static final int CONTENTMODEL = 2;
    public static final ExpressionPrinter fragmentInstance = new ExpressionPrinter(1);
    public static final ExpressionPrinter contentModelInstance = new ExpressionPrinter(2);
    public static final ExpressionPrinter smallestInstance = new ExpressionPrinter(3);
    protected final int mode;

    public static String printFragment(Expression exp2) {
        return (String)exp2.visit(fragmentInstance);
    }

    public static String printContentModel(Expression exp2) {
        return (String)exp2.visit(contentModelInstance);
    }

    public static String printSmallest(Expression exp2) {
        return (String)exp2.visit(smallestInstance);
    }

    protected ExpressionPrinter(int mode) {
        this.mode = mode;
    }

    public String printRefContainer(ReferenceContainer cont) {
        String r2 = "";
        Iterator itr = cont.iterator();
        while (itr.hasNext()) {
            ReferenceExp exp2 = (ReferenceExp)itr.next();
            r2 = r2 + exp2.name + "  : " + exp2.exp.visit(this) + "\n";
        }
        return r2;
    }

    protected static boolean isComplex(Expression exp2) {
        return exp2 instanceof BinaryExp;
    }

    protected String printBinary(BinaryExp exp2, String op) {
        String r2 = exp2.exp1.getClass() == exp2.getClass() || !ExpressionPrinter.isComplex(exp2.exp1) ? (String)exp2.exp1.visit(this) : "(" + exp2.exp1.visit(this) + ")";
        r2 = r2 + op;
        r2 = !ExpressionPrinter.isComplex(exp2.exp2) ? r2 + exp2.exp2.visit(this) : r2 + "(" + exp2.exp2.visit(this) + ")";
        return r2;
    }

    public Object onAttribute(AttributeExp exp2) {
        return "@" + exp2.nameClass.toString() + "<" + exp2.exp.visit(this) + ">";
    }

    private Object optional(Expression exp2) {
        if (exp2 instanceof OneOrMoreExp) {
            OneOrMoreExp ome = (OneOrMoreExp)exp2;
            if (ExpressionPrinter.isComplex(ome.exp)) {
                return "(" + ome.exp.visit(this) + ")*";
            }
            return ome.exp.visit(this) + "*";
        }
        if (ExpressionPrinter.isComplex(exp2)) {
            return "(" + exp2.visit(this) + ")?";
        }
        return exp2.visit(this) + "?";
    }

    public Object onChoice(ChoiceExp exp2) {
        if (exp2.exp1 == Expression.epsilon) {
            return this.optional(exp2.exp2);
        }
        if (exp2.exp2 == Expression.epsilon) {
            return this.optional(exp2.exp1);
        }
        return this.printBinary(exp2, "|");
    }

    public Object onConcur(ConcurExp exp2) {
        return this.printBinary(exp2, "&");
    }

    public Object onInterleave(InterleaveExp exp2) {
        return this.printBinary(exp2, "^");
    }

    public Object onElement(ElementExp exp2) {
        if ((this.mode & 2) != 0) {
            return exp2.getNameClass().toString();
        }
        return exp2.getNameClass().toString() + "<" + exp2.contentModel.visit(this) + ">";
    }

    public Object onOneOrMore(OneOrMoreExp exp2) {
        if (ExpressionPrinter.isComplex(exp2.exp)) {
            return "(" + exp2.exp.visit(this) + ")+";
        }
        return exp2.exp.visit(this) + "+";
    }

    public Object onMixed(MixedExp exp2) {
        return "mixed[" + exp2.exp.visit(this) + "]";
    }

    public Object onList(ListExp exp2) {
        return "list[" + exp2.exp.visit(this) + "]";
    }

    public Object onEpsilon() {
        return "#epsilon";
    }

    public Object onNullSet() {
        return "#nullSet";
    }

    public Object onAnyString() {
        return "<anyString>";
    }

    public Object onSequence(SequenceExp exp2) {
        return this.printBinary(exp2, ",");
    }

    public Object onData(DataExp exp2) {
        return "$" + exp2.name.localName;
    }

    public Object onValue(ValueExp exp2) {
        return "$$" + exp2.value;
    }

    public Object onOther(OtherExp exp2) {
        return exp2.printName() + "[" + exp2.exp.visit(this) + "]";
    }

    public Object onRef(ReferenceExp exp2) {
        if ((this.mode & 1) != 0) {
            return "{%" + exp2.name + "}";
        }
        return "(" + exp2.exp.visit(this) + ")";
    }
}

