/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.shaded.msv_core.verifier.regexp;

import com.ctc.wstx.shaded.msv_core.grammar.AttributeExp;
import com.ctc.wstx.shaded.msv_core.grammar.ChoiceExp;
import com.ctc.wstx.shaded.msv_core.grammar.ConcurExp;
import com.ctc.wstx.shaded.msv_core.grammar.DataExp;
import com.ctc.wstx.shaded.msv_core.grammar.ElementExp;
import com.ctc.wstx.shaded.msv_core.grammar.Expression;
import com.ctc.wstx.shaded.msv_core.grammar.ExpressionPool;
import com.ctc.wstx.shaded.msv_core.grammar.ExpressionVisitorExpression;
import com.ctc.wstx.shaded.msv_core.grammar.InterleaveExp;
import com.ctc.wstx.shaded.msv_core.grammar.ListExp;
import com.ctc.wstx.shaded.msv_core.grammar.MixedExp;
import com.ctc.wstx.shaded.msv_core.grammar.OneOrMoreExp;
import com.ctc.wstx.shaded.msv_core.grammar.OtherExp;
import com.ctc.wstx.shaded.msv_core.grammar.ReferenceExp;
import com.ctc.wstx.shaded.msv_core.grammar.SequenceExp;
import com.ctc.wstx.shaded.msv_core.grammar.ValueExp;
import com.ctc.wstx.shaded.msv_core.verifier.regexp.ElementToken;
import com.ctc.wstx.shaded.msv_core.verifier.regexp.OptimizationTag;
import com.ctc.wstx.shaded.msv_core.verifier.regexp.Token;

public class ResidualCalculator
implements ExpressionVisitorExpression {
    protected Token token;
    protected final ExpressionPool pool;

    public ResidualCalculator(ExpressionPool pool) {
        this.pool = pool;
    }

    final Expression calcResidual(Expression exp2, ElementToken token) {
        if (token.acceptedPatterns != null && token.acceptedPatterns.length == 1) {
            Expression residual;
            OptimizationTag ot;
            if (exp2.verifierTag == null) {
                ot = new OptimizationTag();
                exp2.verifierTag = ot;
            } else {
                ot = (OptimizationTag)exp2.verifierTag;
                residual = (Expression)ot.simpleElementTokenResidual.get(token.acceptedPatterns[0]);
                if (residual != null) {
                    return residual;
                }
            }
            this.token = token;
            residual = exp2.visit(this);
            ot.simpleElementTokenResidual.put(token.acceptedPatterns[0], residual);
            return residual;
        }
        this.token = token;
        return exp2.visit(this);
    }

    public final Expression calcResidual(Expression exp2, Token token) {
        if (token instanceof ElementToken) {
            return this.calcResidual(exp2, (ElementToken)token);
        }
        this.token = token;
        Expression r2 = exp2.visit(this);
        if (token.isIgnorable()) {
            r2 = this.pool.createChoice(r2, exp2);
        }
        return r2;
    }

    public Expression onAttribute(AttributeExp exp2) {
        if (this.token.match(exp2)) {
            return Expression.epsilon;
        }
        return Expression.nullSet;
    }

    public Expression onChoice(ChoiceExp exp2) {
        return this.pool.createChoice(exp2.exp1.visit(this), exp2.exp2.visit(this));
    }

    public Expression onElement(ElementExp exp2) {
        if (this.token.match(exp2)) {
            return Expression.epsilon;
        }
        return Expression.nullSet;
    }

    public Expression onOneOrMore(OneOrMoreExp exp2) {
        return this.pool.createSequence(exp2.exp.visit(this), this.pool.createZeroOrMore(exp2.exp));
    }

    public Expression onMixed(MixedExp exp2) {
        if (this.token.matchAnyString()) {
            return exp2;
        }
        return this.pool.createMixed(exp2.exp.visit(this));
    }

    public Expression onEpsilon() {
        return Expression.nullSet;
    }

    public Expression onNullSet() {
        return Expression.nullSet;
    }

    public Expression onAnyString() {
        if (this.token.matchAnyString()) {
            return Expression.anyString;
        }
        return Expression.nullSet;
    }

    public Expression onRef(ReferenceExp exp2) {
        return exp2.exp.visit(this);
    }

    public Expression onOther(OtherExp exp2) {
        return exp2.exp.visit(this);
    }

    public Expression onSequence(SequenceExp exp2) {
        Expression r2 = this.pool.createSequence(exp2.exp1.visit(this), exp2.exp2);
        if (exp2.exp1.isEpsilonReducible()) {
            return this.pool.createChoice(r2, exp2.exp2.visit(this));
        }
        return r2;
    }

    public Expression onData(DataExp exp2) {
        if (this.token.match(exp2)) {
            return Expression.epsilon;
        }
        return Expression.nullSet;
    }

    public Expression onValue(ValueExp exp2) {
        if (this.token.match(exp2)) {
            return Expression.epsilon;
        }
        return Expression.nullSet;
    }

    public Expression onList(ListExp exp2) {
        if (this.token.match(exp2)) {
            return Expression.epsilon;
        }
        return Expression.nullSet;
    }

    public Expression onConcur(ConcurExp exp2) {
        return this.pool.createConcur(exp2.exp1.visit(this), exp2.exp2.visit(this));
    }

    public Expression onInterleave(InterleaveExp exp2) {
        return this.pool.createChoice(this.pool.createInterleave(exp2.exp1.visit(this), exp2.exp2), this.pool.createInterleave(exp2.exp1, exp2.exp2.visit(this)));
    }
}

