/*
 * Decompiled with CFR 0.152.
 */
package com.ctc.wstx.shaded.msv_core.verifier.regexp;

import com.ctc.wstx.shaded.msv_core.datatype.xsd.XSDatatype;
import com.ctc.wstx.shaded.msv_core.grammar.AttributeExp;
import com.ctc.wstx.shaded.msv_core.grammar.BinaryExp;
import com.ctc.wstx.shaded.msv_core.grammar.ChoiceExp;
import com.ctc.wstx.shaded.msv_core.grammar.ConcurExp;
import com.ctc.wstx.shaded.msv_core.grammar.DataExp;
import com.ctc.wstx.shaded.msv_core.grammar.ElementExp;
import com.ctc.wstx.shaded.msv_core.grammar.Expression;
import com.ctc.wstx.shaded.msv_core.grammar.ExpressionVisitor;
import com.ctc.wstx.shaded.msv_core.grammar.InterleaveExp;
import com.ctc.wstx.shaded.msv_core.grammar.ListExp;
import com.ctc.wstx.shaded.msv_core.grammar.MixedExp;
import com.ctc.wstx.shaded.msv_core.grammar.OneOrMoreExp;
import com.ctc.wstx.shaded.msv_core.grammar.OtherExp;
import com.ctc.wstx.shaded.msv_core.grammar.ReferenceExp;
import com.ctc.wstx.shaded.msv_core.grammar.SequenceExp;
import com.ctc.wstx.shaded.msv_core.grammar.ValueExp;

public class StringCareLevelCalculator
implements ExpressionVisitor {
    protected static final StringCareLevelCalculator theInstance = new StringCareLevelCalculator();
    private static final String ANY_STRING = "anyString";
    private static final String NO_STRING = "noString";
    private static final String SOME_STRING = "someString";

    protected StringCareLevelCalculator() {
    }

    public Object onAttribute(AttributeExp exp2) {
        return NO_STRING;
    }

    public Object onElement(ElementExp exp2) {
        return NO_STRING;
    }

    public Object onMixed(MixedExp exp2) {
        return ANY_STRING;
    }

    public Object onList(ListExp exp2) {
        return SOME_STRING;
    }

    public Object onAnyString() {
        return ANY_STRING;
    }

    public Object onData(DataExp exp2) {
        XSDatatype xdt;
        if (exp2.except == Expression.nullSet && exp2.dt instanceof XSDatatype && (xdt = (XSDatatype)exp2.dt).isAlwaysValid()) {
            return ANY_STRING;
        }
        return SOME_STRING;
    }

    public Object onValue(ValueExp exp2) {
        return SOME_STRING;
    }

    public Object onChoice(ChoiceExp exp2) {
        return this.doChoice(exp2);
    }

    private Object doChoice(BinaryExp exp2) {
        Object lhs = exp2.exp1.visit(this);
        Object rhs = exp2.exp2.visit(this);
        if (lhs == ANY_STRING && rhs == ANY_STRING) {
            return ANY_STRING;
        }
        if (lhs == NO_STRING && rhs == NO_STRING) {
            return NO_STRING;
        }
        return SOME_STRING;
    }

    public Object onOneOrMore(OneOrMoreExp exp2) {
        return exp2.exp.visit(this);
    }

    public Object onRef(ReferenceExp exp2) {
        return exp2.exp.visit(this);
    }

    public Object onOther(OtherExp exp2) {
        return exp2.exp.visit(this);
    }

    public Object onEpsilon() {
        return NO_STRING;
    }

    public Object onNullSet() {
        return NO_STRING;
    }

    public Object onSequence(SequenceExp exp2) {
        if (!exp2.exp1.isEpsilonReducible()) {
            return exp2.exp1.visit(this);
        }
        return this.doChoice(exp2);
    }

    public Object onConcur(ConcurExp exp2) {
        Object lhs = exp2.exp1.visit(this);
        Object rhs = exp2.exp2.visit(this);
        if (lhs == ANY_STRING && rhs == ANY_STRING) {
            return ANY_STRING;
        }
        if (lhs == NO_STRING || rhs == NO_STRING) {
            return NO_STRING;
        }
        return SOME_STRING;
    }

    public Object onInterleave(InterleaveExp p) {
        return this.doChoice(p);
    }

    public static int calc(Expression exp2) {
        Object r2 = exp2.visit(theInstance);
        if (r2 == ANY_STRING) {
            return 1;
        }
        if (r2 == NO_STRING) {
            return 0;
        }
        return 2;
    }
}

