/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.CacheLoader;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.NullMarked;

@NullMarked
@FunctionalInterface
public interface AsyncCacheLoader<K, V> {
    public CompletableFuture<? extends V> asyncLoad(K var1, Executor var2) throws Exception;

    default public CompletableFuture<? extends Map<? extends K, ? extends @NonNull V>> asyncLoadAll(Set<? extends K> keys2, Executor executor) throws Exception {
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<? extends V> asyncReload(K key, @NonNull V oldValue, Executor executor) throws Exception {
        return this.asyncLoad(key, executor);
    }

    public static <K, V> AsyncCacheLoader<K, V> bulk(Function<? super Set<? extends K>, ? extends Map<? extends K, ? extends @NonNull V>> mappingFunction) {
        return CacheLoader.bulk(mappingFunction);
    }

    public static <K, V> AsyncCacheLoader<K, V> bulk(final BiFunction<? super Set<? extends K>, ? super Executor, ? extends CompletableFuture<? extends Map<? extends K, ? extends @NonNull V>>> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        return new AsyncCacheLoader<K, V>(){

            @Override
            public CompletableFuture<V> asyncLoad(K key, Executor executor) {
                return this.asyncLoadAll(Set.of(key), executor).thenApply(results -> results.get(key));
            }

            @Override
            public CompletableFuture<Map<K, V>> asyncLoadAll(Set<? extends K> keys2, Executor executor) {
                Objects.requireNonNull(keys2);
                Objects.requireNonNull(executor);
                CompletableFuture future2 = (CompletableFuture)mappingFunction.apply(keys2, executor);
                return future2;
            }
        };
    }
}

