/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.Async;
import com.github.benmanes.caffeine.cache.AsyncCache;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LocalCache;
import com.github.benmanes.caffeine.cache.Policy;
import com.github.benmanes.caffeine.cache.WriteThroughEntry;
import com.github.benmanes.caffeine.cache.stats.CacheStats;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.jspecify.annotations.Nullable;

interface LocalAsyncCache<K, V>
extends AsyncCache<K, V> {
    public static final System.Logger logger = System.getLogger(LocalAsyncCache.class.getName());

    public LocalCache<K, CompletableFuture<V>> cache();

    public Policy<K, V> policy();

    @Override
    default public @Nullable CompletableFuture<V> getIfPresent(K key) {
        return this.cache().getIfPresent(key, true);
    }

    @Override
    default public CompletableFuture<V> get(K key, Function<? super K, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        return this.get(key, (? super K k1, ? super Executor executor) -> CompletableFuture.supplyAsync(() -> mappingFunction.apply((Object)key), executor));
    }

    @Override
    default public CompletableFuture<V> get(K key, BiFunction<? super K, ? super Executor, ? extends CompletableFuture<? extends V>> mappingFunction) {
        return this.get(key, mappingFunction, true);
    }

    default public CompletableFuture<V> get(K key, BiFunction<? super K, ? super Executor, ? extends CompletableFuture<? extends V>> mappingFunction, boolean recordStats) {
        long startTime = this.cache().statsTicker().read();
        CompletableFuture[] result = new CompletableFuture[1];
        CompletableFuture future2 = this.cache().computeIfAbsent(key, k -> {
            CompletableFuture castedResult;
            result[0] = castedResult = (CompletableFuture)mappingFunction.apply((K)key, this.cache().executor());
            return Objects.requireNonNull(castedResult);
        }, recordStats, false);
        if (result[0] != null) {
            this.handleCompletion(key, result[0], startTime, false);
        }
        return future2;
    }

    @Override
    default public CompletableFuture<Map<K, V>> getAll(Iterable<? extends K> keys2, Function<? super Set<? extends K>, ? extends Map<? extends K, ? extends V>> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        return this.getAll(keys2, (? super Set<? extends K> keysToLoad, ? super Executor executor) -> CompletableFuture.supplyAsync(() -> (Map)mappingFunction.apply((Object)keysToLoad), executor));
    }

    @Override
    default public CompletableFuture<Map<K, V>> getAll(Iterable<? extends K> keys2, BiFunction<? super Set<? extends K>, ? super Executor, ? extends CompletableFuture<? extends Map<? extends K, ? extends V>>> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        Objects.requireNonNull(keys2);
        int initialCapacity = Caffeine.calculateHashMapCapacity(keys2);
        LinkedHashMap futures = new LinkedHashMap(initialCapacity);
        LinkedHashMap proxies = new LinkedHashMap(initialCapacity);
        for (K key : keys2) {
            if (futures.containsKey(key)) continue;
            CompletableFuture<Object> future2 = this.cache().getIfPresent(key, false);
            if (future2 == null) {
                CompletableFuture proxy = new CompletableFuture();
                future2 = this.cache().putIfAbsent(key, proxy);
                if (future2 == null) {
                    future2 = proxy;
                    proxies.put(key, proxy);
                }
            }
            futures.put(key, future2);
        }
        this.cache().statsCounter().recordMisses(proxies.size());
        this.cache().statsCounter().recordHits(futures.size() - proxies.size());
        if (proxies.isEmpty()) {
            return LocalAsyncCache.composeResult(futures);
        }
        AsyncBulkCompleter completer = new AsyncBulkCompleter(this.cache(), proxies);
        try {
            CompletableFuture<Map<K, V>> loader = mappingFunction.apply(Collections.unmodifiableSet(proxies.keySet()), this.cache().executor());
            return ((CompletableFuture)loader.handle((BiFunction)completer)).thenCompose(ignored -> LocalAsyncCache.composeResult(futures));
        }
        catch (Throwable t) {
            completer.apply(null, t);
            throw t;
        }
    }

    public static <K, V> CompletableFuture<Map<K, V>> composeResult(Map<K, CompletableFuture<V>> futures) {
        if (futures.isEmpty()) {
            Map emptyMap = Collections.unmodifiableMap(Collections.emptyMap());
            return CompletableFuture.completedFuture(emptyMap);
        }
        CompletableFuture[] array2 = futures.values().toArray(new CompletableFuture[0]);
        return CompletableFuture.allOf(array2).thenApply(ignored -> {
            LinkedHashMap result = new LinkedHashMap(Caffeine.calculateHashMapCapacity(futures.size()));
            futures.forEach((key, future2) -> {
                Object value2 = future2.getNow(null);
                if (value2 != null) {
                    result.put(key, value2);
                }
            });
            return Collections.unmodifiableMap(result);
        });
    }

    @Override
    default public void put(K key, CompletableFuture<? extends V> valueFuture) {
        if (valueFuture.isCompletedExceptionally() || valueFuture.isDone() && valueFuture.join() == null) {
            this.cache().statsCounter().recordLoadFailure(0L);
            this.cache().remove(key);
            return;
        }
        long startTime = this.cache().statsTicker().read();
        CompletableFuture<V> castedFuture = valueFuture;
        this.cache().put(key, castedFuture);
        this.handleCompletion(key, valueFuture, startTime, false);
    }

    default public void handleCompletion(K key, CompletableFuture<? extends V> valueFuture, long startTime, boolean recordMiss) {
        AtomicBoolean completed = new AtomicBoolean();
        valueFuture.whenComplete((value2, error2) -> {
            if (!completed.compareAndSet(false, true)) {
                return;
            }
            long loadTime = this.cache().statsTicker().read() - startTime;
            if (value2 == null) {
                if (error2 != null && !(error2 instanceof CancellationException) && !(error2 instanceof TimeoutException)) {
                    logger.log(System.Logger.Level.WARNING, "Exception thrown during asynchronous load", (Throwable)error2);
                }
                this.cache().statsCounter().recordLoadFailure(loadTime);
                this.cache().remove(key, valueFuture);
            } else {
                CompletableFuture castedFuture = valueFuture;
                try {
                    this.cache().replace(key, castedFuture, castedFuture, false);
                    this.cache().statsCounter().recordLoadSuccess(loadTime);
                }
                catch (Throwable t) {
                    logger.log(System.Logger.Level.WARNING, "Exception thrown during asynchronous load", t);
                    this.cache().statsCounter().recordLoadFailure(loadTime);
                    this.cache().remove(key, valueFuture);
                }
            }
            if (recordMiss) {
                this.cache().statsCounter().recordMisses(1);
            }
        });
    }

    public static final class AsyncBulkCompleter<K, V>
    implements BiFunction<Map<? extends K, ? extends V>, Throwable, Map<? extends K, ? extends V>> {
        private final LocalCache<K, CompletableFuture<V>> cache;
        private final Map<K, CompletableFuture<V>> proxies;
        private final long startTime;

        AsyncBulkCompleter(LocalCache<K, CompletableFuture<V>> cache, Map<K, CompletableFuture<V>> proxies) {
            this.startTime = cache.statsTicker().read();
            this.proxies = proxies;
            this.cache = cache;
        }

        @Override
        @CanIgnoreReturnValue
        public @Nullable Map<? extends K, ? extends V> apply(@Nullable Map<? extends K, ? extends V> result, @Nullable Throwable error2) {
            long loadTime = this.cache.statsTicker().read() - this.startTime;
            Throwable failure = this.handleResponse(result, error2);
            if (failure == null) {
                this.cache.statsCounter().recordLoadSuccess(loadTime);
                return result;
            }
            this.cache.statsCounter().recordLoadFailure(loadTime);
            if (failure instanceof RuntimeException) {
                throw (RuntimeException)failure;
            }
            if (failure instanceof Error) {
                throw (Error)failure;
            }
            throw new CompletionException(failure);
        }

        private @Nullable Throwable handleResponse(@Nullable Map<? extends K, ? extends V> result, @Nullable Throwable error2) {
            if (result == null) {
                Throwable failure = error2 == null ? new NullMapCompletionException() : error2;
                for (Map.Entry<K, CompletableFuture<V>> entry : this.proxies.entrySet()) {
                    this.cache.remove(entry.getKey(), entry.getValue());
                    entry.getValue().obtrudeException(failure);
                }
                if (!(failure instanceof CancellationException) && !(failure instanceof TimeoutException)) {
                    logger.log(System.Logger.Level.WARNING, "Exception thrown during asynchronous load", failure);
                }
                return failure;
            }
            Throwable failure = this.fillProxies(result);
            return this.addNewEntries(result, failure);
        }

        private @Nullable Throwable fillProxies(Map<? extends K, ? extends V> result) {
            Throwable error2 = null;
            for (Map.Entry<K, CompletableFuture<V>> entry : this.proxies.entrySet()) {
                K key = entry.getKey();
                V value2 = result.get(key);
                CompletableFuture<V> future2 = entry.getValue();
                future2.obtrudeValue(value2);
                if (value2 == null) {
                    this.cache.remove(key, future2);
                    continue;
                }
                try {
                    this.cache.replace(key, future2, future2);
                }
                catch (Throwable t) {
                    logger.log(System.Logger.Level.WARNING, "Exception thrown during asynchronous load", t);
                    this.cache.remove(key, future2);
                    if (error2 == null) {
                        error2 = t;
                        continue;
                    }
                    error2.addSuppressed(t);
                }
            }
            return error2;
        }

        private @Nullable Throwable addNewEntries(Map<? extends K, ? extends V> result, @Nullable Throwable failure) {
            Throwable error2 = failure;
            for (Map.Entry<K, V> entry : result.entrySet()) {
                K key = entry.getKey();
                V value2 = result.get(key);
                if (this.proxies.containsKey(key)) continue;
                try {
                    this.cache.put(key, CompletableFuture.completedFuture(value2));
                }
                catch (Throwable t) {
                    logger.log(System.Logger.Level.WARNING, "Exception thrown during asynchronous load", t);
                    if (error2 == null) {
                        error2 = t;
                        continue;
                    }
                    error2.addSuppressed(t);
                }
            }
            return error2;
        }

        static final class NullMapCompletionException
        extends CompletionException {
            private static final long serialVersionUID = 1L;

            NullMapCompletionException() {
            }
        }
    }

    public static final class AsMapView<K, V>
    implements ConcurrentMap<K, V> {
        final LocalCache<K, CompletableFuture<V>> delegate;
        @Nullable Set<K> keys;
        @Nullable Collection<V> values;
        @Nullable Set<Map.Entry<K, V>> entries;

        AsMapView(LocalCache<K, CompletableFuture<V>> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public void clear() {
            this.delegate.clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return Async.isReady(this.delegate.getIfPresentQuietly(key));
        }

        @Override
        public boolean containsValue(Object value2) {
            Objects.requireNonNull(value2);
            for (CompletableFuture valueFuture : this.delegate.values()) {
                if (!value2.equals(Async.getIfReady(valueFuture))) continue;
                return true;
            }
            return false;
        }

        @Override
        public @Nullable V get(Object key) {
            return Async.getIfReady((CompletableFuture)this.delegate.get(key));
        }

        @Override
        public @Nullable V putIfAbsent(K key, V value2) {
            V prior;
            Objects.requireNonNull(value2);
            CompletableFuture<V> priorFuture = null;
            while (true) {
                CompletableFuture<V> completableFuture = priorFuture = priorFuture == null ? (CompletableFuture<V>)this.delegate.get(key) : this.delegate.getIfPresentQuietly(key);
                if (priorFuture != null) {
                    if (!priorFuture.isDone()) {
                        Async.getWhenSuccessful(priorFuture);
                        continue;
                    }
                    V prior2 = Async.getWhenSuccessful(priorFuture);
                    if (prior2 != null) {
                        return prior2;
                    }
                }
                boolean[] added = new boolean[]{false};
                CompletableFuture<V> computed = this.delegate.compute(key, (k, valueFuture) -> {
                    added[0] = valueFuture == null || valueFuture.isDone() && Async.getIfReady(valueFuture) == null;
                    return added[0] ? CompletableFuture.completedFuture(value2) : valueFuture;
                }, this.delegate.expiry(), false, false);
                if (added[0]) {
                    return null;
                }
                prior = Async.getWhenSuccessful(computed);
                if (prior != null) break;
            }
            return prior;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map2) {
            map2.forEach(this::put);
        }

        @Override
        public @Nullable V put(K key, V value2) {
            Objects.requireNonNull(value2);
            CompletableFuture<V> oldValueFuture = this.delegate.put(key, CompletableFuture.completedFuture(value2));
            return Async.getWhenSuccessful(oldValueFuture);
        }

        @Override
        public @Nullable V remove(Object key) {
            CompletableFuture oldValueFuture = (CompletableFuture)this.delegate.remove(key);
            return Async.getWhenSuccessful(oldValueFuture);
        }

        @Override
        public boolean remove(Object key, Object value2) {
            Objects.requireNonNull(key);
            if (value2 == null) {
                return false;
            }
            Object castedKey = key;
            boolean[] done = new boolean[]{false};
            boolean[] removed = new boolean[]{false};
            CompletableFuture<V> future2 = null;
            do {
                CompletableFuture<V> completableFuture = future2 = future2 == null ? (CompletableFuture<V>)this.delegate.get(castedKey) : this.delegate.getIfPresentQuietly(castedKey);
                if (future2 == null || future2.isCompletedExceptionally()) {
                    return false;
                }
                Async.getWhenSuccessful(future2);
                this.delegate.compute(castedKey, (k, oldValueFuture) -> {
                    if (oldValueFuture == null) {
                        done[0] = true;
                        return null;
                    }
                    if (!oldValueFuture.isDone()) {
                        return oldValueFuture;
                    }
                    done[0] = true;
                    Object oldValue = Async.getIfReady(oldValueFuture);
                    removed[0] = value2.equals(oldValue);
                    return oldValue == null || removed[0] ? null : oldValueFuture;
                }, this.delegate.expiry(), false, true);
            } while (!done[0]);
            return removed[0];
        }

        @Override
        public @Nullable V replace(K key, V value2) {
            Objects.requireNonNull(value2);
            @Nullable Object[] oldValue = new Object[1];
            boolean[] done = new boolean[]{false};
            do {
                CompletableFuture<V> future2;
                if ((future2 = this.delegate.getIfPresentQuietly(key)) == null || future2.isCompletedExceptionally()) {
                    return null;
                }
                Async.getWhenSuccessful(future2);
                this.delegate.compute(key, (k, oldValueFuture) -> {
                    if (oldValueFuture == null) {
                        done[0] = true;
                        return null;
                    }
                    if (!oldValueFuture.isDone()) {
                        return oldValueFuture;
                    }
                    done[0] = true;
                    oldValue[0] = Async.getIfReady(oldValueFuture);
                    return oldValue[0] == null ? null : CompletableFuture.completedFuture(value2);
                }, this.delegate.expiry(), false, false);
            } while (!done[0]);
            return (V)oldValue[0];
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            Objects.requireNonNull(oldValue);
            Objects.requireNonNull(newValue);
            boolean[] done = new boolean[]{false};
            boolean[] replaced = new boolean[]{false};
            do {
                CompletableFuture<V> future2;
                if ((future2 = this.delegate.getIfPresentQuietly(key)) == null || future2.isCompletedExceptionally()) {
                    return false;
                }
                Async.getWhenSuccessful(future2);
                this.delegate.compute(key, (k, oldValueFuture) -> {
                    if (oldValueFuture == null) {
                        done[0] = true;
                        return null;
                    }
                    if (!oldValueFuture.isDone()) {
                        return oldValueFuture;
                    }
                    done[0] = true;
                    replaced[0] = oldValue.equals(Async.getIfReady(oldValueFuture));
                    return replaced[0] ? CompletableFuture.completedFuture(newValue) : oldValueFuture;
                }, this.delegate.expiry(), false, false);
            } while (!done[0]);
            return replaced[0];
        }

        @Override
        public @Nullable V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            V result;
            Objects.requireNonNull(mappingFunction);
            CompletableFuture<V> priorFuture = null;
            while (true) {
                CompletableFuture<V> completableFuture = priorFuture = priorFuture == null ? (CompletableFuture<V>)this.delegate.get(key) : this.delegate.getIfPresentQuietly(key);
                if (priorFuture != null) {
                    if (!priorFuture.isDone()) {
                        Async.getWhenSuccessful(priorFuture);
                        continue;
                    }
                    V prior = Async.getWhenSuccessful(priorFuture);
                    if (prior != null) {
                        this.delegate.statsCounter().recordHits(1);
                        return prior;
                    }
                }
                CompletableFuture[] future2 = new CompletableFuture[1];
                CompletableFuture<V> computed = this.delegate.compute(key, (k, valueFuture) -> {
                    if (valueFuture != null && valueFuture.isDone() && Async.getIfReady(valueFuture) != null) {
                        return valueFuture;
                    }
                    Object newValue = this.delegate.statsAware(mappingFunction, true).apply(key);
                    if (newValue == null) {
                        return null;
                    }
                    future2[0] = CompletableFuture.completedFuture(newValue);
                    return future2[0];
                }, this.delegate.expiry(), false, false);
                result = Async.getWhenSuccessful(computed);
                if (computed == future2[0] || result != null) break;
            }
            return result;
        }

        @Override
        public @Nullable V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            CompletableFuture valueFuture;
            Objects.requireNonNull(remappingFunction);
            Object[] newValue = new Object[1];
            do {
                Async.getWhenSuccessful(this.delegate.getIfPresentQuietly(key));
                valueFuture = this.delegate.computeIfPresent(key, (k, oldValueFuture) -> {
                    if (!oldValueFuture.isDone()) {
                        return oldValueFuture;
                    }
                    Object oldValue = Async.getIfReady(oldValueFuture);
                    if (oldValue == null) {
                        return null;
                    }
                    newValue[0] = remappingFunction.apply((Object)key, (Object)oldValue);
                    return newValue[0] == null ? null : CompletableFuture.completedFuture(newValue[0]);
                });
                if (newValue[0] == null) continue;
                return (V)newValue[0];
            } while (valueFuture != null);
            return null;
        }

        @Override
        public @Nullable V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            CompletableFuture<V> valueFuture;
            Objects.requireNonNull(remappingFunction);
            Object[] newValue = new Object[1];
            do {
                Async.getWhenSuccessful(this.delegate.getIfPresentQuietly(key));
                valueFuture = this.delegate.compute(key, (k, oldValueFuture) -> {
                    if (oldValueFuture != null && !oldValueFuture.isDone()) {
                        return oldValueFuture;
                    }
                    Object oldValue = Async.getIfReady(oldValueFuture);
                    BiFunction function2 = this.delegate.statsAware(remappingFunction, true, true);
                    newValue[0] = function2.apply(key, oldValue);
                    return newValue[0] == null ? null : CompletableFuture.completedFuture(newValue[0]);
                }, this.delegate.expiry(), false, false);
                if (newValue[0] == null) continue;
                return (V)newValue[0];
            } while (valueFuture != null);
            return null;
        }

        @Override
        public @Nullable V merge(K key, V value2, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            CompletableFuture mergedValueFuture;
            Objects.requireNonNull(value2);
            Objects.requireNonNull(remappingFunction);
            CompletableFuture<V> newValueFuture = CompletableFuture.completedFuture(value2);
            boolean[] merged = new boolean[]{false};
            do {
                Async.getWhenSuccessful(this.delegate.getIfPresentQuietly(key));
                mergedValueFuture = this.delegate.merge(key, newValueFuture, (oldValueFuture, valueFuture) -> {
                    if (oldValueFuture != null && !oldValueFuture.isDone()) {
                        return oldValueFuture;
                    }
                    merged[0] = true;
                    Object oldValue = Async.getIfReady(oldValueFuture);
                    if (oldValue == null) {
                        return valueFuture;
                    }
                    Object mergedValue = remappingFunction.apply((Object)oldValue, (Object)value2);
                    if (mergedValue == null) {
                        return null;
                    }
                    if (mergedValue == oldValue) {
                        return oldValueFuture;
                    }
                    if (mergedValue == value2) {
                        return valueFuture;
                    }
                    return CompletableFuture.completedFuture(mergedValue);
                });
            } while (!merged[0] && mergedValueFuture != newValueFuture);
            return Async.getWhenSuccessful(mergedValueFuture);
        }

        @Override
        public Set<K> keySet() {
            return this.keys == null ? (this.keys = new KeySet()) : this.keys;
        }

        @Override
        public Collection<V> values() {
            return this.values == null ? (this.values = new Values()) : this.values;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.entries == null ? (this.entries = new EntrySet()) : this.entries;
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Map)) {
                return false;
            }
            Map map2 = (Map)o;
            int expectedSize = this.size();
            if (map2.size() != expectedSize) {
                return false;
            }
            int count2 = 0;
            EntryIterator iterator2 = new EntryIterator();
            while (iterator2.hasNext()) {
                Object entry = iterator2.next();
                Object value2 = map2.get(entry.getKey());
                if (value2 == null || value2 != entry.getValue() && !value2.equals(entry.getValue())) {
                    return false;
                }
                ++count2;
            }
            return count2 == expectedSize;
        }

        @Override
        public int hashCode() {
            int hash = 0;
            EntryIterator iterator2 = new EntryIterator();
            while (iterator2.hasNext()) {
                Object entry = iterator2.next();
                hash += entry.hashCode();
            }
            return hash;
        }

        public String toString() {
            StringBuilder result = new StringBuilder(50).append('{');
            EntryIterator iterator2 = new EntryIterator();
            while (iterator2.hasNext()) {
                Object entry = iterator2.next();
                result.append((Object)(entry.getKey() == this ? "(this Map)" : entry.getKey())).append('=').append((Object)(entry.getValue() == this ? "(this Map)" : entry.getValue()));
                if (!iterator2.hasNext()) continue;
                result.append(", ");
            }
            return result.append('}').toString();
        }

        private final class KeySet
        extends AbstractSet<K> {
            private KeySet() {
            }

            @Override
            public boolean isEmpty() {
                return AsMapView.this.isEmpty();
            }

            @Override
            public int size() {
                return AsMapView.this.size();
            }

            @Override
            public void clear() {
                AsMapView.this.clear();
            }

            @Override
            public boolean contains(Object o) {
                return AsMapView.this.containsKey(o);
            }

            @Override
            public boolean removeAll(Collection<?> collection2) {
                return AsMapView.this.delegate.keySet().removeAll(collection2);
            }

            @Override
            public boolean remove(Object o) {
                return AsMapView.this.delegate.keySet().remove(o);
            }

            @Override
            public boolean removeIf(Predicate<? super K> filter2) {
                return AsMapView.this.delegate.keySet().removeIf(filter2);
            }

            @Override
            public boolean retainAll(Collection<?> collection2) {
                return AsMapView.this.delegate.keySet().retainAll(collection2);
            }

            @Override
            public Iterator<K> iterator() {
                return new Iterator<K>(){
                    final Iterator<Map.Entry<K, V>> iterator;
                    {
                        this.iterator = AsMapView.this.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public K next() {
                        return this.iterator.next().getKey();
                    }

                    @Override
                    public void remove() {
                        this.iterator.remove();
                    }
                };
            }
        }

        private final class Values
        extends AbstractCollection<V> {
            private Values() {
            }

            @Override
            public boolean isEmpty() {
                return AsMapView.this.isEmpty();
            }

            @Override
            public int size() {
                return AsMapView.this.size();
            }

            @Override
            public void clear() {
                AsMapView.this.clear();
            }

            @Override
            public boolean contains(Object o) {
                return AsMapView.this.containsValue(o);
            }

            @Override
            public boolean removeAll(Collection<?> collection2) {
                Objects.requireNonNull(collection2);
                boolean modified = false;
                for (Map.Entry entry : AsMapView.this.delegate.entrySet()) {
                    Object value2 = Async.getIfReady((CompletableFuture)entry.getValue());
                    if (value2 == null || !collection2.contains(value2) || !AsMapView.this.remove(entry.getKey(), value2)) continue;
                    modified = true;
                }
                return modified;
            }

            @Override
            public boolean remove(Object o) {
                if (o == null) {
                    return false;
                }
                for (Map.Entry entry : AsMapView.this.delegate.entrySet()) {
                    Object value2 = Async.getIfReady((CompletableFuture)entry.getValue());
                    if (value2 == null || !value2.equals(o) || !AsMapView.this.remove(entry.getKey(), value2)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean removeIf(Predicate<? super V> filter2) {
                Objects.requireNonNull(filter2);
                return AsMapView.this.delegate.values().removeIf((? super E future2) -> {
                    Object value2 = Async.getIfReady(future2);
                    return value2 != null && filter2.test((Object)value2);
                });
            }

            @Override
            public boolean retainAll(Collection<?> collection2) {
                Objects.requireNonNull(collection2);
                boolean modified = false;
                for (Map.Entry entry : AsMapView.this.delegate.entrySet()) {
                    Object value2 = Async.getIfReady((CompletableFuture)entry.getValue());
                    if (value2 == null || collection2.contains(value2) || !AsMapView.this.remove(entry.getKey(), value2)) continue;
                    modified = true;
                }
                return modified;
            }

            @Override
            public void forEach(Consumer<? super V> action) {
                Objects.requireNonNull(action);
                AsMapView.this.delegate.values().forEach((? super T future2) -> {
                    Object value2 = Async.getIfReady(future2);
                    if (value2 != null) {
                        action.accept((Object)value2);
                    }
                });
            }

            @Override
            public Iterator<V> iterator() {
                return new Iterator<V>(){
                    final Iterator<Map.Entry<K, V>> iterator;
                    {
                        this.iterator = AsMapView.this.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public V next() {
                        return this.iterator.next().getValue();
                    }

                    @Override
                    public void remove() {
                        this.iterator.remove();
                    }
                };
            }
        }

        private final class EntrySet
        extends AbstractSet<Map.Entry<K, V>> {
            private EntrySet() {
            }

            @Override
            public boolean isEmpty() {
                return AsMapView.this.isEmpty();
            }

            @Override
            public int size() {
                return AsMapView.this.size();
            }

            @Override
            public void clear() {
                AsMapView.this.clear();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                Object value2 = entry.getValue();
                if (key == null || value2 == null) {
                    return false;
                }
                Object cachedValue = AsMapView.this.get(key);
                return cachedValue != null && cachedValue.equals(value2);
            }

            @Override
            public boolean removeAll(Collection<?> collection2) {
                Objects.requireNonNull(collection2);
                boolean modified = false;
                if (collection2 instanceof Set && collection2.size() > this.size()) {
                    for (Map.Entry entry : this) {
                        if (!collection2.contains(entry)) continue;
                        modified |= this.remove(entry);
                    }
                } else {
                    for (Object o : collection2) {
                        modified |= this.remove(o);
                    }
                }
                return modified;
            }

            @Override
            public boolean remove(Object obj) {
                if (!(obj instanceof Map.Entry)) {
                    return false;
                }
                Map.Entry entry = (Map.Entry)obj;
                Object key = entry.getKey();
                return key != null && AsMapView.this.remove(key, entry.getValue());
            }

            @Override
            public boolean removeIf(Predicate<? super Map.Entry<K, V>> filter2) {
                Objects.requireNonNull(filter2);
                boolean modified = false;
                for (Map.Entry entry : this) {
                    if (!filter2.test(entry)) continue;
                    modified |= AsMapView.this.remove(entry.getKey(), entry.getValue());
                }
                return modified;
            }

            @Override
            public boolean retainAll(Collection<?> collection2) {
                Objects.requireNonNull(collection2);
                boolean modified = false;
                for (Map.Entry entry : this) {
                    if (collection2.contains(entry) || !this.remove(entry)) continue;
                    modified = true;
                }
                return modified;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntryIterator();
            }
        }

        private final class EntryIterator
        implements Iterator<Map.Entry<K, V>> {
            final Iterator<Map.Entry<K, CompletableFuture<V>>> iterator;
            @Nullable Map.Entry<K, V> cursor;
            @Nullable K removalKey;

            EntryIterator() {
                this.iterator = AsMapView.this.delegate.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                while (this.cursor == null && this.iterator.hasNext()) {
                    Map.Entry entry = this.iterator.next();
                    Object value2 = Async.getIfReady(entry.getValue());
                    if (value2 == null) continue;
                    this.cursor = new WriteThroughEntry(AsMapView.this, entry.getKey(), value2);
                }
                return this.cursor != null;
            }

            @Override
            public Map.Entry<K, V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object key = this.cursor.getKey();
                Map.Entry entry = this.cursor;
                this.removalKey = key;
                this.cursor = null;
                return entry;
            }

            @Override
            public void remove() {
                Caffeine.requireState(this.removalKey != null);
                AsMapView.this.delegate.remove(this.removalKey);
                this.removalKey = null;
            }
        }
    }

    public static abstract class AbstractCacheView<K, V>
    implements Cache<K, V>,
    Serializable {
        private static final long serialVersionUID = 1L;
        transient @Nullable ConcurrentMap<K, V> asMapView;

        abstract LocalAsyncCache<K, V> asyncCache();

        @Override
        public @Nullable V getIfPresent(K key) {
            CompletableFuture<V> future2 = this.asyncCache().cache().getIfPresent(key, true);
            return Async.getIfReady(future2);
        }

        @Override
        public Map<K, V> getAllPresent(Iterable<? extends K> keys2) {
            LinkedHashMap result = new LinkedHashMap(Caffeine.calculateHashMapCapacity(keys2));
            for (K key : keys2) {
                result.put(key, null);
            }
            int uniqueKeys = result.size();
            Iterator iter = result.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                CompletableFuture future2 = (CompletableFuture)this.asyncCache().cache().get(entry.getKey());
                Object value2 = Async.getIfReady(future2);
                if (value2 == null) {
                    iter.remove();
                    continue;
                }
                entry.setValue(value2);
            }
            this.asyncCache().cache().statsCounter().recordHits(result.size());
            this.asyncCache().cache().statsCounter().recordMisses(uniqueKeys - result.size());
            return Collections.unmodifiableMap(result);
        }

        @Override
        public V get(K key, Function<? super K, ? extends V> mappingFunction) {
            return AbstractCacheView.resolve(this.asyncCache().get((K)key, mappingFunction));
        }

        @Override
        public Map<K, V> getAll(Iterable<? extends K> keys2, Function<? super Set<? extends K>, ? extends Map<? extends K, ? extends V>> mappingFunction) {
            return AbstractCacheView.resolve(this.asyncCache().getAll(keys2, mappingFunction));
        }

        protected static <T> T resolve(CompletableFuture<T> future2) {
            try {
                return future2.join();
            }
            catch (AsyncBulkCompleter.NullMapCompletionException e2) {
                throw new NullPointerException("null map");
            }
            catch (CompletionException e3) {
                if (e3.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e3.getCause();
                }
                if (e3.getCause() instanceof Error) {
                    throw (Error)e3.getCause();
                }
                throw e3;
            }
        }

        @Override
        public void put(K key, V value2) {
            Objects.requireNonNull(value2);
            this.asyncCache().cache().put(key, CompletableFuture.completedFuture(value2));
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> map2) {
            map2.forEach(this::put);
        }

        @Override
        public void invalidate(K key) {
            this.asyncCache().cache().remove(key);
        }

        @Override
        public void invalidateAll(Iterable<? extends K> keys2) {
            this.asyncCache().cache().invalidateAll(keys2);
        }

        @Override
        public void invalidateAll() {
            this.asyncCache().cache().clear();
        }

        @Override
        public long estimatedSize() {
            return this.asyncCache().cache().estimatedSize();
        }

        @Override
        public CacheStats stats() {
            return this.asyncCache().cache().statsCounter().snapshot();
        }

        @Override
        public void cleanUp() {
            this.asyncCache().cache().cleanUp();
        }

        @Override
        public Policy<K, V> policy() {
            return this.asyncCache().policy();
        }

        @Override
        public ConcurrentMap<K, V> asMap() {
            return this.asMapView == null ? (this.asMapView = new AsMapView<K, V>(this.asyncCache().cache())) : this.asMapView;
        }
    }

    public static final class CacheView<K, V>
    extends AbstractCacheView<K, V> {
        private static final long serialVersionUID = 1L;
        final LocalAsyncCache<K, V> asyncCache;

        CacheView(LocalAsyncCache<K, V> asyncCache) {
            this.asyncCache = Objects.requireNonNull(asyncCache);
        }

        @Override
        LocalAsyncCache<K, V> asyncCache() {
            return this.asyncCache;
        }
    }

    public static final class AsyncAsMapView<K, V>
    implements ConcurrentMap<K, CompletableFuture<V>> {
        final LocalAsyncCache<K, V> asyncCache;

        AsyncAsMapView(LocalAsyncCache<K, V> asyncCache) {
            this.asyncCache = Objects.requireNonNull(asyncCache);
        }

        @Override
        public boolean isEmpty() {
            return this.asyncCache.cache().isEmpty();
        }

        @Override
        public int size() {
            return this.asyncCache.cache().size();
        }

        @Override
        public void clear() {
            this.asyncCache.cache().clear();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.asyncCache.cache().containsKey(key);
        }

        @Override
        public boolean containsValue(Object value2) {
            return this.asyncCache.cache().containsValue(value2);
        }

        @Override
        public @Nullable CompletableFuture<V> get(Object key) {
            return (CompletableFuture)this.asyncCache.cache().get(key);
        }

        @Override
        public CompletableFuture<V> putIfAbsent(K key, CompletableFuture<V> value2) {
            CompletableFuture<V> prior = this.asyncCache.cache().putIfAbsent(key, value2);
            long startTime = this.asyncCache.cache().statsTicker().read();
            if (prior == null) {
                this.asyncCache.handleCompletion(key, value2, startTime, false);
            }
            return prior;
        }

        @Override
        public CompletableFuture<V> put(K key, CompletableFuture<V> value2) {
            CompletableFuture<V> prior = this.asyncCache.cache().put(key, value2);
            long startTime = this.asyncCache.cache().statsTicker().read();
            this.asyncCache.handleCompletion(key, value2, startTime, false);
            return prior;
        }

        @Override
        public void putAll(Map<? extends K, ? extends CompletableFuture<V>> map2) {
            map2.forEach(this::put);
        }

        @Override
        public CompletableFuture<V> replace(K key, CompletableFuture<V> value2) {
            CompletableFuture<V> prior = this.asyncCache.cache().replace(key, value2);
            long startTime = this.asyncCache.cache().statsTicker().read();
            if (prior != null) {
                this.asyncCache.handleCompletion(key, value2, startTime, false);
            }
            return prior;
        }

        @Override
        public boolean replace(K key, CompletableFuture<V> oldValue, CompletableFuture<V> newValue) {
            boolean replaced = this.asyncCache.cache().replace(key, oldValue, newValue);
            long startTime = this.asyncCache.cache().statsTicker().read();
            if (replaced) {
                this.asyncCache.handleCompletion(key, newValue, startTime, false);
            }
            return replaced;
        }

        @Override
        public CompletableFuture<V> remove(Object key) {
            return (CompletableFuture)this.asyncCache.cache().remove(key);
        }

        @Override
        public boolean remove(Object key, Object value2) {
            return this.asyncCache.cache().remove(key, value2);
        }

        @Override
        public @Nullable CompletableFuture<V> computeIfAbsent(K key, Function<? super K, ? extends CompletableFuture<V>> mappingFunction) {
            Objects.requireNonNull(mappingFunction);
            CompletableFuture[] result = new CompletableFuture[1];
            long startTime = this.asyncCache.cache().statsTicker().read();
            CompletableFuture future2 = this.asyncCache.cache().computeIfAbsent(key, k -> {
                result[0] = (CompletableFuture)mappingFunction.apply((Object)k);
                return result[0];
            }, false, false);
            if (result[0] == null) {
                if (future2 != null && this.asyncCache.cache().isRecordingStats()) {
                    future2.whenComplete((r2, e2) -> {
                        if (r2 != null || e2 == null) {
                            this.asyncCache.cache().statsCounter().recordHits(1);
                        }
                    });
                }
            } else {
                this.asyncCache.handleCompletion(key, result[0], startTime, true);
            }
            return future2;
        }

        @Override
        public @Nullable CompletableFuture<V> computeIfPresent(K key, BiFunction<? super K, ? super CompletableFuture<V>, ? extends CompletableFuture<V>> remappingFunction) {
            Objects.requireNonNull(remappingFunction);
            @Nullable CompletableFuture[] result = new CompletableFuture[1];
            long startTime = this.asyncCache.cache().statsTicker().read();
            this.asyncCache.cache().compute(key, (k, oldValue) -> {
                result[0] = oldValue == null ? null : (CompletableFuture)remappingFunction.apply((Object)k, (Object)oldValue);
                return result[0];
            }, this.asyncCache.cache().expiry(), false, false);
            if (result[0] != null) {
                this.asyncCache.handleCompletion(key, result[0], startTime, false);
            }
            return result[0];
        }

        @Override
        public CompletableFuture<V> compute(K key, BiFunction<? super K, ? super CompletableFuture<V>, ? extends CompletableFuture<V>> remappingFunction) {
            Objects.requireNonNull(remappingFunction);
            CompletableFuture[] result = new CompletableFuture[1];
            long startTime = this.asyncCache.cache().statsTicker().read();
            this.asyncCache.cache().compute(key, (k, oldValue) -> {
                result[0] = (CompletableFuture)remappingFunction.apply((Object)k, (Object)oldValue);
                return result[0];
            }, this.asyncCache.cache().expiry(), false, false);
            if (result[0] != null) {
                this.asyncCache.handleCompletion(key, result[0], startTime, false);
            }
            return result[0];
        }

        @Override
        public CompletableFuture<V> merge(K key, CompletableFuture<V> value2, BiFunction<? super CompletableFuture<V>, ? super CompletableFuture<V>, ? extends CompletableFuture<V>> remappingFunction) {
            Objects.requireNonNull(value2);
            Objects.requireNonNull(remappingFunction);
            CompletableFuture[] result = new CompletableFuture[1];
            long startTime = this.asyncCache.cache().statsTicker().read();
            this.asyncCache.cache().compute(key, (k, oldValue) -> {
                result[0] = oldValue == null ? value2 : (CompletableFuture)remappingFunction.apply((Object)oldValue, (Object)value2);
                return result[0];
            }, this.asyncCache.cache().expiry(), false, false);
            if (result[0] != null) {
                this.asyncCache.handleCompletion(key, result[0], startTime, false);
            }
            return result[0];
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super CompletableFuture<V>> action) {
            this.asyncCache.cache().forEach(action);
        }

        @Override
        public Set<K> keySet() {
            return this.asyncCache.cache().keySet();
        }

        @Override
        public Collection<CompletableFuture<V>> values() {
            return this.asyncCache.cache().values();
        }

        @Override
        public Set<Map.Entry<K, CompletableFuture<V>>> entrySet() {
            return this.asyncCache.cache().entrySet();
        }

        @Override
        public boolean equals(@Nullable Object o) {
            return this.asyncCache.cache().equals(o);
        }

        @Override
        public int hashCode() {
            return this.asyncCache.cache().hashCode();
        }

        public String toString() {
            return this.asyncCache.cache().toString();
        }
    }
}

