/*
 * Decompiled with CFR 0.152.
 */
package com.github.benmanes.caffeine.cache;

import com.github.benmanes.caffeine.cache.Async;
import com.github.benmanes.caffeine.cache.AsyncCacheLoader;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.LocalAsyncCache;
import com.github.benmanes.caffeine.cache.LocalManualCache;
import com.github.benmanes.caffeine.cache.RemovalCause;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;

interface LocalLoadingCache<K, V>
extends LocalManualCache<K, V>,
LoadingCache<K, V> {
    public static final System.Logger logger = System.getLogger(LocalLoadingCache.class.getName());

    public AsyncCacheLoader<? super K, V> cacheLoader();

    public Function<K, V> mappingFunction();

    public @Nullable Function<Set<? extends K>, Map<K, V>> bulkMappingFunction();

    @Override
    default public V get(K key) {
        return this.cache().computeIfAbsent(key, this.mappingFunction());
    }

    @Override
    default public Map<K, V> getAll(Iterable<? extends K> keys2) {
        Function<Set<K>, Map<K, V>> mappingFunction = this.bulkMappingFunction();
        return mappingFunction == null ? this.loadSequentially(keys2) : this.getAll(keys2, mappingFunction);
    }

    default public Map<K, V> loadSequentially(Iterable<? extends K> keys2) {
        LinkedHashMap result = new LinkedHashMap(Caffeine.calculateHashMapCapacity(keys2));
        for (K key : keys2) {
            result.put(key, null);
        }
        int count2 = 0;
        try {
            Iterator iter = result.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                ++count2;
                V value2 = this.get(entry.getKey());
                if (value2 == null) {
                    iter.remove();
                    continue;
                }
                entry.setValue(value2);
            }
        }
        catch (Throwable t) {
            this.cache().statsCounter().recordMisses(result.size() - count2);
            throw t;
        }
        return Collections.unmodifiableMap(result);
    }

    @Override
    default public CompletableFuture<V> refresh(K key) {
        Objects.requireNonNull(key);
        long[] startTime = new long[1];
        @Nullable Object[] oldValue = new Object[1];
        CompletableFuture[] reloading = new CompletableFuture[1];
        Object keyReference = this.cache().referenceKey(key);
        CompletableFuture future2 = this.cache().refreshes().compute(keyReference, (k, existing) -> {
            if (existing != null && !Async.isReady(existing) && !this.cache().isPendingEviction(key)) {
                return existing;
            }
            try {
                startTime[0] = this.cache().statsTicker().read();
                oldValue[0] = this.cache().getIfPresentQuietly(key);
                CompletableFuture<V> refreshFuture = oldValue[0] == null ? this.cacheLoader().asyncLoad(key, this.cache().executor()) : this.cacheLoader().asyncReload(key, oldValue[0], this.cache().executor());
                reloading[0] = Objects.requireNonNull(refreshFuture, "Null future");
                return refreshFuture;
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (InterruptedException e3) {
                Thread.currentThread().interrupt();
                throw new CompletionException(e3);
            }
            catch (Exception e4) {
                throw new CompletionException(e4);
            }
        });
        if (reloading[0] != null) {
            reloading[0].whenComplete((newValue, error2) -> {
                long loadTime = this.cache().statsTicker().read() - startTime[0];
                if (error2 != null) {
                    if (!(error2 instanceof CancellationException) && !(error2 instanceof TimeoutException)) {
                        logger.log(System.Logger.Level.WARNING, "Exception thrown during refresh", (Throwable)error2);
                    }
                    this.cache().refreshes().remove(keyReference, reloading[0]);
                    this.cache().statsCounter().recordLoadFailure(loadTime);
                    return;
                }
                boolean[] discard = new boolean[1];
                Object value2 = this.cache().compute(key, (k, currentValue) -> {
                    boolean removed = this.cache().refreshes().remove(keyReference, reloading[0]);
                    if (removed && currentValue == oldValue[0]) {
                        return currentValue == null && newValue == null ? null : newValue;
                    }
                    discard[0] = currentValue != newValue;
                    return currentValue;
                }, this.cache().expiry(), false, true);
                if (discard[0] && newValue != null) {
                    RemovalCause cause2 = value2 == null ? RemovalCause.EXPLICIT : RemovalCause.REPLACED;
                    this.cache().notifyRemoval(key, newValue, cause2);
                }
                if (newValue == null) {
                    this.cache().statsCounter().recordLoadFailure(loadTime);
                } else {
                    this.cache().statsCounter().recordLoadSuccess(loadTime);
                }
            });
        }
        CompletableFuture castedFuture = future2;
        return castedFuture;
    }

    @Override
    default public CompletableFuture<Map<K, V>> refreshAll(Iterable<? extends K> keys2) {
        LinkedHashMap<Object, CompletableFuture> result = new LinkedHashMap<Object, CompletableFuture>(Caffeine.calculateHashMapCapacity(keys2));
        for (K key : keys2) {
            result.computeIfAbsent(key, this::refresh);
        }
        return LocalAsyncCache.composeResult(result);
    }

    public static <K, V> Function<K, @Nullable V> newMappingFunction(CacheLoader<? super K, V> cacheLoader) {
        return key -> {
            try {
                return cacheLoader.load(key);
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (InterruptedException e3) {
                Thread.currentThread().interrupt();
                throw new CompletionException(e3);
            }
            catch (Exception e4) {
                throw new CompletionException(e4);
            }
        };
    }

    public static <K, V> @Nullable Function<Set<? extends K>, Map<K, V>> newBulkMappingFunction(CacheLoader<? super K, V> cacheLoader) {
        if (!LocalLoadingCache.hasLoadAll(cacheLoader)) {
            return null;
        }
        return keysToLoad -> {
            try {
                Map loaded = cacheLoader.loadAll((Set)keysToLoad);
                return loaded;
            }
            catch (RuntimeException e2) {
                throw e2;
            }
            catch (InterruptedException e3) {
                Thread.currentThread().interrupt();
                throw new CompletionException(e3);
            }
            catch (Exception e4) {
                throw new CompletionException(e4);
            }
        };
    }

    public static boolean hasLoadAll(CacheLoader<?, ?> loader) {
        try {
            Method classLoadAll = loader.getClass().getMethod("loadAll", Set.class);
            Method defaultLoadAll = CacheLoader.class.getMethod("loadAll", Set.class);
            return !classLoadAll.equals(defaultLoadAll);
        }
        catch (NoSuchMethodException | SecurityException e2) {
            logger.log(System.Logger.Level.WARNING, "Cannot determine if CacheLoader can bulk load", (Throwable)e2);
            return false;
        }
    }
}

