/*
 * Decompiled with CFR 0.152.
 */
package com.moandjiezana.toml;

import com.moandjiezana.toml.ArrayValueWriter;
import com.moandjiezana.toml.ValueWriter;
import com.moandjiezana.toml.ValueWriters;
import com.moandjiezana.toml.WriterContext;
import java.util.Collection;

class PrimitiveArrayValueWriter
extends ArrayValueWriter {
    static final ValueWriter PRIMITIVE_ARRAY_VALUE_WRITER = new PrimitiveArrayValueWriter();

    @Override
    public boolean canWrite(Object value2) {
        return PrimitiveArrayValueWriter.isArrayish(value2) && PrimitiveArrayValueWriter.isArrayOfPrimitive(value2);
    }

    @Override
    public void write(Object o, WriterContext context) {
        Collection<?> values = this.normalize(o);
        context.write('[');
        context.writeArrayDelimiterPadding();
        boolean first2 = true;
        ValueWriter firstWriter = null;
        for (Object value2 : values) {
            if (first2) {
                firstWriter = ValueWriters.WRITERS.findWriterFor(value2);
                first2 = false;
            } else {
                ValueWriter writer = ValueWriters.WRITERS.findWriterFor(value2);
                if (writer != firstWriter) {
                    throw new IllegalStateException(context.getContextPath() + ": cannot write a heterogeneous array; first element was of type " + firstWriter + " but found " + writer);
                }
                context.write(", ");
            }
            ValueWriters.WRITERS.findWriterFor(value2).write(value2, context);
        }
        context.writeArrayDelimiterPadding();
        context.write(']');
    }

    private PrimitiveArrayValueWriter() {
    }

    public String toString() {
        return "primitive-array";
    }
}

