/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.types.semtype;

import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.BasicTypeCode;
import io.ballerina.runtime.api.types.semtype.Bdd;
import io.ballerina.runtime.api.types.semtype.BddAllOrNothing;
import io.ballerina.runtime.api.types.semtype.BddNode;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Env;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.SubType;
import io.ballerina.runtime.internal.types.semtype.AllOrNothing;
import io.ballerina.runtime.internal.types.semtype.BFutureSubType;
import io.ballerina.runtime.internal.types.semtype.BIntSubType;
import io.ballerina.runtime.internal.types.semtype.BListSubType;
import io.ballerina.runtime.internal.types.semtype.BMappingProj;
import io.ballerina.runtime.internal.types.semtype.BObjectSubType;
import io.ballerina.runtime.internal.types.semtype.BStreamSubType;
import io.ballerina.runtime.internal.types.semtype.BTableSubType;
import io.ballerina.runtime.internal.types.semtype.BTypedescSubType;
import io.ballerina.runtime.internal.types.semtype.CellAtomicType;
import io.ballerina.runtime.internal.types.semtype.DelegatedSubType;
import io.ballerina.runtime.internal.types.semtype.EnumerableSubtypeData;
import io.ballerina.runtime.internal.types.semtype.ListAtomicType;
import io.ballerina.runtime.internal.types.semtype.SubTypeData;
import io.ballerina.runtime.internal.types.semtype.SubtypePair;
import io.ballerina.runtime.internal.types.semtype.SubtypePairs;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;

public final class Core {
    private Core() {
    }

    public static SemType diff(SemType t110, SemType t22) {
        int all1 = t110.all();
        int all2 = t22.all();
        int some1 = t110.some();
        int some2 = t22.some();
        if (some1 == 0) {
            if (some2 == 0) {
                return Builder.getBasicTypeUnion(all1 & ~all2);
            }
            if (all1 == 0) {
                return t110;
            }
        } else if (some2 == 0 && all2 == 262143) {
            return Builder.getBasicTypeUnion(0);
        }
        int all = all1 & ~(all2 | some2);
        int some3 = (all1 | some1) & ~all2;
        if ((some3 &= ~all) == 0) {
            return SemType.from(all);
        }
        SubType[] subtypes = Builder.initializeSubtypeArray(some3);
        int i = 0;
        boolean filterNulls = false;
        for (SubtypePair pair : new SubtypePairs(t110, t22, some3)) {
            SubType data1 = pair.subType1();
            SubType data2 = pair.subType2();
            int code = pair.typeCode();
            SubType data3 = data1 == null ? data2.complement() : (data2 == null ? data1 : data1.diff(data2));
            if (data3.isAll()) {
                all |= 1 << code;
                some3 &= ~(1 << code);
                filterNulls = true;
                continue;
            }
            if (data3.isNothing()) {
                some3 &= ~(1 << code);
                filterNulls = true;
                continue;
            }
            subtypes[i] = data3;
            ++i;
        }
        return SemType.from(all, some3, filterNulls ? Core.filterNulls(some3, subtypes) : subtypes);
    }

    public static SubType getComplexSubtypeData(SemType t, BasicTypeCode code) {
        assert ((t.some() & 1 << code.code()) != 0);
        SubType subType = t.subTypeByCode(code.code());
        if (subType instanceof DelegatedSubType) {
            DelegatedSubType wrapper = (DelegatedSubType)((Object)subType);
            return wrapper.inner();
        }
        return subType;
    }

    public static SemType listMemberTypeInnerVal(Context cx, SemType t, SemType k) {
        if (t.some() == 0) {
            return (t.all() & Builder.getListType().all()) != 0 ? Builder.getValType() : Builder.getNeverType();
        }
        SubTypeData keyData = Core.intSubtype(k);
        if (Core.isNothingSubtype(keyData)) {
            return Builder.getNeverType();
        }
        return BListSubType.bddListMemberTypeInnerVal(cx, (Bdd)Core.getComplexSubtypeData(t, BasicTypeCode.BT_LIST), keyData, Builder.getValType());
    }

    public static SemType union(SemType t110, SemType t22) {
        assert (t110 != null && t22 != null);
        int all1 = t110.all();
        int some1 = t110.some();
        int all2 = t22.all();
        int some2 = t22.some();
        if (some1 == 0 && some2 == 0) {
            return Builder.getBasicTypeUnion(all1 | all2);
        }
        int all = all1 | all2;
        int some3 = (some1 | some2) & ~all;
        if (some3 == 0) {
            return Builder.getBasicTypeUnion(all);
        }
        SubType[] subtypes = Builder.initializeSubtypeArray(some3);
        int i = 0;
        boolean filterNulls = false;
        for (SubtypePair pair : new SubtypePairs(t110, t22, some3)) {
            int code = pair.typeCode();
            SubType data1 = pair.subType1();
            SubType data2 = pair.subType2();
            SubType data3 = data1 == null ? data2 : (data2 == null ? data1 : data1.union(data2));
            if (data3.isAll()) {
                filterNulls = true;
                all |= 1 << code;
                some3 &= ~(1 << code);
                continue;
            }
            subtypes[i] = data3;
            ++i;
        }
        if (some3 == 0) {
            return SemType.from(all);
        }
        return SemType.from(all, some3, filterNulls ? Core.filterNulls(some3, subtypes) : subtypes);
    }

    private static SubType[] filterNulls(int some2, SubType[] subtypes) {
        int newSize = Core.cardinality(some2);
        SubType[] filtered = new SubType[newSize];
        System.arraycopy(subtypes, 0, filtered, 0, newSize);
        return filtered;
    }

    public static SemType intersect(SemType t110, SemType t22) {
        assert (t110 != null && t22 != null);
        int all1 = t110.all();
        int some1 = t110.some();
        int all2 = t22.all();
        int some2 = t22.some();
        if (some1 == 0) {
            if (some2 == 0) {
                return SemType.from(all1 & all2);
            }
            if (all1 == 0) {
                return t110;
            }
            if (all1 == 262143) {
                return t22;
            }
        } else if (some2 == 0) {
            if (all2 == 0) {
                return t22;
            }
            if (all2 == 262143) {
                return t110;
            }
        }
        int all = all1 & all2;
        int some3 = (some1 | all1) & (some2 | all2);
        if ((some3 &= ~all) == 0) {
            return SemType.from(all);
        }
        SubType[] subtypes = Builder.initializeSubtypeArray(some3);
        int i = 0;
        boolean filterNulls = false;
        for (SubtypePair pair : new SubtypePairs(t110, t22, some3)) {
            int code = pair.typeCode();
            SubType data1 = pair.subType1();
            SubType data2 = pair.subType2();
            SubType data3 = data1 == null ? data2 : (data2 == null ? data1 : data1.intersect(data2));
            if (!data3.isNothing()) {
                subtypes[i] = data3;
                ++i;
                continue;
            }
            some3 &= ~(1 << code);
            filterNulls = true;
        }
        if (some3 == 0) {
            return SemType.from(all);
        }
        return SemType.from(all, some3, filterNulls ? Core.filterNulls(some3, subtypes) : subtypes);
    }

    public static boolean isEmpty(Context cx, SemType t) {
        if (t.some() == 0) {
            return t.all() == 0;
        }
        if (t.all() != 0) {
            return false;
        }
        for (SubType subType : t.subTypeData()) {
            assert (subType != null) : "subtype array must not be sparse";
            if (subType.isEmpty(cx)) continue;
            return false;
        }
        return true;
    }

    public static SemType complement(SemType t) {
        return Core.diff(Builder.getValType(), t);
    }

    public static boolean isNever(BasicTypeBitSet t) {
        return t.all() == 0;
    }

    public static boolean isNever(SemType t) {
        return t.all() == 0 && t.some() == 0;
    }

    public static boolean isSubType(Context cx, SemType t110, SemType t22) {
        return Core.isEmpty(cx, Core.diff(t110, t22));
    }

    public static boolean isSubtypeSimple(SemType t110, SemType t22) {
        assert (t110 != null && t22 != null);
        int bits = t110.all() | t110.some();
        return (bits & ~t22.all()) == 0;
    }

    public static boolean isNothingSubtype(SubTypeData data2) {
        return data2 == AllOrNothing.NOTHING;
    }

    public static SubTypeData intSubtype(SemType t) {
        return Core.subTypeData(t, BasicTypeCode.BT_INT);
    }

    public static SubTypeData stringSubtype(SemType t) {
        return Core.subTypeData(t, BasicTypeCode.BT_STRING);
    }

    public static SubTypeData subTypeData(SemType s, BasicTypeCode code) {
        if ((s.all() & 1 << code.code()) != 0) {
            return AllOrNothing.ALL;
        }
        if (s.some() == 0) {
            return AllOrNothing.NOTHING;
        }
        SubType subType = s.subTypeByCode(code.code());
        assert (subType != null);
        return subType.data();
    }

    public static boolean containsBasicType(BasicTypeBitSet t110, SemType t22) {
        int bits = t110.all();
        return (bits & t22.all()) != 0;
    }

    public static boolean containsBasicType(SemType t110, SemType t22) {
        int bits = t110.all() | t110.some();
        return (bits & t22.all()) != 0;
    }

    public static boolean isSameType(Context cx, SemType t110, SemType t22) {
        return Core.isSubType(cx, t110, t22) && Core.isSubType(cx, t22, t110);
    }

    private static int cardinality(int bitset) {
        return Integer.bitCount(bitset);
    }

    public static SemType getCellContainingInnerVal(Env env, SemType t) {
        CellAtomicType cat = Core.cellAtomicType(t).orElseThrow(() -> new IllegalArgumentException("t is not a cell semtype"));
        return Builder.getCellContaining(env, Core.diff(cat.ty(), Builder.getUndefType()), cat.mut());
    }

    public static SemType intersectCellMemberSemTypes(Env env, SemType t110, SemType t22) {
        CellAtomicType c1 = Core.cellAtomicType(t110).orElseThrow(() -> new IllegalArgumentException("t1 is not a cell semtype"));
        CellAtomicType c2 = Core.cellAtomicType(t22).orElseThrow(() -> new IllegalArgumentException("t2 is not a cell semtype"));
        CellAtomicType atomicType = CellAtomicType.intersectCellAtomicType(c1, c2);
        return Builder.getCellContaining(env, atomicType.ty(), Builder.getUndefType().equals(atomicType.ty()) ? CellAtomicType.CellMutability.CELL_MUT_NONE : atomicType.mut());
    }

    public static Optional<CellAtomicType> cellAtomicType(SemType t) {
        SemType cell = Builder.getCellType();
        if (t.some() == 0) {
            return cell.equals(t) ? Optional.of(Builder.cellAtomicVal()) : Optional.empty();
        }
        if (!Core.isSubtypeSimple(t, cell)) {
            return Optional.empty();
        }
        return Core.bddCellAtomicType((Bdd)Core.getComplexSubtypeData(t, BasicTypeCode.BT_CELL), Builder.cellAtomicVal());
    }

    private static Optional<CellAtomicType> bddCellAtomicType(Bdd bdd, CellAtomicType top) {
        if (bdd instanceof BddAllOrNothing) {
            BddAllOrNothing allOrNothing = (BddAllOrNothing)bdd;
            if (allOrNothing.isAll()) {
                return Optional.of(top);
            }
            return Optional.empty();
        }
        BddNode bddNode = (BddNode)bdd;
        return bddNode.isSimple() ? Optional.of(CellAtomicType.cellAtomType(bddNode.atom())) : Optional.empty();
    }

    public static SemType cellInnerVal(SemType t) {
        return Core.diff(Core.cellInner(t), Builder.getUndefType());
    }

    public static SemType cellInner(SemType t) {
        CellAtomicType cat = Core.cellAtomicType(t).orElseThrow(() -> new IllegalArgumentException("t is not a cell semtype"));
        return cat.ty();
    }

    public static SemType createBasicSemType(BasicTypeCode typeCode, Bdd bdd) {
        if (bdd instanceof BddAllOrNothing) {
            return bdd.isAll() ? Builder.from(typeCode) : Builder.getNeverType();
        }
        SubType subType = switch (typeCode.code()) {
            case 17 -> BObjectSubType.createDelegate(bdd);
            case 11 -> BFutureSubType.createDelegate(bdd);
            case 7 -> BTypedescSubType.createDelegate(bdd);
            case 15 -> BTableSubType.createDelegate(bdd);
            case 12 -> BStreamSubType.createDelegate(bdd);
            default -> throw new IllegalArgumentException("Unexpected type code: " + String.valueOf(typeCode));
        };
        return SemType.from(0, 1 << typeCode.code(), new SubType[]{subType});
    }

    public static SemType mappingMemberTypeInnerVal(Context cx, SemType t, SemType k) {
        return Core.diff(BMappingProj.mappingMemberTypeInner(cx, t, k), Builder.getUndefType());
    }

    public static Optional<ListAtomicType> listAtomicType(Context cx, SemType t) {
        ListAtomicType listAtomicInner = Builder.getListAtomicInner();
        if (t.some() == 0) {
            return Core.isSubtypeSimple(t, Builder.getListType()) ? Optional.ofNullable(listAtomicInner) : Optional.empty();
        }
        Env env = cx.env;
        if (!Core.isSubtypeSimple(t, Builder.getListType())) {
            return Optional.empty();
        }
        return Core.bddListAtomicType(env, (Bdd)Core.getComplexSubtypeData(t, BasicTypeCode.BT_LIST), listAtomicInner);
    }

    public static SemType floatToInt(SemType t) {
        if (!Core.containsBasicType(t, Builder.getFloatType())) {
            return Builder.getNeverType();
        }
        return Core.convertEnumerableNumericType(t, BasicTypeCode.BT_FLOAT, Builder.getIntType(), floatValue -> ((Double)floatValue).longValue(), Builder::getIntConst);
    }

    public static SemType floatToDecimal(SemType t) {
        if (!Core.containsBasicType(t, Builder.getFloatType())) {
            return Builder.getNeverType();
        }
        return Core.convertEnumerableNumericType(t, BasicTypeCode.BT_FLOAT, Builder.getDecimalType(), floatValue -> BigDecimal.valueOf((Double)floatValue), Builder::getDecimalConst);
    }

    public static SemType decimalToInt(SemType t) {
        if (!Core.containsBasicType(t, Builder.getDecimalType())) {
            return Builder.getNeverType();
        }
        return Core.convertEnumerableNumericType(t, BasicTypeCode.BT_DECIMAL, Builder.getIntType(), decimalVal -> ((BigDecimal)decimalVal).longValue(), Builder::getIntConst);
    }

    public static SemType decimalToFloat(SemType t) {
        if (!Core.containsBasicType(t, Builder.getDecimalType())) {
            return Builder.getNeverType();
        }
        return Core.convertEnumerableNumericType(t, BasicTypeCode.BT_DECIMAL, Builder.getFloatType(), decimalVal -> ((BigDecimal)decimalVal).doubleValue(), Builder::getFloatConst);
    }

    public static SemType intToFloat(SemType t) {
        if (!Core.containsBasicType(t, Builder.getIntType())) {
            return Builder.getNeverType();
        }
        SubTypeData subTypeData = Core.subTypeData(t, BasicTypeCode.BT_INT);
        if (subTypeData == AllOrNothing.NOTHING) {
            return Builder.getNeverType();
        }
        if (subTypeData == AllOrNothing.ALL) {
            return Builder.getFloatType();
        }
        BIntSubType.IntSubTypeData intSubTypeData = (BIntSubType.IntSubTypeData)subTypeData;
        return intSubTypeData.values().stream().map(Builder::getFloatConst).reduce(Builder.getNeverType(), Core::union);
    }

    public static SemType intToDecimal(SemType t) {
        if (!Core.containsBasicType(t, Builder.getIntType())) {
            return Builder.getNeverType();
        }
        SubTypeData subTypeData = Core.subTypeData(t, BasicTypeCode.BT_INT);
        if (subTypeData == AllOrNothing.NOTHING) {
            return Builder.getNeverType();
        }
        if (subTypeData == AllOrNothing.ALL) {
            return Builder.getDecimalType();
        }
        BIntSubType.IntSubTypeData intSubTypeData = (BIntSubType.IntSubTypeData)subTypeData;
        return intSubTypeData.values().stream().map(BigDecimal::new).map(Builder::getDecimalConst).reduce(Builder.getNeverType(), Core::union);
    }

    private static <E extends Comparable<E>, T extends Comparable<T>> SemType convertEnumerableNumericType(SemType source, BasicTypeCode targetTypeCode, SemType topType, Function<T, E> valueConverter, Function<E, SemType> semTypeCreator) {
        SubTypeData subTypeData = Core.subTypeData(source, targetTypeCode);
        if (subTypeData == AllOrNothing.NOTHING) {
            return Builder.getNeverType();
        }
        if (subTypeData == AllOrNothing.ALL) {
            return topType;
        }
        EnumerableSubtypeData enumerableSubtypeData = (EnumerableSubtypeData)((Object)subTypeData);
        SemType posType = Arrays.stream(enumerableSubtypeData.values()).map(valueConverter).distinct().map(semTypeCreator).reduce(Builder.getNeverType(), Core::union);
        if (enumerableSubtypeData.allowed()) {
            return posType;
        }
        return Core.diff(topType, posType);
    }

    private static Optional<ListAtomicType> bddListAtomicType(Env env, Bdd bdd, ListAtomicType top) {
        if (!(bdd instanceof BddNode)) {
            if (bdd.isAll()) {
                return Optional.ofNullable(top);
            }
            return Optional.empty();
        }
        BddNode bddNode = (BddNode)bdd;
        return bddNode.isSimple() ? Optional.of(env.listAtomType(bddNode.atom())) : Optional.empty();
    }
}

