/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.types.semtype;

import io.ballerina.runtime.api.types.semtype.Atom;
import java.util.concurrent.CountDownLatch;

public final class RecAtom
implements Atom {
    private final int index;
    private static final int BDD_REC_ATOM_READONLY = 0;
    private static final RecAtom ZERO = new RecAtom(0);
    private final CountDownLatch readySignal = new CountDownLatch(1);

    private RecAtom(int index) {
        this.index = index;
    }

    public static RecAtom createRecAtom(int index) {
        if (index == 0) {
            return ZERO;
        }
        return new RecAtom(index);
    }

    public static RecAtom createUnBlockedRecAtom(int index) {
        RecAtom rec = RecAtom.createRecAtom(index);
        rec.ready();
        return rec;
    }

    public static RecAtom createDistinctRecAtom(int index) {
        return new RecAtom(index);
    }

    @Override
    public int index() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RecAtom) {
            RecAtom recAtom = (RecAtom)o;
            return recAtom.index == this.index;
        }
        return false;
    }

    public int hashCode() {
        return this.index;
    }

    public void ready() {
        this.readySignal.countDown();
    }

    public void waitUntilReady() {
        try {
            this.readySignal.await();
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
        }
    }

    static {
        ZERO.ready();
    }
}

