/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.api.utils;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.JsonType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.StructureType;
import io.ballerina.runtime.api.types.TableType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BIterator;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BRefValue;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTable;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.commons.TypeValuePair;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.errors.ErrorHelper;
import io.ballerina.runtime.internal.errors.ErrorReasons;
import io.ballerina.runtime.internal.json.JsonGenerator;
import io.ballerina.runtime.internal.json.JsonInternalUtils;
import io.ballerina.runtime.internal.json.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class JsonUtils {
    private JsonUtils() {
    }

    public static Object parse(InputStream in) throws BError {
        return JsonParser.parse(in, (Type)PredefinedTypes.TYPE_JSON);
    }

    public static Object parse(InputStream in, String charsetName) throws BError {
        return JsonParser.parse(in, charsetName, PredefinedTypes.TYPE_JSON);
    }

    public static Object parse(BString jsonStr) throws BError {
        return JsonParser.parse(jsonStr.getValue());
    }

    public static Object parse(BString jsonStr, NonStringValueProcessingMode mode) throws BError {
        return JsonParser.parse((Reader)new StringReader(jsonStr.getValue()), mode);
    }

    public static Object parse(String jsonStr) throws BError {
        return JsonParser.parse(jsonStr);
    }

    public static Object parse(String jsonStr, NonStringValueProcessingMode mode) throws BError {
        return JsonParser.parse((Reader)new StringReader(jsonStr), mode);
    }

    public static Object parse(Reader reader, NonStringValueProcessingMode mode) throws BError {
        return JsonParser.parse(reader, mode);
    }

    public static Object parse(BTable<?, ?> bTable) {
        return JsonInternalUtils.toJSON(bTable);
    }

    public static Object parse(BArray bArray) {
        return JsonInternalUtils.convertArrayToJSON(bArray);
    }

    public static Object parse(BMap<BString, ?> map2, JsonType targetType) {
        return JsonInternalUtils.convertMapToJSON(map2, targetType);
    }

    public static BMap<BString, ?> convertJSONToMap(Object json2, MapType mapType) throws BError {
        return JsonInternalUtils.jsonToMap(json2, mapType);
    }

    public static BMap<BString, Object> convertJSONToRecord(Object record, StructureType structType) throws BError {
        return JsonInternalUtils.convertJSONToRecord(record, structType);
    }

    public static Object convertJSON(Object source, Type targetType) throws BError {
        return JsonInternalUtils.convertJSON(source, targetType);
    }

    public static Object convertUnionTypeToJSON(Object source, JsonType targetType) throws BError {
        return JsonInternalUtils.convertUnionTypeToJSON(source, targetType);
    }

    public static void serialize(Object json2, OutputStream out) throws BError {
        try (JsonGenerator gen2 = new JsonGenerator(out);){
            gen2.serialize(json2);
            gen2.flush();
        }
        catch (IOException e2) {
            throw ErrorCreator.createError(StringUtils.fromString(e2.getMessage()), e2);
        }
    }

    public static void serialize(Object json2, OutputStream out, Charset charset) throws BError {
        try (JsonGenerator gen2 = new JsonGenerator(out, charset);){
            gen2.serialize(json2);
            gen2.flush();
        }
        catch (IOException e2) {
            throw ErrorCreator.createError(StringUtils.fromString(e2.getMessage()), e2);
        }
    }

    public static void serialize(Object json2, Writer writer) throws BError {
        try (JsonGenerator gen2 = new JsonGenerator(writer);){
            gen2.serialize(json2);
            gen2.flush();
        }
        catch (IOException e2) {
            throw ErrorCreator.createError(StringUtils.fromString(e2.getMessage()), e2);
        }
    }

    public static Object convertToJson(Object value2) {
        return JsonUtils.convertToJsonType(value2, new ArrayList<TypeValuePair>());
    }

    @Deprecated(since="2201.6.0", forRemoval=true)
    public static Object convertToJson(Object value2, List<TypeValuePair> unresolvedValues) {
        return JsonUtils.convertToJsonType(value2, unresolvedValues);
    }

    private static Object convertToJsonType(Object value2, List<TypeValuePair> unresolvedValues) {
        JsonType jsonType = PredefinedTypes.TYPE_JSON;
        if (value2 == null) {
            return null;
        }
        Type sourceType = TypeChecker.getType(value2);
        if (TypeUtils.getImpliedType(sourceType).getTag() <= 6 && TypeChecker.checkIsType(value2, (Type)jsonType)) {
            return value2;
        }
        TypeValuePair typeValuePair = new TypeValuePair(value2, jsonType);
        if (unresolvedValues.contains(typeValuePair)) {
            throw JsonUtils.createCyclicValueReferenceError(value2);
        }
        unresolvedValues.add(typeValuePair);
        Object newValue = JsonUtils.getJsonObject(value2, unresolvedValues, jsonType, sourceType);
        unresolvedValues.remove(typeValuePair);
        return newValue;
    }

    private static Object getJsonObject(Object value2, List<TypeValuePair> unresolvedValues, Type jsonType, Type sourceType) {
        Object newValue;
        sourceType = TypeUtils.getImpliedType(sourceType);
        switch (sourceType.getTag()) {
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 54: {
                newValue = StringUtils.fromString(StringUtils.getStringValue(value2));
                break;
            }
            case 32: 
            case 44: {
                newValue = JsonUtils.convertArrayToJson((BArray)value2, unresolvedValues);
                break;
            }
            case 17: {
                BTable bTable = (BTable)value2;
                Type constrainedType = TypeUtils.getImpliedType(((TableType)sourceType).getConstrainedType());
                if (constrainedType.getTag() == 27) {
                    newValue = JsonUtils.convertMapConstrainedTableToJson((BTable)value2, unresolvedValues);
                    break;
                }
                try {
                    newValue = JsonInternalUtils.toJSON(bTable);
                    break;
                }
                catch (Exception e2) {
                    throw JsonUtils.createConversionError(value2, jsonType, e2.getMessage());
                }
            }
            case 24: 
            case 27: {
                newValue = JsonUtils.convertMapToJson((BMap)value2, unresolvedValues);
                break;
            }
            default: {
                throw JsonUtils.createConversionError(value2, jsonType);
            }
        }
        return newValue;
    }

    private static Object convertMapConstrainedTableToJson(BTable<?, ?> value2, List<TypeValuePair> unresolvedValues) {
        BArray membersArray = ValueCreator.createArrayValue(PredefinedTypes.TYPE_JSON_ARRAY);
        BIterator<?> itr = value2.getIterator();
        while (itr.hasNext()) {
            BArray tupleValue = (BArray)itr.next();
            BMap mapValue = (BMap)tupleValue.get(0L);
            Object member = JsonUtils.convertMapToJson(mapValue, unresolvedValues);
            membersArray.append(member);
        }
        return membersArray;
    }

    private static Object convertMapToJson(BMap<?, ?> map2, List<TypeValuePair> unresolvedValues) {
        BMap<BString, Object> newMap = ValueCreator.createMapValue(TypeCreator.createMapType(PredefinedTypes.TYPE_JSON));
        for (Map.Entry<?, ?> entry : map2.entrySet()) {
            Object newValue = JsonUtils.convertToJsonType(entry.getValue(), unresolvedValues);
            newMap.put(StringUtils.fromString(entry.getKey().toString()), newValue);
        }
        return newMap;
    }

    private static Object convertArrayToJson(BArray array2, List<TypeValuePair> unresolvedValues) {
        BArray newArray = ValueCreator.createArrayValue(PredefinedTypes.TYPE_JSON_ARRAY);
        for (int i = 0; i < array2.size(); ++i) {
            Object newValue = JsonUtils.convertToJsonType(array2.get(i), unresolvedValues);
            newArray.add((long)i, newValue);
        }
        return newArray;
    }

    private static BError createConversionError(Object inputValue, Type targetType) {
        return ErrorCreator.createError(ErrorReasons.VALUE_LANG_LIB_CONVERSION_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.INCOMPATIBLE_CONVERT_OPERATION, TypeChecker.getType(inputValue), targetType));
    }

    private static BError createConversionError(Object inputValue, Type targetType, String detailMessage) {
        return ErrorCreator.createError(ErrorReasons.VALUE_LANG_LIB_CONVERSION_ERROR, ErrorHelper.getErrorMessage(ErrorCodes.INCOMPATIBLE_CONVERT_OPERATION, TypeChecker.getType(inputValue), targetType).concat(StringUtils.fromString(": ".concat(detailMessage))));
    }

    private static BError createCyclicValueReferenceError(Object value2) {
        return ErrorCreator.createError(ErrorReasons.VALUE_LANG_LIB_CYCLIC_VALUE_REFERENCE_ERROR, ErrorHelper.getErrorDetails(ErrorCodes.CYCLIC_VALUE_REFERENCE, ((BRefValue)value2).getType()));
    }

    public static enum NonStringValueProcessingMode {
        FROM_JSON_STRING,
        FROM_JSON_FLOAT_STRING,
        FROM_JSON_DECIMAL_STRING;

    }
}

