/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.constants.RuntimeConstants;
import io.ballerina.runtime.api.flags.SymbolFlags;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.FunctionType;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.ReadonlyType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.TypeTags;
import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.types.semtype.BasicTypeBitSet;
import io.ballerina.runtime.api.types.semtype.Builder;
import io.ballerina.runtime.api.types.semtype.CacheableTypeDescriptor;
import io.ballerina.runtime.api.types.semtype.Context;
import io.ballerina.runtime.api.types.semtype.Core;
import io.ballerina.runtime.api.types.semtype.Env;
import io.ballerina.runtime.api.types.semtype.SemType;
import io.ballerina.runtime.api.types.semtype.ShapeAnalyzer;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BRefValue;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BValue;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.internal.TypeConverter;
import io.ballerina.runtime.internal.types.BAnnotatableType;
import io.ballerina.runtime.internal.types.BArrayType;
import io.ballerina.runtime.internal.types.BBooleanType;
import io.ballerina.runtime.internal.types.BFiniteType;
import io.ballerina.runtime.internal.types.BIntersectionType;
import io.ballerina.runtime.internal.types.BMapType;
import io.ballerina.runtime.internal.types.BObjectType;
import io.ballerina.runtime.internal.types.BRecordType;
import io.ballerina.runtime.internal.types.BTableType;
import io.ballerina.runtime.internal.types.BTupleType;
import io.ballerina.runtime.internal.types.BTypeReferenceType;
import io.ballerina.runtime.internal.types.BUnionType;
import io.ballerina.runtime.internal.types.TypeWithShape;
import io.ballerina.runtime.internal.utils.CloneUtils;
import io.ballerina.runtime.internal.utils.ErrorUtils;
import io.ballerina.runtime.internal.values.DecimalValue;
import io.ballerina.runtime.internal.values.DecimalValueKind;
import io.ballerina.runtime.internal.values.HandleValue;
import io.ballerina.runtime.internal.values.RefValue;
import io.ballerina.runtime.internal.values.RegExpValue;
import io.ballerina.runtime.internal.values.TypedescValue;
import io.ballerina.runtime.internal.values.TypedescValueImpl;
import io.ballerina.runtime.internal.values.ValuePair;
import io.ballerina.runtime.internal.values.XmlSequence;
import io.ballerina.runtime.internal.values.XmlValue;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;

public final class TypeChecker {
    private static final byte MAX_TYPECAST_ERROR_COUNT = 20;
    private static final String REG_EXP_TYPENAME = "RegExp";
    private static final ThreadLocal<Context> threadContext = ThreadLocal.withInitial(() -> Context.from(Env.getInstance()));

    public static Object checkCast(Object sourceVal, Type targetType) {
        if (TypeChecker.checkIsType(sourceVal, targetType)) {
            return sourceVal;
        }
        return TypeChecker.tryConvertibleCast(sourceVal, targetType);
    }

    private static Object tryConvertibleCast(Object sourceVal, Type targetType) {
        Type sourceType = TypeChecker.getType(sourceVal);
        if (TypeChecker.couldBelongToBasicType(sourceType.getBasicType(), ConvertibleCastMaskHolder.CONVERTIBLE_CAST_MASK) && TypeChecker.couldBelongToBasicType(targetType.getBasicType(), ConvertibleCastMaskHolder.CONVERTIBLE_CAST_MASK)) {
            if (targetType instanceof BUnionType) {
                BUnionType unionType = (BUnionType)targetType;
                for (Type memberType : unionType.getMemberTypes()) {
                    try {
                        return TypeConverter.castValues(memberType, sourceVal);
                    }
                    catch (Exception exception) {
                    }
                }
            } else {
                return TypeConverter.castValues(targetType, sourceVal);
            }
        }
        throw TypeChecker.createTypeCastError(sourceVal, targetType, List.of());
    }

    public static Context context() {
        return threadContext.get();
    }

    public static long anyToInt(Object sourceVal) {
        return TypeConverter.anyToIntCast(sourceVal, () -> ErrorUtils.createTypeCastError(sourceVal, PredefinedTypes.TYPE_INT));
    }

    public static long anyToSigned32(Object sourceVal) {
        return TypeConverter.anyToIntSubTypeCast(sourceVal, PredefinedTypes.TYPE_INT_SIGNED_32, () -> ErrorUtils.createTypeCastError(sourceVal, PredefinedTypes.TYPE_INT_SIGNED_32));
    }

    public static long anyToSigned16(Object sourceVal) {
        return TypeConverter.anyToIntSubTypeCast(sourceVal, PredefinedTypes.TYPE_INT_SIGNED_16, () -> ErrorUtils.createTypeCastError(sourceVal, PredefinedTypes.TYPE_INT_SIGNED_16));
    }

    public static long anyToSigned8(Object sourceVal) {
        return TypeConverter.anyToIntSubTypeCast(sourceVal, PredefinedTypes.TYPE_INT_SIGNED_8, () -> ErrorUtils.createTypeCastError(sourceVal, PredefinedTypes.TYPE_INT_SIGNED_8));
    }

    public static long anyToUnsigned32(Object sourceVal) {
        return TypeConverter.anyToIntSubTypeCast(sourceVal, PredefinedTypes.TYPE_INT_UNSIGNED_32, () -> ErrorUtils.createTypeCastError(sourceVal, PredefinedTypes.TYPE_INT_UNSIGNED_32));
    }

    public static long anyToUnsigned16(Object sourceVal) {
        return TypeConverter.anyToIntSubTypeCast(sourceVal, PredefinedTypes.TYPE_INT_UNSIGNED_16, () -> ErrorUtils.createTypeCastError(sourceVal, PredefinedTypes.TYPE_INT_UNSIGNED_16));
    }

    public static long anyToUnsigned8(Object sourceVal) {
        return TypeConverter.anyToIntSubTypeCast(sourceVal, PredefinedTypes.TYPE_INT_UNSIGNED_8, () -> ErrorUtils.createTypeCastError(sourceVal, PredefinedTypes.TYPE_INT_UNSIGNED_8));
    }

    public static double anyToFloat(Object sourceVal) {
        return TypeConverter.anyToFloatCast(sourceVal, () -> ErrorUtils.createTypeCastError(sourceVal, PredefinedTypes.TYPE_FLOAT));
    }

    public static boolean anyToBoolean(Object sourceVal) {
        return TypeConverter.anyToBooleanCast(sourceVal, () -> ErrorUtils.createTypeCastError(sourceVal, PredefinedTypes.TYPE_BOOLEAN));
    }

    public static int anyToByte(Object sourceVal) {
        return TypeConverter.anyToByteCast(sourceVal, () -> ErrorUtils.createTypeCastError(sourceVal, PredefinedTypes.TYPE_BYTE));
    }

    public static DecimalValue anyToDecimal(Object sourceVal) {
        return TypeConverter.anyToDecimalCast(sourceVal, () -> ErrorUtils.createTypeCastError(sourceVal, PredefinedTypes.TYPE_DECIMAL));
    }

    public static byte anyToJByte(Object sourceVal) {
        return TypeConverter.anyToJByteCast(sourceVal, () -> ErrorUtils.createBToJTypeCastError(sourceVal, "byte"));
    }

    public static char anyToJChar(Object sourceVal) {
        return TypeConverter.anyToJCharCast(sourceVal, () -> ErrorUtils.createBToJTypeCastError(sourceVal, "char"));
    }

    public static short anyToJShort(Object sourceVal) {
        return TypeConverter.anyToJShortCast(sourceVal, () -> ErrorUtils.createBToJTypeCastError(sourceVal, "short"));
    }

    public static int anyToJInt(Object sourceVal) {
        return TypeConverter.anyToJIntCast(sourceVal, () -> ErrorUtils.createBToJTypeCastError(sourceVal, "int"));
    }

    public static long anyToJLong(Object sourceVal) {
        return TypeConverter.anyToJLongCast(sourceVal, () -> ErrorUtils.createBToJTypeCastError(sourceVal, "long"));
    }

    public static float anyToJFloat(Object sourceVal) {
        return TypeConverter.anyToJFloatCast(sourceVal, () -> ErrorUtils.createBToJTypeCastError(sourceVal, "float"));
    }

    public static double anyToJDouble(Object sourceVal) {
        return TypeConverter.anyToJDoubleCast(sourceVal, () -> ErrorUtils.createBToJTypeCastError(sourceVal, "double"));
    }

    public static boolean anyToJBoolean(Object sourceVal) {
        return TypeConverter.anyToJBooleanCast(sourceVal, () -> ErrorUtils.createBToJTypeCastError(sourceVal, "boolean"));
    }

    public static boolean checkIsType(Object sourceVal, Type targetType) {
        if (!TypeChecker.couldBelongToType(sourceVal, targetType)) {
            return false;
        }
        Context cx = TypeChecker.context();
        Type sourceType = TypeChecker.getType(sourceVal);
        return TypeChecker.checkIsTypeInner(sourceVal, targetType, cx, sourceType);
    }

    private static boolean couldBelongToType(Type sourceType, Type targetType) {
        BasicTypeBitSet sourceBasicType = sourceType.getBasicType();
        BasicTypeBitSet targetBasicType = targetType.getBasicType();
        return TypeChecker.couldBelongToBasicType(sourceBasicType, targetBasicType);
    }

    private static boolean couldBelongToType(Object sourceVal, Type targetType) {
        BasicTypeBitSet valueBasicType = TypeChecker.getBasicType(sourceVal);
        BasicTypeBitSet targetBasicType = targetType.getBasicType();
        return TypeChecker.couldBelongToBasicType(valueBasicType, targetBasicType);
    }

    private static boolean couldBelongToBasicType(BasicTypeBitSet valueBasicType, BasicTypeBitSet targetBasicType) {
        return (valueBasicType.all() & targetBasicType.all()) != 0;
    }

    public static BasicTypeBitSet getBasicType(Object sourceVal) {
        if (sourceVal == null) {
            return Builder.getNilType();
        }
        Object object = sourceVal;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BValue.class, Double.class, Integer.class, Long.class, Byte.class, Boolean.class}, (Object)object2, n)) {
            case 0 -> {
                BValue bValue = (BValue)object2;
                yield bValue.getBasicType();
            }
            case 1 -> {
                Double ignored = (Double)object2;
                yield Builder.getFloatType();
            }
            case 2 -> {
                Integer ignored = (Integer)object2;
                yield Builder.getIntType();
            }
            case 3 -> {
                Long ignored = (Long)object2;
                yield Builder.getIntType();
            }
            case 4 -> {
                Byte ignored = (Byte)object2;
                yield Builder.getIntType();
            }
            case 5 -> {
                Boolean ignored = (Boolean)object2;
                yield Builder.getBooleanType();
            }
            default -> throw new IllegalArgumentException("unexpected value type");
        };
    }

    private static boolean checkIsTypeInner(Object sourceVal, Type targetType, Context cx, Type sourceType) {
        if (TypeChecker.isSubType(cx, sourceType, targetType)) {
            return true;
        }
        return !ShapeAnalyzer.canOptimizeInherentTypeCheck(cx, sourceType, targetType) && TypeChecker.isSubTypeWithInherentType(cx, sourceVal, SemType.tryInto(cx, targetType));
    }

    public static boolean checkIsType(List<String> errors2, Object sourceVal, Type sourceType, Type targetType) {
        return TypeChecker.checkIsType(sourceVal, targetType);
    }

    public static boolean checkIsLikeType(Object sourceValue, Type targetType) {
        return TypeChecker.checkIsLikeType(sourceValue, targetType, false);
    }

    public static boolean checkIsLikeType(Object sourceValue, Type targetType, boolean allowNumericConversion) {
        if (!allowNumericConversion && !TypeChecker.couldBelongToType(sourceValue, targetType)) {
            assert (!TypeChecker.shapeBelongToType(TypeChecker.context(), sourceValue, targetType, false));
            return false;
        }
        Context cx = TypeChecker.context();
        if (TypeChecker.canOptimizeShapeCheck(targetType) && TypeChecker.isSubType(cx, TypeChecker.getType(sourceValue), targetType)) {
            assert (TypeChecker.shapeBelongToType(cx, sourceValue, targetType, allowNumericConversion));
            return true;
        }
        return TypeChecker.shapeBelongToType(cx, sourceValue, targetType, allowNumericConversion);
    }

    private static boolean canOptimizeShapeCheck(Type type) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BMapType.class, BArrayType.class}, (Object)type3, n)) {
            case 0 -> {
                BMapType ignored = (BMapType)type3;
                yield true;
            }
            case 1 -> {
                BArrayType arrayType = (BArrayType)type3;
                if (arrayType.getDimensions() == -1) {
                    yield true;
                }
                yield false;
            }
            default -> !(type instanceof TypeWithShape);
        };
    }

    private static boolean shapeBelongToType(Context cx, Object sourceValue, Type targetType, boolean allowNumericConversion) {
        SemType shape = ShapeAnalyzer.shapeOf(cx, sourceValue).orElseThrow();
        SemType targetSemType = ShapeAnalyzer.acceptedTypeOf(cx, targetType);
        if (Core.isSubtypeSimple(shape, NumericTypeHolder.NUMERIC_TYPE) && allowNumericConversion) {
            targetSemType = TypeChecker.appendNumericConversionTypes(targetSemType);
        }
        return Core.isSubType(cx, shape, targetSemType);
    }

    private static SemType appendNumericConversionTypes(SemType semType) {
        SemType result = semType;
        if (Core.containsBasicType(semType, Builder.getIntType())) {
            result = Core.union(Core.union(Builder.getDecimalType(), Builder.getFloatType()), result);
        }
        result = Core.union(result, Core.floatToInt(semType));
        result = Core.union(result, Core.floatToDecimal(semType));
        result = Core.union(result, Core.decimalToInt(semType));
        result = Core.union(result, Core.decimalToFloat(semType));
        return result;
    }

    public static boolean isSameType(Type sourceType, Type targetType) {
        return sourceType == targetType || TypeChecker.checkIsType(sourceType, targetType) && TypeChecker.checkIsType(targetType, sourceType);
    }

    public static Type getType(Object value2) {
        Object object = value2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BObject.class, BValue.class, Number.class, Boolean.class}, (Object)object, n)) {
            case 0 -> {
                BObject bObject = (BObject)object;
                yield bObject.getOriginalType();
            }
            case 1 -> {
                BValue bValue = (BValue)object;
                yield bValue.getType();
            }
            case -1 -> PredefinedTypes.TYPE_NULL;
            case 2 -> {
                Number number = (Number)object;
                yield TypeChecker.getNumberType(number);
            }
            case 3 -> {
                Boolean booleanValue = (Boolean)object;
                yield BBooleanType.singletonType(booleanValue);
            }
            default -> throw new IllegalArgumentException("unexpected value type");
        };
    }

    private static Type getNumberType(Number number) {
        Number number2 = number;
        Objects.requireNonNull(number2);
        Number number3 = number2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Double.class, Integer.class, Byte.class}, (Object)number3, n)) {
            case 0 -> {
                Double ignored = (Double)number3;
                yield PredefinedTypes.TYPE_FLOAT;
            }
            case 1 -> {
                Integer ignored = (Integer)number3;
                yield PredefinedTypes.TYPE_BYTE;
            }
            case 2 -> {
                Byte ignored = (Byte)number3;
                yield PredefinedTypes.TYPE_BYTE;
            }
            default -> PredefinedTypes.TYPE_INT;
        };
    }

    public static boolean isEqual(Object lhsValue, Object rhsValue) {
        return TypeChecker.isEqual(lhsValue, rhsValue, new HashSet<ValuePair>());
    }

    public static boolean checkDecimalExactEqual(DecimalValue lhsValue, DecimalValue rhsValue) {
        return TypeChecker.isDecimalRealNumber(lhsValue) && TypeChecker.isDecimalRealNumber(rhsValue) && lhsValue.decimalValue().equals(rhsValue.decimalValue());
    }

    static boolean isDecimalRealNumber(DecimalValue decimalValue) {
        return decimalValue.valueKind == DecimalValueKind.ZERO || decimalValue.valueKind == DecimalValueKind.OTHER;
    }

    public static boolean isReferenceEqual(Object lhsValue, Object rhsValue) {
        if (lhsValue == rhsValue) {
            return true;
        }
        if (lhsValue == null || rhsValue == null) {
            return false;
        }
        Context cx = TypeChecker.context();
        SemType lhsType = TypeChecker.widenedType(cx, lhsValue);
        SemType rhsType = TypeChecker.widenedType(cx, rhsValue);
        if (TypeChecker.isSimpleBasicSemType(lhsType)) {
            return TypeChecker.isSimpleBasicValuesEqual(cx, lhsValue, rhsValue);
        }
        Predicate<SemType> basicTypePredicate = basicType -> Core.isSubtypeSimple(lhsType, basicType) && Core.isSubtypeSimple(rhsType, basicType);
        if (basicTypePredicate.test(Builder.getStringType())) {
            return TypeChecker.isEqual(lhsValue, rhsValue);
        }
        if (basicTypePredicate.test(Builder.getXmlType())) {
            return TypeChecker.isXMLValueRefEqual((XmlValue)lhsValue, (XmlValue)rhsValue);
        }
        if (basicTypePredicate.test(Builder.getHandleType())) {
            return TypeChecker.isHandleValueRefEqual(lhsValue, rhsValue);
        }
        if (basicTypePredicate.test(Builder.getFunctionType())) {
            return TypeChecker.isFunctionPointerEqual(TypeUtils.getImpliedType(TypeChecker.getType(lhsValue)), TypeUtils.getImpliedType(TypeChecker.getType(rhsValue)));
        }
        if (basicTypePredicate.test(Builder.getRegexType())) {
            RegExpValue lhsReg = (RegExpValue)lhsValue;
            RegExpValue rhsReg = (RegExpValue)rhsValue;
            return lhsReg.equals(rhsReg, new HashSet<ValuePair>());
        }
        return false;
    }

    static boolean isXMLValueRefEqual(XmlValue lhsValue, XmlValue rhsValue) {
        boolean isRhsXmlSequence;
        boolean isLhsXmlSequence = lhsValue.getNodeType() == XmlNodeType.SEQUENCE;
        boolean bl = isRhsXmlSequence = rhsValue.getNodeType() == XmlNodeType.SEQUENCE;
        if (isLhsXmlSequence && isRhsXmlSequence) {
            return TypeChecker.isXMLSequenceRefEqual((XmlSequence)lhsValue, (XmlSequence)rhsValue);
        }
        if (isLhsXmlSequence && lhsValue.isSingleton()) {
            return ((XmlSequence)lhsValue).getChildrenList().get(0) == rhsValue;
        }
        if (isRhsXmlSequence && rhsValue.isSingleton()) {
            return ((XmlSequence)rhsValue).getChildrenList().get(0) == lhsValue;
        }
        if (lhsValue.getNodeType() != rhsValue.getNodeType()) {
            return false;
        }
        if (lhsValue.getNodeType() == XmlNodeType.TEXT && rhsValue.getNodeType() == XmlNodeType.TEXT) {
            return TypeChecker.isEqual(lhsValue, rhsValue);
        }
        return false;
    }

    private static boolean isXMLSequenceRefEqual(XmlSequence lhsValue, XmlSequence rhsValue) {
        Iterator<BXml> lhsIter = lhsValue.getChildrenList().iterator();
        Iterator<BXml> rhsIter = rhsValue.getChildrenList().iterator();
        while (lhsIter.hasNext() && rhsIter.hasNext()) {
            BXml r2;
            BXml l = lhsIter.next();
            if (l == (r2 = rhsIter.next()) || TypeChecker.isXMLValueRefEqual((XmlValue)l, (XmlValue)r2)) continue;
            return false;
        }
        return lhsIter.hasNext() == rhsIter.hasNext();
    }

    private static boolean isFunctionPointerEqual(Type lhsType, Type rhsType) {
        return lhsType.getPackage().equals(rhsType.getPackage()) && lhsType.getName().equals(rhsType.getName()) && rhsType.equals(lhsType);
    }

    private static boolean isSimpleBasicValuesEqual(Context cx, Object v1, Object v2) {
        SemType v1Ty = TypeChecker.widenedType(cx, v1);
        if (!TypeChecker.isSimpleBasicSemType(v1Ty)) {
            return false;
        }
        SemType v2Ty = TypeChecker.widenedType(cx, v2);
        if (!TypeChecker.isSimpleBasicSemType(v2Ty)) {
            return false;
        }
        if (!Core.isSameType(cx, v1Ty, v2Ty)) {
            return false;
        }
        if (Core.isSubtypeSimple(v1Ty, Builder.getDecimalType())) {
            return TypeChecker.checkDecimalExactEqual((DecimalValue)v1, (DecimalValue)v2);
        }
        if (Core.isSubtypeSimple(v1Ty, Builder.getIntType())) {
            Number n1 = (Number)v1;
            Number n2 = (Number)v2;
            return n1.longValue() == n2.longValue();
        }
        return v1.equals(v2);
    }

    public static TypedescValue getTypedesc(Object value2) {
        Type type = TypeChecker.getType(value2);
        if (type == null) {
            return null;
        }
        Context cx = TypeChecker.context();
        if (TypeChecker.belongToSingleBasicTypeOrString(cx, type)) {
            return new TypedescValueImpl(new BFiniteType(value2.toString(), Set.of(value2), 0));
        }
        if (value2 instanceof BRefValue) {
            BRefValue bRefValue = (BRefValue)value2;
            return (TypedescValue)bRefValue.getTypedesc();
        }
        return new TypedescValueImpl(type);
    }

    public static Object getAnnotValue(TypedescValue typedescValue, BString annotTag) {
        Type describingType = typedescValue.getDescribingType();
        if (!(describingType instanceof BAnnotatableType)) {
            return null;
        }
        BAnnotatableType annotatableType = (BAnnotatableType)describingType;
        return annotatableType.getAnnotation(annotTag);
    }

    public static boolean checkIsType(Type sourceType, Type targetType) {
        if (!TypeChecker.couldBelongToType(sourceType, targetType)) {
            return false;
        }
        Context cx = TypeChecker.context();
        return TypeChecker.isSubType(cx, sourceType, targetType);
    }

    @Deprecated
    public static boolean checkIsType(Type sourceType, Type targetType, List<TypePair> unresolvedTypes) {
        if (!TypeChecker.couldBelongToType(sourceType, targetType)) {
            return false;
        }
        Context cx = TypeChecker.context();
        return TypeChecker.isSubType(cx, sourceType, targetType);
    }

    public static boolean checkDecimalEqual(DecimalValue lhsValue, DecimalValue rhsValue) {
        return TypeChecker.isDecimalRealNumber(lhsValue) && TypeChecker.isDecimalRealNumber(rhsValue) && lhsValue.decimalValue().compareTo(rhsValue.decimalValue()) == 0;
    }

    public static boolean isNumericType(Type type) {
        return TypeChecker.couldBelongToBasicType(type.getBasicType(), NumericTypeHolder.NUMERIC_TYPE) && TypeChecker.isNumericInner(type);
    }

    private static boolean isNumericInner(Type type) {
        Context cx = TypeChecker.context();
        return Core.isSubtypeSimple(SemType.tryInto(cx, type), NumericTypeHolder.NUMERIC_TYPE);
    }

    public static boolean isByteLiteral(long longValue) {
        return longValue >= (long)RuntimeConstants.BBYTE_MIN_VALUE.intValue() && longValue <= (long)RuntimeConstants.BBYTE_MAX_VALUE.intValue();
    }

    private static boolean isSubTypeWithInherentType(Context cx, Object sourceValue, SemType target) {
        return ShapeAnalyzer.inherentTypeOf(cx, sourceValue).map(source -> !Core.isEmpty(cx, source) && Core.isSubType(cx, source, target)).orElse(false);
    }

    private static boolean isSubType(Context cx, Type source, Type target) {
        if (source instanceof CacheableTypeDescriptor) {
            CacheableTypeDescriptor sourceCacheableType = (CacheableTypeDescriptor)source;
            if (target instanceof CacheableTypeDescriptor) {
                CacheableTypeDescriptor targetCacheableType = (CacheableTypeDescriptor)target;
                if (sourceCacheableType.typeId() == targetCacheableType.typeId()) {
                    return true;
                }
                return TypeChecker.isSubTypeWithCache(cx, sourceCacheableType, targetCacheableType);
            }
        }
        return TypeChecker.isSubTypeInner(cx, source, target);
    }

    private static boolean isSubTypeInner(Context cx, Type source, Type target) {
        SemType sourceSemType = SemType.tryInto(cx, source);
        SemType targetSemType = SemType.tryInto(cx, target);
        return Core.isSubType(cx, sourceSemType, targetSemType);
    }

    private static boolean isSubTypeWithCache(Context cx, CacheableTypeDescriptor source, CacheableTypeDescriptor target) {
        Boolean cachedResult = source.cachedTypeCheckResult(cx, target);
        if (cachedResult != null) {
            assert (cachedResult == TypeChecker.isSubTypeInner(cx, source, target));
            return cachedResult;
        }
        boolean result = TypeChecker.isSubTypeInner(cx, source, target);
        source.cacheTypeCheckResult(target, result);
        return result;
    }

    private static SemType widenedType(Context cx, Object value2) {
        if (value2 instanceof BValue) {
            BValue bValue = (BValue)value2;
            return bValue.widenedType(cx);
        }
        if (value2 == null) {
            return Builder.getNilType();
        }
        if (value2 instanceof Double) {
            return Builder.getFloatType();
        }
        if (value2 instanceof Number) {
            return Builder.getIntType();
        }
        if (value2 instanceof BString) {
            return Builder.getStringType();
        }
        if (value2 instanceof Boolean) {
            return Builder.getBooleanType();
        }
        throw new IllegalArgumentException("Unexpected object type");
    }

    public static boolean isInherentlyImmutableType(Type sourceType) {
        if (sourceType instanceof ReadonlyType) {
            return true;
        }
        BasicTypeBitSet sourceBitSet = sourceType.getBasicType();
        if (!TypeChecker.couldBelongToBasicType(sourceBitSet, InherentlyImmutableTypeHolder.POTENTIALLY_INHERENTLY_IMMUTABLE_TYPE)) {
            return Core.isNever(sourceBitSet);
        }
        Context cx = TypeChecker.context();
        return Core.isSubtypeSimple(SemType.tryInto(cx, sourceType), InherentlyImmutableTypeHolder.INHERENTLY_IMMUTABLE_TYPE);
    }

    public static boolean isSelectivelyImmutableType(Type type, Set<Type> unresolvedTypes) {
        if (!unresolvedTypes.add(type)) {
            return true;
        }
        switch (type.getTag()) {
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 23: 
            case 29: 
            case 51: {
                return true;
            }
            case 32: {
                Type elementType = ((BArrayType)type).getElementType();
                return TypeChecker.isInherentlyImmutableType(elementType) || TypeChecker.isSelectivelyImmutableType(elementType, unresolvedTypes);
            }
            case 44: {
                BTupleType tupleType = (BTupleType)type;
                for (Type tupMemType : tupleType.getTupleTypes()) {
                    if (TypeChecker.isInherentlyImmutableType(tupMemType) || TypeChecker.isSelectivelyImmutableType(tupMemType, unresolvedTypes)) continue;
                    return false;
                }
                Type tupRestType = tupleType.getRestType();
                if (tupRestType == null) {
                    return true;
                }
                return TypeChecker.isInherentlyImmutableType(tupRestType) || TypeChecker.isSelectivelyImmutableType(tupRestType, unresolvedTypes);
            }
            case 24: {
                BRecordType recordType = (BRecordType)type;
                for (Field field : recordType.getFields().values()) {
                    Type fieldType = field.getFieldType();
                    if (TypeChecker.isInherentlyImmutableType(fieldType) || TypeChecker.isSelectivelyImmutableType(fieldType, unresolvedTypes)) continue;
                    return false;
                }
                Type recordRestType = recordType.restFieldType;
                if (recordRestType == null) {
                    return true;
                }
                return TypeChecker.isInherentlyImmutableType(recordRestType) || TypeChecker.isSelectivelyImmutableType(recordRestType, unresolvedTypes);
            }
            case 47: {
                BObjectType objectType = (BObjectType)type;
                if (SymbolFlags.isFlagOn(objectType.flags, 0x10000000L) && !SymbolFlags.isFlagOn(objectType.flags, 32L)) {
                    return false;
                }
                for (Field field : objectType.getFields().values()) {
                    Type fieldType = field.getFieldType();
                    if (TypeChecker.isInherentlyImmutableType(fieldType) || TypeChecker.isSelectivelyImmutableType(fieldType, unresolvedTypes)) continue;
                    return false;
                }
                return true;
            }
            case 27: {
                Type constraintType = ((MapType)type).getConstrainedType();
                return TypeChecker.isInherentlyImmutableType(constraintType) || TypeChecker.isSelectivelyImmutableType(constraintType, unresolvedTypes);
            }
            case 17: {
                Type tableConstraintType = ((BTableType)type).getConstrainedType();
                return TypeChecker.isInherentlyImmutableType(tableConstraintType) || TypeChecker.isSelectivelyImmutableType(tableConstraintType, unresolvedTypes);
            }
            case 33: {
                boolean readonlyIntersectionExists = false;
                for (Type memberType : ((BUnionType)type).getMemberTypes()) {
                    if (!TypeChecker.isInherentlyImmutableType(memberType) && !TypeChecker.isSelectivelyImmutableType(memberType, unresolvedTypes)) continue;
                    readonlyIntersectionExists = true;
                    break;
                }
                return readonlyIntersectionExists;
            }
            case 34: {
                return TypeChecker.isSelectivelyImmutableType(((BIntersectionType)type).getEffectiveType(), unresolvedTypes);
            }
            case 53: {
                return TypeChecker.isSelectivelyImmutableType(((BTypeReferenceType)type).getReferredType(), unresolvedTypes);
            }
        }
        return false;
    }

    static boolean isSigned32LiteralValue(Long longObject) {
        return longObject >= (long)RuntimeConstants.SIGNED32_MIN_VALUE.intValue() && longObject <= (long)RuntimeConstants.SIGNED32_MAX_VALUE.intValue();
    }

    static boolean isSigned16LiteralValue(Long longObject) {
        return longObject.intValue() >= RuntimeConstants.SIGNED16_MIN_VALUE && longObject.intValue() <= RuntimeConstants.SIGNED16_MAX_VALUE;
    }

    static boolean isSigned8LiteralValue(Long longObject) {
        return longObject.intValue() >= RuntimeConstants.SIGNED8_MIN_VALUE && longObject.intValue() <= RuntimeConstants.SIGNED8_MAX_VALUE;
    }

    static boolean isUnsigned32LiteralValue(Long longObject) {
        return longObject >= 0L && longObject <= RuntimeConstants.UNSIGNED32_MAX_VALUE;
    }

    static boolean isUnsigned16LiteralValue(Long longObject) {
        return longObject.intValue() >= 0 && longObject.intValue() <= RuntimeConstants.UNSIGNED16_MAX_VALUE;
    }

    static boolean isUnsigned8LiteralValue(Long longObject) {
        return longObject.intValue() >= 0 && longObject.intValue() <= RuntimeConstants.UNSIGNED8_MAX_VALUE;
    }

    static boolean isCharLiteralValue(Object object) {
        String value2;
        if (object instanceof BString) {
            value2 = ((BString)object).getValue();
        } else if (object instanceof String) {
            value2 = (String)object;
        } else {
            return false;
        }
        return value2.codePoints().count() == 1L;
    }

    public static boolean isEqual(Object lhsValue, Object rhsValue, Set<ValuePair> checkedValues) {
        if (lhsValue == rhsValue) {
            return true;
        }
        if (null == lhsValue || null == rhsValue) {
            return false;
        }
        return TypeChecker.checkValueEqual(TypeChecker.context(), lhsValue, rhsValue, new HashSet<ValuePair>(checkedValues));
    }

    private static boolean checkValueEqual(Context cx, Object lhsValue, Object rhsValue, Set<ValuePair> checkedValues) {
        SemType rhsShape;
        SemType lhsShape = ShapeAnalyzer.inherentTypeOf(cx, lhsValue).orElseThrow();
        Predicate<SemType> belongToSameBasicType = arg_0 -> TypeChecker.lambda$checkValueEqual$22(lhsShape, rhsShape = ShapeAnalyzer.inherentTypeOf(cx, rhsValue).orElseThrow(), arg_0);
        if (belongToSameBasicType.test(Builder.getStringType()) || belongToSameBasicType.test(Builder.getBooleanType())) {
            return lhsValue.equals(rhsValue);
        }
        if (belongToSameBasicType.test(Builder.getIntType())) {
            return ((Number)lhsValue).longValue() == ((Number)rhsValue).longValue();
        }
        if (belongToSameBasicType.test(Builder.getFloatType())) {
            Double lhs = (Double)lhsValue;
            Double rhs = (Double)rhsValue;
            return Double.isNaN(lhs) && Double.isNaN(rhs) || lhs.doubleValue() == rhs.doubleValue();
        }
        if (belongToSameBasicType.test(Builder.getDecimalType())) {
            return TypeChecker.checkDecimalEqual((DecimalValue)lhsValue, (DecimalValue)rhsValue);
        }
        if (belongToSameBasicType.test(RefValueTypeMaskHolder.REF_TYPE_MASK)) {
            RefValue lhs = (RefValue)lhsValue;
            return lhs.equals(rhsValue, checkedValues);
        }
        return false;
    }

    public static boolean isRegExpType(Type targetType) {
        if (targetType.getTag() == 53) {
            Type referredType = ((BTypeReferenceType)targetType).getReferredType();
            Module referredTypePackage = referredType.getPackage();
            if (referredTypePackage != null && "ballerina".equals(referredTypePackage.getOrg()) && "lang.regexp".equals(referredTypePackage.getName()) && REG_EXP_TYPENAME.equals(referredType.getName())) {
                return true;
            }
            return TypeChecker.isRegExpType(referredType);
        }
        return false;
    }

    static boolean isStructuredType(Type type) {
        Type referredType = TypeUtils.getImpliedType(type);
        return switch (referredType.getTag()) {
            case 17, 24, 27, 32, 44 -> true;
            default -> false;
        };
    }

    static boolean isFiniteTypeValue(Object sourceValue, Type sourceType, Object valueSpaceItem, boolean allowNumericConversion) {
        Type valueSpaceItemType = TypeChecker.getType(valueSpaceItem);
        int sourceTypeTag = TypeUtils.getImpliedType(sourceType).getTag();
        int valueSpaceItemTypeTag = TypeUtils.getImpliedType(valueSpaceItemType).getTag();
        if (valueSpaceItemTypeTag > 4) {
            return valueSpaceItemTypeTag == sourceTypeTag && (valueSpaceItem == sourceValue || valueSpaceItem.equals(sourceValue));
        }
        switch (sourceTypeTag) {
            case 1: 
            case 2: {
                switch (valueSpaceItemTypeTag) {
                    case 1: 
                    case 2: {
                        return ((Number)sourceValue).longValue() == ((Number)valueSpaceItem).longValue();
                    }
                    case 3: {
                        return ((Number)sourceValue).longValue() == ((Number)valueSpaceItem).longValue() && allowNumericConversion;
                    }
                    case 4: {
                        return ((Number)sourceValue).longValue() == ((DecimalValue)valueSpaceItem).intValue() && allowNumericConversion;
                    }
                }
            }
            case 3: {
                switch (valueSpaceItemTypeTag) {
                    case 1: 
                    case 2: {
                        return ((Number)sourceValue).doubleValue() == ((Number)valueSpaceItem).doubleValue() && allowNumericConversion;
                    }
                    case 3: {
                        return ((Number)sourceValue).doubleValue() == ((Number)valueSpaceItem).doubleValue() || Double.isNaN((Double)sourceValue) && Double.isNaN((Double)valueSpaceItem);
                    }
                    case 4: {
                        return ((Number)sourceValue).doubleValue() == ((DecimalValue)valueSpaceItem).floatValue() && allowNumericConversion;
                    }
                }
            }
            case 4: {
                switch (valueSpaceItemTypeTag) {
                    case 1: 
                    case 2: {
                        return TypeChecker.checkDecimalEqual((DecimalValue)sourceValue, DecimalValue.valueOf(((Number)valueSpaceItem).longValue())) && allowNumericConversion;
                    }
                    case 3: {
                        return TypeChecker.checkDecimalEqual((DecimalValue)sourceValue, DecimalValue.valueOf(((Number)valueSpaceItem).doubleValue())) && allowNumericConversion;
                    }
                    case 4: {
                        return TypeChecker.checkDecimalEqual((DecimalValue)sourceValue, (DecimalValue)valueSpaceItem);
                    }
                }
            }
        }
        if (sourceTypeTag != valueSpaceItemTypeTag) {
            return false;
        }
        return valueSpaceItem.equals(sourceValue);
    }

    public static Env getEnv() {
        return Env.getInstance();
    }

    private static boolean isHandleValueRefEqual(Object lhsValue, Object rhsValue) {
        HandleValue lhsHandle = (HandleValue)lhsValue;
        HandleValue rhsHandle = (HandleValue)rhsValue;
        return lhsHandle.getValue() == rhsHandle.getValue();
    }

    public static boolean hasFillerValue(Type type) {
        return TypeChecker.hasFillerValue(TypeChecker.context(), type, new ArrayList<Type>());
    }

    private static FillerValueResult hasFillerValueSemType(BasicTypeBitSet type) {
        if (Core.containsBasicType(type, Builder.getNilType())) {
            return FillerValueResult.TRUE;
        }
        if (Integer.bitCount(type.all()) > 1) {
            return FillerValueResult.FALSE;
        }
        return FillerValueResult.MAYBE;
    }

    private static boolean hasFillerValue(Context cx, Type type, List<Type> unanalyzedTypes) {
        if (type == null) {
            return true;
        }
        FillerValueResult fastResult = TypeChecker.hasFillerValueSemType(type.getBasicType());
        if (fastResult != FillerValueResult.MAYBE) {
            return fastResult == FillerValueResult.TRUE;
        }
        return TypeChecker.hasFillerValueWithDefaultValues(cx, type, unanalyzedTypes);
    }

    private static boolean hasFillerValueWithDefaultValues(Context cx, Type type, List<Type> unanalyzedTypes) {
        int typeTag = type.getTag();
        if (TypeTags.isXMLTypeTag(typeTag)) {
            return typeTag == 16 || typeTag == 21;
        }
        if (typeTag < 24 && typeTag != 13 && typeTag != 22) {
            return true;
        }
        return switch (typeTag) {
            case 26, 27, 29 -> true;
            case 32 -> TypeChecker.checkFillerValue(cx, (BArrayType)type, unanalyzedTypes);
            case 46 -> TypeChecker.checkFillerValue((BFiniteType)type);
            case 31, 47 -> TypeChecker.checkFillerValue(cx, (BObjectType)type);
            case 24 -> TypeChecker.checkFillerValue(cx, (BRecordType)type, unanalyzedTypes);
            case 44 -> TypeChecker.checkFillerValue(cx, (BTupleType)type, unanalyzedTypes);
            case 33 -> TypeChecker.checkFillerValue((BUnionType)type, unanalyzedTypes);
            case 53 -> TypeChecker.hasFillerValue(cx, ((BTypeReferenceType)type).getReferredType(), unanalyzedTypes);
            case 34 -> TypeChecker.hasFillerValue(cx, ((BIntersectionType)type).getEffectiveType(), unanalyzedTypes);
            default -> false;
        };
    }

    private static boolean checkFillerValue(Context cx, BTupleType tupleType, List<Type> unAnalyzedTypes) {
        if (unAnalyzedTypes.contains(tupleType)) {
            return true;
        }
        unAnalyzedTypes.add(tupleType);
        return TypeChecker.checkMemberFillerValue(cx, tupleType, unAnalyzedTypes);
    }

    private static boolean checkMemberFillerValue(Context cx, BTupleType tupleType, List<Type> unAnalyzedTypes) {
        for (Type member : tupleType.getTupleTypes()) {
            if (TypeChecker.hasFillerValue(cx, member, unAnalyzedTypes)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkFillerValue(BUnionType type, List<Type> unAnalyzedTypes) {
        if (unAnalyzedTypes.contains(type)) {
            return true;
        }
        unAnalyzedTypes.add(type);
        if (type.isNullable()) {
            return true;
        }
        return TypeChecker.isSameBasicTypeWithFillerValue(type.getMemberTypes());
    }

    private static boolean isSameBasicTypeWithFillerValue(List<Type> memberTypes) {
        ArrayList<Type> nonFiniteTypes = new ArrayList<Type>();
        HashSet<Object> combinedValueSpace = new HashSet<Object>();
        for (Type memberType : memberTypes) {
            Type referredType = TypeUtils.getImpliedType(memberType);
            if (referredType.getTag() == 46) {
                combinedValueSpace.addAll(((BFiniteType)referredType).getValueSpace());
                continue;
            }
            nonFiniteTypes.add(referredType);
        }
        if (nonFiniteTypes.isEmpty()) {
            return TypeChecker.hasFillerValueInValueSpace(combinedValueSpace);
        }
        Iterator iterator2 = nonFiniteTypes.iterator();
        Type firstMember = (Type)iterator2.next();
        while (iterator2.hasNext()) {
            Type nextMember = (Type)iterator2.next();
            if (TypeChecker.isSameBasicType(firstMember, nextMember)) continue;
            return false;
        }
        if (combinedValueSpace.isEmpty()) {
            return TypeChecker.hasFillerValue(firstMember);
        }
        if (!TypeChecker.containsSameBasicType(firstMember, combinedValueSpace)) {
            return false;
        }
        if (TypeChecker.hasFillerValue(firstMember)) {
            return true;
        }
        return combinedValueSpace.size() == 1 ? TypeChecker.isFillerValueOfFiniteTypeBasicType(combinedValueSpace.iterator().next()) : TypeChecker.hasFillerValueInValueSpace(combinedValueSpace);
    }

    private static boolean isSameBasicType(Type sourceType, Type targetType) {
        if (TypeChecker.isSameType(sourceType, targetType)) {
            return true;
        }
        int sourceTag = TypeUtils.getImpliedType(sourceType).getTag();
        int targetTag = TypeUtils.getImpliedType(targetType).getTag();
        if (TypeTags.isStringTypeTag(sourceTag) && TypeTags.isStringTypeTag(targetTag)) {
            return true;
        }
        if (TypeTags.isXMLTypeTag(sourceTag) && TypeTags.isXMLTypeTag(targetTag)) {
            return true;
        }
        return TypeChecker.isIntegerSubTypeTag(sourceTag) && TypeChecker.isIntegerSubTypeTag(targetTag);
    }

    private static boolean isIntegerSubTypeTag(int typeTag) {
        return TypeTags.isIntegerTypeTag(typeTag);
    }

    private static boolean isFillerValueOfFiniteTypeBasicType(Object value2) {
        return switch (value2.toString()) {
            case "0", "0.0", "false", "" -> true;
            default -> false;
        };
    }

    private static boolean containsSameBasicType(Type nonFiniteType, Set<Object> finiteTypeValueSpace) {
        for (Object value2 : finiteTypeValueSpace) {
            if (TypeChecker.isSameBasicType(TypeChecker.getType(value2), nonFiniteType)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkFillerValue(Context cx, BRecordType type, List<Type> unAnalyzedTypes) {
        if (unAnalyzedTypes.contains(type)) {
            return true;
        }
        unAnalyzedTypes.add(type);
        for (Field field : type.getFields().values()) {
            if (SymbolFlags.isFlagOn(field.getFlags(), 4096L) || !SymbolFlags.isFlagOn(field.getFlags(), 256L)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkFillerValue(Context cx, BArrayType type, List<Type> unAnalyzedTypes) {
        return type.getState() == ArrayType.ArrayState.OPEN || TypeChecker.hasFillerValue(cx, type.getElementType(), unAnalyzedTypes);
    }

    private static boolean checkFillerValue(Context cx, BObjectType type) {
        MethodType generatedInitMethod = type.getGeneratedInitMethod();
        if (generatedInitMethod == null) {
            return false;
        }
        FunctionType initFuncType = generatedInitMethod.getType();
        boolean noParams = initFuncType.getParameters().length == 0;
        boolean nilReturn = TypeUtils.getImpliedType(initFuncType.getReturnType()).getTag() == 14;
        return noParams && nilReturn;
    }

    private static boolean checkFillerValue(BFiniteType type) {
        return TypeChecker.hasFillerValueInValueSpace(type.getValueSpace());
    }

    private static boolean hasFillerValueInValueSpace(Set<Object> finiteTypeValueSpace) {
        if (finiteTypeValueSpace.size() == 1) {
            return true;
        }
        for (Object value2 : finiteTypeValueSpace) {
            if (value2 != null) continue;
            return true;
        }
        Object firstElement = finiteTypeValueSpace.iterator().next();
        for (Object value3 : finiteTypeValueSpace) {
            if (value3.getClass() == firstElement.getClass()) continue;
            return false;
        }
        if (firstElement instanceof BString) {
            return TypeChecker.containsElement(finiteTypeValueSpace, "");
        }
        if (firstElement instanceof Integer || firstElement instanceof Long || firstElement instanceof BDecimal) {
            return TypeChecker.containsElement(finiteTypeValueSpace, "0");
        }
        if (firstElement instanceof Double) {
            return TypeChecker.containsElement(finiteTypeValueSpace, "0.0");
        }
        if (firstElement instanceof Boolean) {
            return TypeChecker.containsElement(finiteTypeValueSpace, "false");
        }
        return false;
    }

    private static boolean containsElement(Set<Object> valueSpace, String e2) {
        for (Object value2 : valueSpace) {
            if (value2 == null || !value2.toString().equals(e2)) continue;
            return true;
        }
        return false;
    }

    public static Object handleAnydataValues(Object sourceVal, Type targetType) {
        if (!(sourceVal == null || sourceVal instanceof Number || sourceVal instanceof BString || sourceVal instanceof Boolean || sourceVal instanceof BValue)) {
            throw ErrorUtils.createJToBTypeCastError(sourceVal.getClass(), targetType);
        }
        return sourceVal;
    }

    private static BError createTypeCastError(Object value2, Type targetType, List<String> errors2) {
        if (errors2 == null || errors2.isEmpty()) {
            return ErrorUtils.createTypeCastError(value2, targetType);
        }
        return ErrorUtils.createTypeCastError(value2, targetType, CloneUtils.getErrorMessage(errors2, 20));
    }

    static boolean isSimpleBasicSemType(SemType semType) {
        return Core.isSubtypeSimple(semType, SimpleBasicTypeHolder.SIMPLE_BASIC_TYPE);
    }

    static boolean belongToSingleBasicTypeOrString(Context cx, Type type) {
        SemType semType = SemType.tryInto(cx, type);
        return TypeChecker.isSingleBasicType(semType) && Core.isSubtypeSimple(semType, SimpleBasicOrStringTypeHolder.SIMPLE_BASIC_TYPE_OR_STRING);
    }

    private static boolean isSingleBasicType(SemType semType) {
        return Integer.bitCount(semType.all() | semType.some()) == 1;
    }

    private TypeChecker() {
    }

    private static /* synthetic */ boolean lambda$checkValueEqual$22(SemType lhsShape, SemType rhsShape, SemType basicType) {
        return Core.containsBasicType(lhsShape, basicType) && Core.containsBasicType(rhsShape, basicType);
    }

    private static final class ConvertibleCastMaskHolder {
        private static final BasicTypeBitSet CONVERTIBLE_CAST_MASK = ConvertibleCastMaskHolder.createConvertibleCastMask();

        private ConvertibleCastMaskHolder() {
        }

        private static SemType createConvertibleCastMask() {
            return Stream.of(Builder.getIntType(), Builder.getFloatType(), Builder.getDecimalType(), Builder.getStringType(), Builder.getBooleanType()).reduce(Builder.getNeverType(), Core::union);
        }
    }

    private static final class NumericTypeHolder {
        static final SemType NUMERIC_TYPE = NumericTypeHolder.createNumericType();

        private NumericTypeHolder() {
        }

        private static SemType createNumericType() {
            return Stream.of(Builder.getIntType(), Builder.getFloatType(), Builder.getDecimalType()).reduce(Builder.getNeverType(), Core::union);
        }
    }

    private static final class InherentlyImmutableTypeHolder {
        static final SemType INHERENTLY_IMMUTABLE_TYPE = InherentlyImmutableTypeHolder.createInherentlyImmutableType();
        static final BasicTypeBitSet POTENTIALLY_INHERENTLY_IMMUTABLE_TYPE = SemType.from(INHERENTLY_IMMUTABLE_TYPE.all() | INHERENTLY_IMMUTABLE_TYPE.some());

        private InherentlyImmutableTypeHolder() {
        }

        private static SemType createInherentlyImmutableType() {
            return Stream.of(SimpleBasicTypeHolder.SIMPLE_BASIC_TYPE, Builder.getStringType(), Builder.getErrorType(), Builder.getFunctionType(), Builder.getTypeDescType(), Builder.getHandleType(), Builder.getXmlTextType(), Builder.getXmlNeverType(), Builder.getRegexType()).reduce(Builder.getNeverType(), Core::union);
        }
    }

    private static final class RefValueTypeMaskHolder {
        static final SemType REF_TYPE_MASK = RefValueTypeMaskHolder.createRefValueMask();

        private RefValueTypeMaskHolder() {
        }

        private static SemType createRefValueMask() {
            return Stream.of(Builder.getXmlType(), Builder.getMappingType(), Builder.getListType(), Builder.getErrorType(), Builder.getTableType(), Builder.getRegexType()).reduce(Builder.getNeverType(), Core::union);
        }
    }

    private static enum FillerValueResult {
        TRUE,
        FALSE,
        MAYBE;

    }

    private static final class SimpleBasicTypeHolder {
        static final SemType SIMPLE_BASIC_TYPE = SimpleBasicTypeHolder.createSimpleBasicType();

        private SimpleBasicTypeHolder() {
        }

        private static SemType createSimpleBasicType() {
            return Stream.of(Builder.getNilType(), Builder.getBooleanType(), Builder.getIntType(), Builder.getFloatType(), Builder.getDecimalType()).reduce(Builder.getNeverType(), Core::union);
        }
    }

    private static final class SimpleBasicOrStringTypeHolder {
        static final SemType SIMPLE_BASIC_TYPE_OR_STRING = SimpleBasicOrStringTypeHolder.createSimpleBasicOrStringType();

        private SimpleBasicOrStringTypeHolder() {
        }

        private static SemType createSimpleBasicOrStringType() {
            return Stream.of(Builder.getBooleanType(), Builder.getIntType(), Builder.getFloatType(), Builder.getDecimalType(), Builder.getRegexType(), Builder.getStringType()).reduce(Builder.getNeverType(), Core::union);
        }
    }

    static class TypePair {
        Type sourceType;
        Type targetType;

        public TypePair(Type sourceType, Type targetType) {
            this.sourceType = sourceType;
            this.targetType = targetType;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof TypePair)) {
                return false;
            }
            TypePair other = (TypePair)obj;
            return this.sourceType.equals(other.sourceType) && this.targetType.equals(other.targetType);
        }
    }
}

