/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.concurrent.locks.ReentrantLock;

public class TypeInitializer {
    public static final ReentrantLock TYPE_INITIALIZING_GLOBAL_LOCK = new ReentrantLock();
    private static final Deque<Runnable> typeAnnotationFPs = new ArrayDeque<Runnable>();

    public static void loadTypeAnnotations(Runnable loadAnnotationFunc) {
        typeAnnotationFPs.add(loadAnnotationFunc);
        TypeInitializer.loadTypeAnnotations();
    }

    public static void loadTypeAnnotations() {
        if (TYPE_INITIALIZING_GLOBAL_LOCK.getHoldCount() == 1) {
            while (!typeAnnotationFPs.isEmpty()) {
                typeAnnotationFPs.poll().run();
            }
        }
    }
}

