/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.cli;

import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.cli.CliUtil;
import io.ballerina.runtime.internal.cli.Operand;
import io.ballerina.runtime.internal.cli.Option;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class CliSpec {
    private final Option option;
    private final Operand[] operands;
    private final List<Object> mainArgs;
    private final String[] args;

    public CliSpec(Option option, Operand[] operands, String ... args2) {
        this.option = option;
        this.operands = operands;
        this.args = args2;
        this.mainArgs = new ArrayList<Object>();
    }

    public Object[] getMainArgs() {
        this.mainArgs.add(null);
        if (this.option != null) {
            BMap<BString, Object> recordVal = this.option.parseRecord(this.args);
            this.processOperands(this.option.getOperandArgs());
            int optionLocation = this.option.getLocation() + 1;
            this.mainArgs.add(optionLocation, recordVal);
        } else {
            RecordType type = TypeCreator.createRecordType("dummy", null, 1L, new HashMap<String, Field>(), null, true, 6);
            Option dummyOption = new Option(type, 0);
            dummyOption.parseRecord(this.args);
            this.processOperands(dummyOption.getOperandArgs());
        }
        return this.mainArgs.toArray();
    }

    private void processOperands(List<String> operandArgs) {
        int opIndex = 0;
        int argIndex = 0;
        while (argIndex < operandArgs.size() && opIndex < this.operands.length) {
            Object bValue;
            Operand curOperand = this.operands[opIndex++];
            Type typeOp = curOperand.type;
            if (TypeUtils.getImpliedType(typeOp).getTag() == 32) {
                ArrayType arrayType = (ArrayType)typeOp;
                BArray bArray = ValueCreator.createArrayValue(arrayType);
                Type elementType = TypeUtils.getImpliedType(arrayType.getElementType());
                int elementCount = this.getElementCount(this.operands, opIndex);
                while (argIndex < operandArgs.size() - elementCount) {
                    try {
                        bArray.append(CliUtil.getBValue(elementType, operandArgs.get(argIndex++), curOperand.name));
                    }
                    catch (BError error2) {
                        --argIndex;
                        break;
                    }
                }
                bValue = bArray;
            } else {
                bValue = CliUtil.getBValueWithUnionValue(curOperand.type, operandArgs.get(argIndex++), curOperand.name);
            }
            this.mainArgs.add(bValue);
        }
        if (argIndex < operandArgs.size()) {
            throw ErrorCreator.createError(StringUtils.fromString("all operand arguments are not matched"));
        }
        this.handleMainParametersAtTheEnd(opIndex);
    }

    private void handleMainParametersAtTheEnd(int opIndex) {
        while (opIndex < this.operands.length) {
            Operand operand = this.operands[opIndex++];
            Type opType = operand.type;
            if (operand.hasDefaultable || CliUtil.isUnionWithNil(opType)) {
                this.mainArgs.add(null);
                continue;
            }
            if (this.isSupportedArrayType(opType)) {
                this.mainArgs.add(ValueCreator.createArrayValue((ArrayType)opType));
                continue;
            }
            throw ErrorCreator.createError(StringUtils.fromString("missing operand arguments for parameter '" + operand.name + "' of type '" + String.valueOf(opType) + "'"));
        }
    }

    private boolean isSupportedArrayType(Type opType) {
        if (TypeUtils.getImpliedType(opType).getTag() == 32) {
            Type elementType = TypeUtils.getImpliedType(((ArrayType)opType).getElementType());
            return CliUtil.isSupportedType(elementType.getTag());
        }
        return false;
    }

    private int getElementCount(Operand[] operands, int opIndex) {
        int count2 = 0;
        while (opIndex < operands.length && TypeUtils.getImpliedType(operands[opIndex++].type).getTag() != 24) {
            ++count2;
        }
        return count2;
    }
}

