/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.runtime.internal.configurable.providers;

import io.ballerina.identifier.Utils;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.TypeTags;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BNever;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.internal.TypeChecker;
import io.ballerina.runtime.internal.TypeConverter;
import io.ballerina.runtime.internal.configurable.VariableKey;
import io.ballerina.runtime.internal.configurable.exceptions.ConfigException;
import io.ballerina.runtime.internal.errors.ErrorCodes;
import io.ballerina.runtime.internal.types.BFiniteType;
import io.ballerina.runtime.internal.types.BUnionType;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;

public final class ConfigUtils {
    private ConfigUtils() {
    }

    public static BString getFiniteValue(VariableKey key, BUnionType unionType, String value2, String variable) {
        BString stringVal = StringUtils.fromString(value2);
        List<Type> memberTypes = unionType.getMemberTypes();
        for (Type type : memberTypes) {
            if (!((BFiniteType)type).valueSpace.contains(stringVal)) continue;
            return stringVal;
        }
        throw new ConfigException(ErrorCodes.CONFIG_INCOMPATIBLE_TYPE, variable, key.variable, Utils.decodeIdentifier(unionType.toString()), value2);
    }

    public static Object getFiniteBalValue(String strValue, BFiniteType finiteType, VariableKey key, String arg) {
        ArrayList<Object> matchingValues = new ArrayList<Object>();
        for (Object value2 : finiteType.getValueSpace()) {
            String stringValue = value2.toString();
            if (!stringValue.equals(strValue)) continue;
            matchingValues.add(value2);
        }
        if (matchingValues.size() == 1) {
            return matchingValues.get(0);
        }
        String typeName = Utils.decodeIdentifier(finiteType.toString());
        if (matchingValues.isEmpty()) {
            throw new ConfigException(ErrorCodes.CONFIG_INCOMPATIBLE_TYPE, arg, key.variable, typeName, strValue);
        }
        throw new ConfigException(ErrorCodes.CONFIG_UNION_VALUE_AMBIGUOUS_TARGET, arg, key.variable, typeName);
    }

    public static boolean containsUnsupportedMembers(BUnionType unionType) {
        for (Type memberType : unionType.getMemberTypes()) {
            if (ConfigUtils.isPrimitiveOrSequenceOrFiniteType(TypeUtils.getImpliedType(memberType).getTag())) continue;
            return true;
        }
        return false;
    }

    private static boolean isPrimitiveOrSequenceOrFiniteType(int tag) {
        return tag == 14 || tag <= 6 || TypeTags.isXMLTypeTag(tag) || tag == 46;
    }

    public static Object getUnionValue(VariableKey key, BUnionType unionType, String value2, String arg) {
        List<Object> matchingValues = ConfigUtils.getConvertibleMemberValues(value2, unionType);
        ArrayList<Object> assignableValues = new ArrayList<Object>();
        if (matchingValues.size() == 1) {
            return matchingValues.getFirst();
        }
        for (int i = 0; i < unionType.getMemberTypes().size() && i < matchingValues.size(); ++i) {
            if (!TypeChecker.checkIsType(matchingValues.get(i), unionType.getMemberTypes().get(i))) continue;
            assignableValues.add(matchingValues.get(i));
        }
        if (assignableValues.size() == 1) {
            return assignableValues.getFirst();
        }
        String typeName = Utils.decodeIdentifier(unionType.toString());
        if (assignableValues.isEmpty()) {
            throw new ConfigException(ErrorCodes.CONFIG_INCOMPATIBLE_TYPE, arg, key.variable, typeName, value2);
        }
        throw new ConfigException(ErrorCodes.CONFIG_UNION_VALUE_AMBIGUOUS_TARGET, arg, key.variable, typeName);
    }

    private static List<Object> getConvertibleMemberValues(String value2, UnionType unionType) {
        ArrayList<Object> matchingValues = new ArrayList<Object>();
        for (Type type : unionType.getMemberTypes()) {
            ConfigUtils.addMatchingValues(type, matchingValues, value2);
        }
        return matchingValues;
    }

    private static void addMatchingValues(Type type, List<Object> matchingValues, String value2) {
        Type impliedType = TypeUtils.getImpliedType(type);
        switch (impliedType.getTag()) {
            case 14: {
                matchingValues.add(BNever.getValue());
                break;
            }
            case 2: {
                ConfigUtils.convertAndGetValuesFromString(matchingValues, TypeConverter::stringToByte, value2);
                break;
            }
            case 1: {
                ConfigUtils.convertAndGetValuesFromString(matchingValues, TypeConverter::stringToInt, value2);
                break;
            }
            case 6: {
                ConfigUtils.convertAndGetValuesFromString(matchingValues, TypeConverter::stringToBoolean, value2);
                break;
            }
            case 3: {
                ConfigUtils.convertAndGetValuesFromString(matchingValues, TypeConverter::stringToFloat, value2);
                break;
            }
            case 4: {
                ConfigUtils.convertAndGetValuesFromString(matchingValues, TypeConverter::stringToDecimal, value2);
                break;
            }
            case 5: {
                ConfigUtils.convertAndGetValuesFromString(matchingValues, StringUtils::fromString, value2);
                break;
            }
            case 53: {
                ConfigUtils.addMatchingValues(type.getCachedReferredType(), matchingValues, value2);
                break;
            }
            case 46: {
                ConfigUtils.addMatchingValues(TypeUtils.getType(((LinkedHashSet)((BFiniteType)impliedType).getValueSpace()).getFirst()), matchingValues, value2);
                break;
            }
            default: {
                ConfigUtils.convertAndGetValuesFromString(matchingValues, TypeConverter::stringToXml, value2);
            }
        }
    }

    private static void convertAndGetValuesFromString(List<Object> matchingValues, Function<String, Object> convertFunc, String value2) {
        Object unionValue;
        try {
            unionValue = convertFunc.apply(value2);
        }
        catch (BError | NumberFormatException e2) {
            return;
        }
        matchingValues.add(unionValue);
    }
}

